/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.config.keys.OpenSshCertificate$Type;

public interface OpenSshCertificate
extends PrivateKey,
PublicKey {
    public static final long MIN_EPOCH = 0L;
    public static final long INFINITY = -1L;

    public String getRawKeyType();

    public byte[] getNonce();

    public String getKeyType();

    public PublicKey getCertPubKey();

    public long getSerial();

    public OpenSshCertificate$Type getType();

    public String getId();

    public Collection getPrincipals();

    public long getValidAfter();

    public long getValidBefore();

    public List getCriticalOptions();

    public List getExtensions();

    public String getReserved();

    public PublicKey getCaPubKey();

    public byte[] getMessage();

    public byte[] getSignature();

    public String getSignatureAlgorithm();

    public byte[] getRawSignature();

    public static boolean isValidNow(OpenSshCertificate openSshCertificate) {
        long l2 = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        return Long.compareUnsigned(openSshCertificate.getValidAfter(), l2) <= 0 && Long.compareUnsigned(l2, openSshCertificate.getValidBefore()) < 0;
    }
}

