/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.config.keys.impl.DSSPublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.impl.ECDSAPublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.impl.OpenSSHCertificateDecoder;
import org.apache.sshd.common.config.keys.impl.RSAPublicKeyDecoder;
import org.apache.sshd.common.config.keys.impl.SkECDSAPublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.impl.SkED25519PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.u2f.SkED25519PublicKey;
import org.apache.sshd.common.config.keys.u2f.SkEcdsaPublicKey;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.digest.DigestFactory;
import org.apache.sshd.common.digest.DigestUtils;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils$MapBuilder;
import org.apache.sshd.common.util.MapEntryUtils$NavigableMapBuilder;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public final class KeyUtils {
    public static final String RSA_ALGORITHM = "RSA";
    public static final BigInteger DEFAULT_RSA_PUBLIC_EXPONENT = BigInteger.valueOf(65537L);
    public static final String DSS_ALGORITHM = "DSA";
    public static final String EC_ALGORITHM = "EC";
    public static final Set STRICTLY_PROHIBITED_FILE_PERMISSION = Collections.unmodifiableSet(EnumSet.of(PosixFilePermission.GROUP_READ, new PosixFilePermission[]{PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_EXECUTE}));
    public static final String KEY_FINGERPRINT_FACTORY_PROP = "org.apache.sshd.keyFingerprintFactory";
    public static final DigestFactory DEFAULT_FINGERPRINT_DIGEST_FACTORY = BuiltinDigests.sha256;
    public static final String RSA_SHA256_KEY_TYPE_ALIAS = "rsa-sha2-256";
    public static final String RSA_SHA512_KEY_TYPE_ALIAS = "rsa-sha2-512";
    public static final String RSA_SHA256_CERT_TYPE_ALIAS = "rsa-sha2-256-cert-v01@openssh.com";
    public static final String RSA_SHA512_CERT_TYPE_ALIAS = "rsa-sha2-512-cert-v01@openssh.com";
    private static final AtomicReference DEFAULT_DIGEST_HOLDER = new AtomicReference();
    private static final Map BY_KEY_TYPE_DECODERS_MAP = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private static final Map BY_KEY_CLASS_DECODERS_MAP = new LinkedHashMap();
    private static final Map KEY_TYPE_ALIASES = MapEntryUtils$NavigableMapBuilder.builder(String.CASE_INSENSITIVE_ORDER).put("rsa-sha2-256", "ssh-rsa").put("rsa-sha2-512", "ssh-rsa").put("rsa-sha2-256-cert-v01@openssh.com", "ssh-rsa-cert-v01@openssh.com").put("rsa-sha2-512-cert-v01@openssh.com", "ssh-rsa-cert-v01@openssh.com").build();
    private static final Map SIGNATURE_ALGORITHM_MAP = MapEntryUtils$MapBuilder.builder().put("rsa-sha2-256-cert-v01@openssh.com", "rsa-sha2-256").put("rsa-sha2-512-cert-v01@openssh.com", "rsa-sha2-512").put("ssh-rsa-cert-v01@openssh.com", "ssh-rsa").put("ssh-dss-cert-v01@openssh.com", "ssh-dss").put("ssh-ed25519-cert-v01@openssh.com", "ssh-ed25519").put("ecdsa-sha2-nistp256-cert-v01@openssh.com", KeyPairProvider.ECDSA_SHA2_NISTP256).put("ecdsa-sha2-nistp384-cert-v01@openssh.com", KeyPairProvider.ECDSA_SHA2_NISTP384).put("ecdsa-sha2-nistp521-cert-v01@openssh.com", KeyPairProvider.ECDSA_SHA2_NISTP521).build();

    private KeyUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static AbstractMap.SimpleImmutableEntry validateStrictKeyFilePermissions(Path path, LinkOption ... linkOptionArray) {
        String string;
        Object object;
        Object object2;
        if (path == null || !Files.exists(path, linkOptionArray)) {
            return null;
        }
        if (OsUtils.isAndroid()) {
            return null;
        }
        Set set = IoUtils.getPermissions(path, linkOptionArray);
        if (GenericUtils.isEmpty(set)) {
            return null;
        }
        if (set.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            PosixFilePermission posixFilePermission = PosixFilePermission.OTHERS_EXECUTE;
            return new AbstractMap.SimpleImmutableEntry<String, PosixFilePermission>(String.format("Permissions violation (%s)", new Object[]{posixFilePermission}), posixFilePermission);
        }
        if (OsUtils.isUNIX()) {
            object2 = IoUtils.validateExcludedPermissions(set, STRICTLY_PROHIBITED_FILE_PERMISSION);
            if (object2 != null) {
                return new AbstractMap.SimpleImmutableEntry<String, PosixFilePermission>(String.format("Permissions violation (%s)", object2), (PosixFilePermission)((Object)object2));
            }
            if (Files.isRegularFile(path, linkOptionArray) && (object2 = IoUtils.validateExcludedPermissions(IoUtils.getPermissions((Path)(object = path.getParent()), linkOptionArray), STRICTLY_PROHIBITED_FILE_PERMISSION)) != null) {
                return new AbstractMap.SimpleImmutableEntry<String, PosixFilePermission>(String.format("Parent permissions violation (%s)", object2), (PosixFilePermission)((Object)object2));
            }
        }
        if (GenericUtils.isEmpty((CharSequence)(object2 = IoUtils.getFileOwner(path, linkOptionArray)))) {
            return null;
        }
        object = OsUtils.getCurrentUser();
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(object);
        if (OsUtils.isUNIX()) {
            hashSet.add("root");
        }
        if (!hashSet.contains(object2)) {
            return new AbstractMap.SimpleImmutableEntry<String, PosixFilePermission>(String.format("Owner violation (%s)", object2), (PosixFilePermission)((Object)object2));
        }
        if (OsUtils.isUNIX() && Files.isRegularFile(path, linkOptionArray) && !GenericUtils.isEmpty(string = IoUtils.getFileOwner(path.getParent(), linkOptionArray)) && !hashSet.contains(string)) {
            return new AbstractMap.SimpleImmutableEntry<String, String>(String.format("Parent owner violation (%s)", string), string);
        }
        return null;
    }

    public static PublicKey loadPublicKey(Path path) {
        List list = AuthorizedKeyEntry.readAuthorizedKeys(Objects.requireNonNull(path), new OpenOption[0]);
        if (GenericUtils.isEmpty(list)) {
            return null;
        }
        if (list.size() > 1) {
            throw new InvalidKeySpecException("Public key file contains multiple entries: " + path);
        }
        return ((AuthorizedKeyEntry)list.get(0)).resolvePublicKey(null, PublicKeyEntryResolver.IGNORING);
    }

    public static KeyPair generateKeyPair(String string, int n2) {
        PublicKeyEntryDecoder publicKeyEntryDecoder = KeyUtils.getPublicKeyEntryDecoder(string);
        if (publicKeyEntryDecoder == null) {
            throw new InvalidKeySpecException("No decoder for key type=" + string);
        }
        return publicKeyEntryDecoder.generateKeyPair(n2);
    }

    public static KeyPair cloneKeyPair(String string, KeyPair keyPair) {
        PublicKeyEntryDecoder publicKeyEntryDecoder = KeyUtils.getPublicKeyEntryDecoder(string);
        if (publicKeyEntryDecoder == null) {
            throw new InvalidKeySpecException("No decoder for key type=" + string);
        }
        return publicKeyEntryDecoder.cloneKeyPair(keyPair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPublicKeyEntryDecoder(PublicKeyEntryDecoder publicKeyEntryDecoder) {
        Objects.requireNonNull(publicKeyEntryDecoder, "No decoder specified");
        Class clazz = Objects.requireNonNull(publicKeyEntryDecoder.getPublicKeyType(), "No public key type declared");
        Class clazz2 = Objects.requireNonNull(publicKeyEntryDecoder.getPrivateKeyType(), "No private key type declared");
        Map map = BY_KEY_CLASS_DECODERS_MAP;
        synchronized (map) {
            BY_KEY_CLASS_DECODERS_MAP.put(clazz, publicKeyEntryDecoder);
            BY_KEY_CLASS_DECODERS_MAP.put(clazz2, publicKeyEntryDecoder);
        }
        KeyUtils.registerPublicKeyEntryDecoderKeyTypes(publicKeyEntryDecoder);
    }

    public static void registerPublicKeyEntryDecoderKeyTypes(PublicKeyEntryDecoder publicKeyEntryDecoder) {
        Objects.requireNonNull(publicKeyEntryDecoder, "No decoder specified");
        Collection collection = ValidateUtils.checkNotNullAndNotEmpty(publicKeyEntryDecoder.getSupportedKeyTypes(), "No supported key types", new Object[0]);
        for (String string : collection) {
            PublicKeyEntryDecoder publicKeyEntryDecoder2 = KeyUtils.registerPublicKeyEntryDecoderForKeyType(string, publicKeyEntryDecoder);
            if (publicKeyEntryDecoder2 == null) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKeyEntryDecoder registerPublicKeyEntryDecoderForKeyType(String string, PublicKeyEntryDecoder publicKeyEntryDecoder) {
        string = ValidateUtils.checkNotNullAndNotEmpty(string, "No key type specified");
        Objects.requireNonNull(publicKeyEntryDecoder, "No decoder specified");
        Map map = BY_KEY_TYPE_DECODERS_MAP;
        synchronized (map) {
            return BY_KEY_TYPE_DECODERS_MAP.put(string, publicKeyEntryDecoder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableSet unregisterPublicKeyEntryDecoder(PublicKeyEntryDecoder publicKeyEntryDecoder) {
        Objects.requireNonNull(publicKeyEntryDecoder, "No decoder specified");
        Class clazz = Objects.requireNonNull(publicKeyEntryDecoder.getPublicKeyType(), "No public key type declared");
        Class clazz2 = Objects.requireNonNull(publicKeyEntryDecoder.getPrivateKeyType(), "No private key type declared");
        Map map = BY_KEY_CLASS_DECODERS_MAP;
        synchronized (map) {
            BY_KEY_CLASS_DECODERS_MAP.remove(clazz);
            BY_KEY_CLASS_DECODERS_MAP.remove(clazz2);
        }
        return KeyUtils.unregisterPublicKeyEntryDecoderKeyTypes(publicKeyEntryDecoder);
    }

    public static NavigableSet unregisterPublicKeyEntryDecoderKeyTypes(PublicKeyEntryDecoder publicKeyEntryDecoder) {
        Objects.requireNonNull(publicKeyEntryDecoder, "No decoder specified");
        Collection collection = ValidateUtils.checkNotNullAndNotEmpty(publicKeyEntryDecoder.getSupportedKeyTypes(), "No supported key types", new Object[0]);
        NavigableSet<String> navigableSet = Collections.emptyNavigableSet();
        for (String string : collection) {
            PublicKeyEntryDecoder publicKeyEntryDecoder2 = KeyUtils.unregisterPublicKeyEntryDecoderForKeyType(string);
            if (publicKeyEntryDecoder2 == null) continue;
            if (navigableSet.isEmpty()) {
                navigableSet = new TreeSet(String.CASE_INSENSITIVE_ORDER);
            }
            if (navigableSet.add(string)) continue;
        }
        return navigableSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKeyEntryDecoder unregisterPublicKeyEntryDecoderForKeyType(String string) {
        string = ValidateUtils.checkNotNullAndNotEmpty(string, "No key type specified");
        Map map = BY_KEY_TYPE_DECODERS_MAP;
        synchronized (map) {
            return (PublicKeyEntryDecoder)BY_KEY_TYPE_DECODERS_MAP.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKeyEntryDecoder getPublicKeyEntryDecoder(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        Map map = BY_KEY_TYPE_DECODERS_MAP;
        synchronized (map) {
            return (PublicKeyEntryDecoder)BY_KEY_TYPE_DECODERS_MAP.get(string);
        }
    }

    public static PublicKeyEntryDecoder getPublicKeyEntryDecoder(KeyPair keyPair) {
        PublicKeyEntryDecoder publicKeyEntryDecoder;
        if (keyPair == null) {
            return null;
        }
        PublicKeyEntryDecoder publicKeyEntryDecoder2 = KeyUtils.getPublicKeyEntryDecoder(keyPair.getPublic());
        if (publicKeyEntryDecoder2 == (publicKeyEntryDecoder = KeyUtils.getPublicKeyEntryDecoder(keyPair.getPrivate()))) {
            return publicKeyEntryDecoder2;
        }
        return null;
    }

    public static PublicKeyEntryDecoder getPublicKeyEntryDecoder(Key key) {
        if (key == null) {
            return null;
        }
        return KeyUtils.getPublicKeyEntryDecoder(key.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKeyEntryDecoder getPublicKeyEntryDecoder(Class clazz) {
        if (clazz == null || !Key.class.isAssignableFrom(clazz)) {
            return null;
        }
        Map map = BY_KEY_TYPE_DECODERS_MAP;
        synchronized (map) {
            PublicKeyEntryDecoder publicKeyEntryDecoder = (PublicKeyEntryDecoder)BY_KEY_CLASS_DECODERS_MAP.get(clazz);
            if (publicKeyEntryDecoder != null) {
                return publicKeyEntryDecoder;
            }
            for (PublicKeyEntryDecoder publicKeyEntryDecoder2 : BY_KEY_CLASS_DECODERS_MAP.values()) {
                Class clazz2 = publicKeyEntryDecoder2.getPublicKeyType();
                Class clazz3 = publicKeyEntryDecoder2.getPrivateKeyType();
                if (!clazz2.isAssignableFrom(clazz) && !clazz3.isAssignableFrom(clazz)) continue;
                return publicKeyEntryDecoder2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DigestFactory getDefaultFingerPrintFactory() {
        DigestFactory digestFactory = null;
        AtomicReference atomicReference = DEFAULT_DIGEST_HOLDER;
        synchronized (atomicReference) {
            digestFactory = (DigestFactory)DEFAULT_DIGEST_HOLDER.get();
            if (digestFactory != null) {
                return digestFactory;
            }
            String string = System.getProperty(KEY_FINGERPRINT_FACTORY_PROP);
            digestFactory = GenericUtils.isEmpty(string) ? DEFAULT_FINGERPRINT_DIGEST_FACTORY : (DigestFactory)ValidateUtils.checkNotNull((Object)BuiltinDigests.fromFactoryName(string), "Unknown digest factory: %s", (Object)string);
            ValidateUtils.checkTrue(digestFactory.isSupported(), "Selected fingerprint digest not supported: %s", (Object)digestFactory.getName());
            DEFAULT_DIGEST_HOLDER.set(digestFactory);
        }
        return digestFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultFingerPrintFactory(DigestFactory digestFactory) {
        AtomicReference atomicReference = DEFAULT_DIGEST_HOLDER;
        synchronized (atomicReference) {
            DEFAULT_DIGEST_HOLDER.set(Objects.requireNonNull(digestFactory, "No digest factory"));
        }
    }

    public static String getFingerPrint(PublicKey publicKey) {
        return KeyUtils.getFingerPrint((Factory)KeyUtils.getDefaultFingerPrintFactory(), publicKey);
    }

    public static String getFingerPrint(String string) {
        return KeyUtils.getFingerPrint(string, StandardCharsets.UTF_8);
    }

    public static String getFingerPrint(String string, Charset charset) {
        return KeyUtils.getFingerPrint(KeyUtils.getDefaultFingerPrintFactory(), string, charset);
    }

    public static String getFingerPrint(Factory factory, PublicKey publicKey) {
        return publicKey == null ? null : KeyUtils.getFingerPrint((Digest)Objects.requireNonNull(factory, "No digest factory").create(), publicKey);
    }

    public static String getFingerPrint(Digest digest, PublicKey publicKey) {
        if (publicKey == null) {
            return null;
        }
        try {
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
            byteArrayBuffer.putRawPublicKey(publicKey);
            return DigestUtils.getFingerPrint(digest, ((Buffer)byteArrayBuffer).array(), 0, ((Buffer)byteArrayBuffer).wpos());
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }

    public static byte[] getRawFingerprint(PublicKey publicKey) {
        return KeyUtils.getRawFingerprint(KeyUtils.getDefaultFingerPrintFactory(), publicKey);
    }

    public static byte[] getRawFingerprint(Factory factory, PublicKey publicKey) {
        return publicKey == null ? null : KeyUtils.getRawFingerprint((Digest)Objects.requireNonNull(factory, "No digest factory").create(), publicKey);
    }

    public static byte[] getRawFingerprint(Digest digest, PublicKey publicKey) {
        if (publicKey == null) {
            return null;
        }
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        byteArrayBuffer.putRawPublicKey(publicKey);
        return DigestUtils.getRawFingerprint(digest, ((Buffer)byteArrayBuffer).array(), 0, ((Buffer)byteArrayBuffer).wpos());
    }

    public static String getFingerPrint(Factory factory, String string) {
        return KeyUtils.getFingerPrint(factory, string, StandardCharsets.UTF_8);
    }

    public static String getFingerPrint(Factory factory, String string, Charset charset) {
        return KeyUtils.getFingerPrint((Digest)factory.create(), string, charset);
    }

    public static String getFingerPrint(Digest digest, String string) {
        return KeyUtils.getFingerPrint(digest, string, StandardCharsets.UTF_8);
    }

    public static String getFingerPrint(Digest digest, String string, Charset charset) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        try {
            return DigestUtils.getFingerPrint(digest, string, charset);
        }
        catch (Exception exception) {
            return exception.getClass().getSimpleName();
        }
    }

    public static AbstractMap.SimpleImmutableEntry checkFingerPrint(String string, PublicKey publicKey) {
        return KeyUtils.checkFingerPrint(string, KeyUtils.getDefaultFingerPrintFactory(), publicKey);
    }

    public static AbstractMap.SimpleImmutableEntry checkFingerPrint(String string, Factory factory, PublicKey publicKey) {
        return KeyUtils.checkFingerPrint(string, (Digest)Objects.requireNonNull(factory, "No digest factory").create(), publicKey);
    }

    public static AbstractMap.SimpleImmutableEntry checkFingerPrint(String string, Digest digest, PublicKey publicKey) {
        BuiltinDigests builtinDigests;
        if (publicKey == null) {
            return null;
        }
        if (GenericUtils.isEmpty(string)) {
            return new AbstractMap.SimpleImmutableEntry<Boolean, String>(false, KeyUtils.getFingerPrint(digest, publicKey));
        }
        int n2 = string.indexOf(58);
        if (n2 < 0 || n2 >= string.length() - 1) {
            return new AbstractMap.SimpleImmutableEntry<Boolean, String>(false, KeyUtils.getFingerPrint(digest, publicKey));
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        if (string2.length() > 2) {
            builtinDigests = BuiltinDigests.fromFactoryName(string2);
            if (builtinDigests == null) {
                return new AbstractMap.SimpleImmutableEntry<Boolean, String>(false, KeyUtils.getFingerPrint(digest, publicKey));
            }
            string = string2.toUpperCase() + ":" + string3;
        } else {
            builtinDigests = BuiltinDigests.md5;
            string = builtinDigests.getName().toUpperCase() + ":" + string;
        }
        String string4 = KeyUtils.getFingerPrint((Factory)builtinDigests, publicKey);
        boolean bl2 = BuiltinDigests.md5.getName().equals(builtinDigests.getName()) ? string.equalsIgnoreCase(string4) : string.equals(string4);
        return new AbstractMap.SimpleImmutableEntry<Boolean, String>(bl2, string4);
    }

    public static String getKeyType(KeyPair keyPair) {
        if (keyPair == null) {
            return null;
        }
        PrivateKey privateKey = keyPair.getPrivate();
        if (privateKey != null) {
            return KeyUtils.getKeyType(privateKey);
        }
        return KeyUtils.getKeyType(keyPair.getPublic());
    }

    public static String getKeyType(Key key) {
        if (key == null) {
            return null;
        }
        if (key instanceof DSAKey) {
            return "ssh-dss";
        }
        if (key instanceof RSAKey) {
            return "ssh-rsa";
        }
        if (key instanceof ECKey) {
            ECKey eCKey = (ECKey)((Object)key);
            ECParameterSpec eCParameterSpec = eCKey.getParams();
            ECCurves eCCurves = ECCurves.fromCurveParameters(eCParameterSpec);
            if (eCCurves == null) {
                return null;
            }
            return eCCurves.getKeyType();
        }
        if (key instanceof SkEcdsaPublicKey) {
            return "sk-ecdsa-sha2-nistp256@openssh.com";
        }
        if ("EdDSA".equalsIgnoreCase(key.getAlgorithm())) {
            return "ssh-ed25519";
        }
        if (key instanceof SkED25519PublicKey) {
            return "sk-ssh-ed25519@openssh.com";
        }
        if (key instanceof OpenSshCertificate) {
            return ((OpenSshCertificate)key).getKeyType();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllEquivalentKeyTypes(String string) {
        if (GenericUtils.isEmpty(string)) {
            return Collections.emptyList();
        }
        String string2 = KeyUtils.getCanonicalKeyType(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        Map map = KEY_TYPE_ALIASES;
        synchronized (map) {
            for (Map.Entry entry : KEY_TYPE_ALIASES.entrySet()) {
                String string3 = (String)entry.getKey();
                String string4 = (String)entry.getValue();
                if (!string2.equalsIgnoreCase(string4)) continue;
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCanonicalKeyType(String string) {
        String string2;
        if (GenericUtils.isEmpty(string)) {
            return string;
        }
        Map map = KEY_TYPE_ALIASES;
        synchronized (map) {
            string2 = (String)KEY_TYPE_ALIASES.get(string);
        }
        if (GenericUtils.isEmpty(string2)) {
            return string;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableSet getRegisteredKeyTypeAliases() {
        Map map = KEY_TYPE_ALIASES;
        synchronized (map) {
            return KEY_TYPE_ALIASES.isEmpty() ? Collections.emptyNavigableSet() : GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, KEY_TYPE_ALIASES.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List registerCanonicalKeyTypes(String string, Collection collection) {
        ValidateUtils.checkNotNullAndNotEmpty(string, "No key type value");
        ValidateUtils.checkNotNullAndNotEmpty(collection, "No aliases provided", new Object[0]);
        List list = Collections.emptyList();
        Map map = KEY_TYPE_ALIASES;
        synchronized (map) {
            for (String string2 : collection) {
                ValidateUtils.checkNotNullAndNotEmpty(string2, "Null/empty alias registration for %s", (Object)string);
                String string3 = KEY_TYPE_ALIASES.put(string2, string);
                if (GenericUtils.isEmpty(string3)) continue;
                if (list.isEmpty()) {
                    list = new ArrayList();
                }
                list.add(string3);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unregisterCanonicalKeyTypeAlias(String string) {
        if (GenericUtils.isEmpty(string)) {
            return string;
        }
        Map map = KEY_TYPE_ALIASES;
        synchronized (map) {
            return (String)KEY_TYPE_ALIASES.remove(string);
        }
    }

    public static int getKeySize(Key key) {
        if (key == null) {
            return -1;
        }
        if (key instanceof RSAKey) {
            BigInteger bigInteger = ((RSAKey)((Object)key)).getModulus();
            return bigInteger.bitLength();
        }
        if (key instanceof DSAKey) {
            DSAParams dSAParams = ((DSAKey)((Object)key)).getParams();
            BigInteger bigInteger = dSAParams.getP();
            return bigInteger.bitLength();
        }
        if (key instanceof ECKey) {
            ECParameterSpec eCParameterSpec = ((ECKey)((Object)key)).getParams();
            ECCurves eCCurves = ECCurves.fromCurveParameters(eCParameterSpec);
            if (eCCurves != null) {
                return eCCurves.getKeySize();
            }
        } else if ("EdDSA".equalsIgnoreCase(key.getAlgorithm())) {
            return SecurityUtils.getEDDSAKeySize(key);
        }
        return -1;
    }

    public static PublicKey findMatchingKey(PublicKey publicKey, PublicKey ... publicKeyArray) {
        if (publicKey == null || GenericUtils.isEmpty(publicKeyArray)) {
            return null;
        }
        return KeyUtils.findMatchingKey(publicKey, Arrays.asList(publicKeyArray));
    }

    public static PublicKey findMatchingKey(PublicKey publicKey, Collection collection) {
        if (publicKey == null || GenericUtils.isEmpty(collection)) {
            return null;
        }
        for (PublicKey publicKey2 : collection) {
            if (!KeyUtils.compareKeys(publicKey, publicKey2)) continue;
            return publicKey2;
        }
        return null;
    }

    public static boolean compareKeyPairs(KeyPair keyPair, KeyPair keyPair2) {
        if (Objects.equals(keyPair, keyPair2)) {
            return true;
        }
        if (keyPair == null || keyPair2 == null) {
            return false;
        }
        return KeyUtils.compareKeys(keyPair.getPublic(), keyPair2.getPublic()) && KeyUtils.compareKeys(keyPair.getPrivate(), keyPair2.getPrivate());
    }

    public static boolean compareKeys(PublicKey publicKey, PublicKey publicKey2) {
        if (publicKey instanceof RSAPublicKey && publicKey2 instanceof RSAPublicKey) {
            return KeyUtils.compareRSAKeys((RSAPublicKey)RSAPublicKey.class.cast(publicKey), (RSAPublicKey)RSAPublicKey.class.cast(publicKey2));
        }
        if (publicKey instanceof DSAPublicKey && publicKey2 instanceof DSAPublicKey) {
            return KeyUtils.compareDSAKeys((DSAPublicKey)DSAPublicKey.class.cast(publicKey), (DSAPublicKey)DSAPublicKey.class.cast(publicKey2));
        }
        if (publicKey instanceof ECPublicKey && publicKey2 instanceof ECPublicKey) {
            return KeyUtils.compareECKeys((ECPublicKey)ECPublicKey.class.cast(publicKey), (ECPublicKey)ECPublicKey.class.cast(publicKey2));
        }
        if (publicKey instanceof SkEcdsaPublicKey && publicKey2 instanceof SkEcdsaPublicKey) {
            return KeyUtils.compareSkEcdsaKeys((SkEcdsaPublicKey)SkEcdsaPublicKey.class.cast(publicKey), (SkEcdsaPublicKey)SkEcdsaPublicKey.class.cast(publicKey2));
        }
        if (publicKey != null && "EdDSA".equalsIgnoreCase(publicKey.getAlgorithm()) && publicKey2 != null && "EdDSA".equalsIgnoreCase(publicKey2.getAlgorithm())) {
            return SecurityUtils.compareEDDSAPPublicKeys(publicKey, publicKey2);
        }
        if (publicKey instanceof SkED25519PublicKey && publicKey2 instanceof SkED25519PublicKey) {
            return KeyUtils.compareSkEd25519Keys((SkED25519PublicKey)SkED25519PublicKey.class.cast(publicKey), (SkED25519PublicKey)SkED25519PublicKey.class.cast(publicKey2));
        }
        if (publicKey instanceof OpenSshCertificate && publicKey2 instanceof OpenSshCertificate) {
            return KeyUtils.compareOpenSSHCertificateKeys((OpenSshCertificate)OpenSshCertificate.class.cast(publicKey), (OpenSshCertificate)OpenSshCertificate.class.cast(publicKey2));
        }
        return false;
    }

    public static PublicKey recoverPublicKey(PrivateKey privateKey) {
        if (privateKey instanceof RSAPrivateKey) {
            return KeyUtils.recoverRSAPublicKey((RSAPrivateKey)privateKey);
        }
        if (privateKey instanceof DSAPrivateKey) {
            return KeyUtils.recoverDSAPublicKey((DSAPrivateKey)privateKey);
        }
        if (privateKey != null && "EdDSA".equalsIgnoreCase(privateKey.getAlgorithm())) {
            return SecurityUtils.recoverEDDSAPublicKey(privateKey);
        }
        return null;
    }

    public static boolean compareKeys(PrivateKey privateKey, PrivateKey privateKey2) {
        if (privateKey instanceof RSAPrivateKey && privateKey2 instanceof RSAPrivateKey) {
            return KeyUtils.compareRSAKeys((RSAPrivateKey)RSAPrivateKey.class.cast(privateKey), (RSAPrivateKey)RSAPrivateKey.class.cast(privateKey2));
        }
        if (privateKey instanceof DSAPrivateKey && privateKey2 instanceof DSAPrivateKey) {
            return KeyUtils.compareDSAKeys((DSAPrivateKey)DSAPrivateKey.class.cast(privateKey), (DSAPrivateKey)DSAPrivateKey.class.cast(privateKey2));
        }
        if (privateKey instanceof ECPrivateKey && privateKey2 instanceof ECPrivateKey) {
            return KeyUtils.compareECKeys((ECPrivateKey)ECPrivateKey.class.cast(privateKey), (ECPrivateKey)ECPrivateKey.class.cast(privateKey2));
        }
        if (privateKey != null && "EdDSA".equalsIgnoreCase(privateKey.getAlgorithm()) && privateKey2 != null && "EdDSA".equalsIgnoreCase(privateKey2.getAlgorithm())) {
            return SecurityUtils.compareEDDSAPrivateKeys(privateKey, privateKey2);
        }
        return false;
    }

    public static boolean compareRSAKeys(RSAPublicKey rSAPublicKey, RSAPublicKey rSAPublicKey2) {
        if (Objects.equals(rSAPublicKey, rSAPublicKey2)) {
            return true;
        }
        if (rSAPublicKey == null || rSAPublicKey2 == null) {
            return false;
        }
        return Objects.equals(rSAPublicKey.getPublicExponent(), rSAPublicKey2.getPublicExponent()) && Objects.equals(rSAPublicKey.getModulus(), rSAPublicKey2.getModulus());
    }

    public static boolean compareRSAKeys(RSAPrivateKey rSAPrivateKey, RSAPrivateKey rSAPrivateKey2) {
        if (Objects.equals(rSAPrivateKey, rSAPrivateKey2)) {
            return true;
        }
        if (rSAPrivateKey == null || rSAPrivateKey2 == null) {
            return false;
        }
        return Objects.equals(rSAPrivateKey.getModulus(), rSAPrivateKey2.getModulus()) && Objects.equals(rSAPrivateKey.getPrivateExponent(), rSAPrivateKey2.getPrivateExponent());
    }

    public static boolean compareOpenSSHCertificateKeys(OpenSshCertificate openSshCertificate, OpenSshCertificate openSshCertificate2) {
        if (openSshCertificate == openSshCertificate2) {
            return true;
        }
        if (openSshCertificate == null || openSshCertificate2 == null) {
            return false;
        }
        return Objects.equals(openSshCertificate.getSerial(), openSshCertificate2.getSerial()) && Arrays.equals(openSshCertificate.getSignature(), openSshCertificate2.getSignature()) && KeyUtils.compareKeys(openSshCertificate.getCertPubKey(), openSshCertificate2.getCertPubKey());
    }

    public static RSAPublicKey recoverRSAPublicKey(RSAPrivateKey rSAPrivateKey) {
        if (rSAPrivateKey instanceof RSAPrivateCrtKey) {
            return KeyUtils.recoverFromRSAPrivateCrtKey((RSAPrivateCrtKey)rSAPrivateKey);
        }
        return KeyUtils.recoverRSAPublicKey(rSAPrivateKey.getModulus(), DEFAULT_RSA_PUBLIC_EXPONENT);
    }

    public static RSAPublicKey recoverFromRSAPrivateCrtKey(RSAPrivateCrtKey rSAPrivateCrtKey) {
        return KeyUtils.recoverRSAPublicKey(rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPublicExponent());
    }

    public static RSAPublicKey recoverRSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return KeyUtils.recoverRSAPublicKey(bigInteger.multiply(bigInteger2), bigInteger3);
    }

    public static RSAPublicKey recoverRSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        KeyFactory keyFactory = SecurityUtils.getKeyFactory(RSA_ALGORITHM);
        return (RSAPublicKey)keyFactory.generatePublic(new RSAPublicKeySpec(bigInteger, bigInteger2));
    }

    public static boolean compareDSAKeys(DSAPublicKey dSAPublicKey, DSAPublicKey dSAPublicKey2) {
        if (Objects.equals(dSAPublicKey, dSAPublicKey2)) {
            return true;
        }
        if (dSAPublicKey == null || dSAPublicKey2 == null) {
            return false;
        }
        return Objects.equals(dSAPublicKey.getY(), dSAPublicKey2.getY()) && KeyUtils.compareDSAParams(dSAPublicKey.getParams(), dSAPublicKey2.getParams());
    }

    public static boolean compareDSAKeys(DSAPrivateKey dSAPrivateKey, DSAPrivateKey dSAPrivateKey2) {
        if (Objects.equals(dSAPrivateKey, dSAPrivateKey2)) {
            return true;
        }
        if (dSAPrivateKey == null || dSAPrivateKey2 == null) {
            return false;
        }
        return Objects.equals(dSAPrivateKey.getX(), dSAPrivateKey2.getX()) && KeyUtils.compareDSAParams(dSAPrivateKey.getParams(), dSAPrivateKey2.getParams());
    }

    public static boolean compareDSAParams(DSAParams dSAParams, DSAParams dSAParams2) {
        if (Objects.equals(dSAParams, dSAParams2)) {
            return true;
        }
        if (dSAParams == null || dSAParams2 == null) {
            return false;
        }
        return Objects.equals(dSAParams.getG(), dSAParams2.getG()) && Objects.equals(dSAParams.getP(), dSAParams2.getP()) && Objects.equals(dSAParams.getQ(), dSAParams2.getQ());
    }

    public static DSAPublicKey recoverDSAPublicKey(DSAPrivateKey dSAPrivateKey) {
        DSAParams dSAParams = dSAPrivateKey.getParams();
        BigInteger bigInteger = dSAParams.getP();
        BigInteger bigInteger2 = dSAPrivateKey.getX();
        BigInteger bigInteger3 = dSAParams.getQ();
        BigInteger bigInteger4 = dSAParams.getG();
        BigInteger bigInteger5 = bigInteger4.modPow(bigInteger2, bigInteger);
        KeyFactory keyFactory = SecurityUtils.getKeyFactory(DSS_ALGORITHM);
        return (DSAPublicKey)keyFactory.generatePublic(new DSAPublicKeySpec(bigInteger5, bigInteger, bigInteger3, bigInteger4));
    }

    public static boolean compareECKeys(ECPrivateKey eCPrivateKey, ECPrivateKey eCPrivateKey2) {
        if (Objects.equals(eCPrivateKey, eCPrivateKey2)) {
            return true;
        }
        if (eCPrivateKey == null || eCPrivateKey2 == null) {
            return false;
        }
        return Objects.equals(eCPrivateKey.getS(), eCPrivateKey2.getS()) && KeyUtils.compareECParams(eCPrivateKey.getParams(), eCPrivateKey2.getParams());
    }

    public static boolean compareECKeys(ECPublicKey eCPublicKey, ECPublicKey eCPublicKey2) {
        if (Objects.equals(eCPublicKey, eCPublicKey2)) {
            return true;
        }
        if (eCPublicKey == null || eCPublicKey2 == null) {
            return false;
        }
        return Objects.equals(eCPublicKey.getW(), eCPublicKey2.getW()) && KeyUtils.compareECParams(eCPublicKey.getParams(), eCPublicKey2.getParams());
    }

    public static boolean compareECParams(ECParameterSpec eCParameterSpec, ECParameterSpec eCParameterSpec2) {
        if (Objects.equals(eCParameterSpec, eCParameterSpec2)) {
            return true;
        }
        if (eCParameterSpec == null || eCParameterSpec2 == null) {
            return false;
        }
        return Objects.equals(eCParameterSpec.getOrder(), eCParameterSpec2.getOrder()) && eCParameterSpec.getCofactor() == eCParameterSpec2.getCofactor() && Objects.equals(eCParameterSpec.getGenerator(), eCParameterSpec2.getGenerator()) && Objects.equals(eCParameterSpec.getCurve(), eCParameterSpec2.getCurve());
    }

    public static boolean compareSkEcdsaKeys(SkEcdsaPublicKey skEcdsaPublicKey, SkEcdsaPublicKey skEcdsaPublicKey2) {
        if (Objects.equals(skEcdsaPublicKey, skEcdsaPublicKey2)) {
            return true;
        }
        if (skEcdsaPublicKey == null || skEcdsaPublicKey2 == null) {
            return false;
        }
        return Objects.equals(skEcdsaPublicKey.getAppName(), skEcdsaPublicKey2.getAppName()) && Objects.equals(skEcdsaPublicKey.isNoTouchRequired(), skEcdsaPublicKey2.isNoTouchRequired()) && KeyUtils.compareECKeys(skEcdsaPublicKey.getDelegatePublicKey(), skEcdsaPublicKey2.getDelegatePublicKey());
    }

    public static boolean compareSkEd25519Keys(SkED25519PublicKey skED25519PublicKey, SkED25519PublicKey skED25519PublicKey2) {
        if (Objects.equals(skED25519PublicKey, skED25519PublicKey2)) {
            return true;
        }
        if (skED25519PublicKey == null || skED25519PublicKey2 == null) {
            return false;
        }
        return Objects.equals(skED25519PublicKey.getAppName(), skED25519PublicKey2.getAppName()) && Objects.equals(skED25519PublicKey.isNoTouchRequired(), skED25519PublicKey2.isNoTouchRequired()) && SecurityUtils.compareEDDSAPPublicKeys(skED25519PublicKey.getDelegatePublicKey(), skED25519PublicKey2.getDelegatePublicKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSignatureAlgorithm(String string, PublicKey publicKey) {
        if (publicKey instanceof OpenSshCertificate) {
            Map map = SIGNATURE_ALGORITHM_MAP;
            synchronized (map) {
                return (String)SIGNATURE_ALGORITHM_MAP.get(string);
            }
        }
        return string;
    }

    static {
        KeyUtils.registerPublicKeyEntryDecoder(OpenSSHCertificateDecoder.INSTANCE);
        KeyUtils.registerPublicKeyEntryDecoder(RSAPublicKeyDecoder.INSTANCE);
        KeyUtils.registerPublicKeyEntryDecoder(DSSPublicKeyEntryDecoder.INSTANCE);
        if (SecurityUtils.isECCSupported()) {
            KeyUtils.registerPublicKeyEntryDecoder(ECDSAPublicKeyEntryDecoder.INSTANCE);
        }
        if (SecurityUtils.isEDDSACurveSupported()) {
            KeyUtils.registerPublicKeyEntryDecoder(SecurityUtils.getEDDSAPublicKeyEntryDecoder());
        }
        if (SecurityUtils.isECCSupported()) {
            KeyUtils.registerPublicKeyEntryDecoder(SkECDSAPublicKeyEntryDecoder.INSTANCE);
        }
        if (SecurityUtils.isEDDSACurveSupported()) {
            KeyUtils.registerPublicKeyEntryDecoder(SkED25519PublicKeyEntryDecoder.INSTANCE);
        }
    }
}

