/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.sshd.common.AlgorithmNameProvider;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.keyprovider.KeySizeIndicator;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class KeyRandomArt
implements AlgorithmNameProvider,
KeySizeIndicator {
    public static final int FLDBASE = 8;
    public static final int FLDSIZE_Y = 9;
    public static final int FLDSIZE_X = 17;
    public static final String AUGMENTATION_STRING = " .o+=*BOX@%&#/^SE";
    private final String algorithm;
    private final int keySize;
    private final char[][] field = new char[17][9];

    public KeyRandomArt(PublicKey publicKey) {
        this(publicKey, KeyUtils.getDefaultFingerPrintFactory());
    }

    public KeyRandomArt(PublicKey publicKey, Factory factory) {
        this(publicKey, (Digest)Objects.requireNonNull(factory, "No digest factory").create());
    }

    public KeyRandomArt(PublicKey publicKey, Digest digest) {
        this(Objects.requireNonNull(publicKey, "No key provided").getAlgorithm(), KeyUtils.getKeySize(publicKey), KeyUtils.getRawFingerprint(Objects.requireNonNull(digest, "No key digest"), publicKey));
    }

    public KeyRandomArt(String string, int n2, byte[] byArray) {
        this.algorithm = ValidateUtils.checkNotNullAndNotEmpty(string, "No algorithm provided");
        ValidateUtils.checkTrue(n2 > 0, "Invalid key size: %d", n2);
        this.keySize = n2;
        Objects.requireNonNull(byArray, "No key digest provided");
        int n3 = 8;
        int n4 = 4;
        int n5 = AUGMENTATION_STRING.length() - 1;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n6 = byArray[i2] & 0xFF;
            for (int i3 = 0; i3 < 4; ++i3) {
                n3 += (n6 & 1) != 0 ? 1 : -1;
                n4 += (n6 & 2) != 0 ? 1 : -1;
                n3 = Math.max(n3, 0);
                n4 = Math.max(n4, 0);
                if (this.field[n3 = Math.min(n3, 16)][n4 = Math.min(n4, 8)] < n5 - 2) {
                    char[] cArray = this.field[n3];
                    int n7 = n4;
                    cArray[n7] = (char)(cArray[n7] + '\u0001');
                }
                n6 >>= 2;
            }
        }
        this.field[8][4] = (char)(n5 - 1);
        this.field[n3][n4] = (char)n5;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    public Appendable append(Appendable appendable) {
        int n2;
        int n3;
        String string = String.format("+--[%4s %4d]", this.getAlgorithm(), this.getKeySize());
        appendable.append(string);
        for (n3 = string.length(); n3 <= 17; ++n3) {
            appendable.append('-');
        }
        appendable.append('+');
        appendable.append('\n');
        n3 = AUGMENTATION_STRING.length() - 1;
        for (n2 = 0; n2 < 9; ++n2) {
            appendable.append('|');
            for (int i2 = 0; i2 < 17; ++i2) {
                char c2 = this.field[i2][n2];
                appendable.append(AUGMENTATION_STRING.charAt(Math.min(c2, n3)));
            }
            appendable.append('|');
            appendable.append('\n');
        }
        appendable.append('+');
        for (n2 = 0; n2 < 17; ++n2) {
            appendable.append('-');
        }
        appendable.append('+');
        appendable.append('\n');
        return appendable;
    }

    public String toString() {
        try {
            return ((StringBuilder)this.append(new StringBuilder(252))).toString();
        }
        catch (IOException iOException) {
            return iOException.getClass().getSimpleName();
        }
    }

    public static String combine(char c2, Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return "";
        }
        try {
            return ((StringBuilder)KeyRandomArt.combine(new StringBuilder(collection.size() * 21 * 12), c2, collection)).toString();
        }
        catch (IOException iOException) {
            return iOException.getClass().getSimpleName();
        }
    }

    public static String combine(SessionContext sessionContext, char c2, KeyIdentityProvider keyIdentityProvider) {
        return ((StringBuilder)KeyRandomArt.combine(sessionContext, new StringBuilder(1008), c2, keyIdentityProvider)).toString();
    }

    public static Appendable combine(SessionContext sessionContext, Appendable appendable, char c2, KeyIdentityProvider keyIdentityProvider) {
        return KeyRandomArt.combine(appendable, c2, KeyRandomArt.generate(sessionContext, keyIdentityProvider));
    }

    public static Collection generate(SessionContext sessionContext, KeyIdentityProvider keyIdentityProvider) {
        Iterator iterator;
        Iterable iterable = keyIdentityProvider == null ? null : keyIdentityProvider.loadKeys(sessionContext);
        Iterator iterator2 = iterator = iterable == null ? null : iterable.iterator();
        if (iterator == null || !iterator.hasNext()) {
            return Collections.emptyList();
        }
        LinkedList<KeyRandomArt> linkedList = new LinkedList<KeyRandomArt>();
        do {
            KeyPair keyPair = (KeyPair)iterator.next();
            KeyRandomArt keyRandomArt = new KeyRandomArt(keyPair.getPublic());
            linkedList.add(keyRandomArt);
        } while (iterator.hasNext());
        return linkedList;
    }

    public static Appendable combine(Appendable appendable, char c2, Collection collection) {
        Object object;
        String[] stringArray;
        if (GenericUtils.isEmpty(collection)) {
            return appendable;
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>(collection.size());
        int n2 = -1;
        for (KeyRandomArt keyRandomArt : collection) {
            stringArray = keyRandomArt.toString();
            object = GenericUtils.split((String)stringArray, '\n');
            if (n2 <= 0) {
                n2 = ((String[])object).length;
            } else if (n2 != ((String[])object).length) {
                throw new StreamCorruptedException("Mismatched lines count: expected=" + n2 + ", actual=" + ((String[])object).length);
            }
            for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
                String string = object[i2];
                if (string.length() <= 0 || string.charAt(string.length() - 1) != '\r') continue;
                object[i2] = string = string.substring(0, string.length() - 1);
            }
            arrayList.add((String[])object);
        }
        for (int i3 = 0; i3 < n2; ++i3) {
            for (int i4 = 0; i4 < arrayList.size(); ++i4) {
                stringArray = (String[])arrayList.get(i4);
                object = stringArray[i3];
                appendable.append((CharSequence)object);
                if (i4 <= 0 || c2 == '\u0000') continue;
                appendable.append(c2);
            }
            appendable.append('\n');
        }
        return appendable;
    }
}

