/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.AbstractMap;
import java.util.Map;
import org.apache.sshd.common.config.keys.IdentityResourceLoader;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.io.IoUtils;

public interface KeyEntryResolver
extends IdentityResourceLoader {
    default public KeyPair generateKeyPair(int n2) {
        KeyPairGenerator keyPairGenerator = this.getKeyPairGenerator();
        keyPairGenerator.initialize(n2);
        return keyPairGenerator.generateKeyPair();
    }

    default public KeyPair cloneKeyPair(KeyPair keyPair) {
        Key key;
        Serializable serializable;
        if (keyPair == null) {
            return null;
        }
        PublicKey publicKey = null;
        PublicKey publicKey2 = keyPair.getPublic();
        Class clazz = this.getPublicKeyType();
        if (publicKey2 != null) {
            serializable = publicKey2.getClass();
            if (!clazz.isAssignableFrom((Class<?>)serializable)) {
                throw new InvalidKeyException("Mismatched public key types: expected=" + clazz.getSimpleName() + ", actual=" + serializable.getSimpleName());
            }
            key = (PublicKey)clazz.cast(publicKey2);
            publicKey = this.clonePublicKey((PublicKey)key);
        }
        serializable = null;
        key = keyPair.getPrivate();
        Class clazz2 = this.getPrivateKeyType();
        if (key != null) {
            Class<?> clazz3 = key.getClass();
            if (!clazz2.isAssignableFrom(clazz3)) {
                throw new InvalidKeyException("Mismatched private key types: expected=" + clazz2.getSimpleName() + ", actual=" + clazz3.getSimpleName());
            }
            PrivateKey privateKey = (PrivateKey)clazz2.cast(key);
            serializable = this.clonePrivateKey(privateKey);
        }
        return new KeyPair(publicKey, (PrivateKey)serializable);
    }

    public PublicKey clonePublicKey(PublicKey var1);

    public PrivateKey clonePrivateKey(PrivateKey var1);

    public KeyPairGenerator getKeyPairGenerator();

    public KeyFactory getKeyFactoryInstance();

    public static int encodeString(OutputStream outputStream, String string) {
        return KeyEntryResolver.encodeString(outputStream, string, StandardCharsets.UTF_8);
    }

    public static int encodeString(OutputStream outputStream, String string, String string2) {
        return KeyEntryResolver.encodeString(outputStream, string, Charset.forName(string2));
    }

    public static int encodeString(OutputStream outputStream, String string, Charset charset) {
        return KeyEntryResolver.writeRLEBytes(outputStream, string.getBytes(charset));
    }

    public static int encodeBigInt(OutputStream outputStream, BigInteger bigInteger) {
        return KeyEntryResolver.writeRLEBytes(outputStream, bigInteger.toByteArray());
    }

    public static int writeRLEBytes(OutputStream outputStream, byte ... byArray) {
        return KeyEntryResolver.writeRLEBytes(outputStream, byArray, 0, byArray.length);
    }

    public static int writeRLEBytes(OutputStream outputStream, byte[] byArray, int n2, int n3) {
        byte[] byArray2 = KeyEntryResolver.encodeInt(outputStream, n3);
        outputStream.write(byArray, n2, n3);
        return byArray2.length + n3;
    }

    public static byte[] encodeInt(OutputStream outputStream, int n2) {
        byte[] byArray = new byte[]{(byte)(n2 >> 24 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)};
        outputStream.write(byArray);
        return byArray;
    }

    public static String decodeString(InputStream inputStream, int n2) {
        return KeyEntryResolver.decodeString(inputStream, StandardCharsets.UTF_8, n2);
    }

    public static String decodeString(InputStream inputStream, String string, int n2) {
        return KeyEntryResolver.decodeString(inputStream, Charset.forName(string), n2);
    }

    public static String decodeString(InputStream inputStream, Charset charset, int n2) {
        byte[] byArray = KeyEntryResolver.readRLEBytes(inputStream, n2 * 4);
        return new String(byArray, charset);
    }

    public static BigInteger decodeBigInt(InputStream inputStream) {
        return new BigInteger(KeyEntryResolver.readRLEBytes(inputStream, Short.MAX_VALUE));
    }

    public static byte[] readRLEBytes(InputStream inputStream, int n2) {
        int n3 = KeyEntryResolver.decodeInt(inputStream);
        if (n3 > n2) {
            throw new StreamCorruptedException("Requested block length (" + n3 + ") exceeds max. allowed (" + n2 + ")");
        }
        if (n3 < 0) {
            throw new StreamCorruptedException("Negative block length requested: " + n3);
        }
        byte[] byArray = new byte[n3];
        IoUtils.readFully(inputStream, byArray);
        return byArray;
    }

    public static int decodeInt(InputStream inputStream) {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        IoUtils.readFully(inputStream, byArray);
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public static Map.Entry decodeString(byte[] byArray, int n2) {
        return KeyEntryResolver.decodeString(byArray, 0, NumberUtils.length(byArray), n2);
    }

    public static Map.Entry decodeString(byte[] byArray, int n2, int n3, int n4) {
        return KeyEntryResolver.decodeString(byArray, n2, n3, StandardCharsets.UTF_8, n4);
    }

    public static Map.Entry decodeString(byte[] byArray, Charset charset, int n2) {
        return KeyEntryResolver.decodeString(byArray, 0, NumberUtils.length(byArray), charset, n2);
    }

    public static Map.Entry decodeString(byte[] byArray, int n2, int n3, Charset charset, int n4) {
        Map.Entry entry = KeyEntryResolver.readRLEBytes(byArray, n2, n3, n4 * 4);
        byte[] byArray2 = (byte[])entry.getKey();
        Integer n5 = (Integer)entry.getValue();
        return new AbstractMap.SimpleImmutableEntry<String, Integer>(new String(byArray2, charset), n5);
    }

    public static Map.Entry readRLEBytes(byte[] byArray, int n2) {
        return KeyEntryResolver.readRLEBytes(byArray, 0, NumberUtils.length(byArray), n2);
    }

    public static Map.Entry readRLEBytes(byte[] byArray, int n2, int n3, int n4) {
        int n5 = KeyEntryResolver.decodeInt(byArray, n2, n3);
        if (n5 > n4) {
            throw new IndexOutOfBoundsException("Requested block length (" + n5 + ") exceeds max. allowed (" + n4 + ")");
        }
        if (n5 < 0) {
            throw new IndexOutOfBoundsException("Negative block length requested: " + n5);
        }
        if (n5 > (n3 -= 4)) {
            throw new IndexOutOfBoundsException("Requested block length (" + n5 + ") exceeds remaing (" + n3 + ")");
        }
        byte[] byArray2 = new byte[n5];
        System.arraycopy(byArray, n2 += 4, byArray2, 0, n5);
        return new AbstractMap.SimpleImmutableEntry<byte[], Integer>(byArray2, n2 + n5);
    }

    public static int decodeInt(byte[] byArray) {
        return KeyEntryResolver.decodeInt(byArray, 0, NumberUtils.length(byArray));
    }

    public static int decodeInt(byte[] byArray, int n2, int n3) {
        if (n3 < 4) {
            throw new IndexOutOfBoundsException("Available data length (" + n3 + ") cannot accommodate integer encoding");
        }
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }
}

