/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.sshd.common.config.keys.BuiltinIdentities;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.keyprovider.MappedKeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.security.SecurityUtils;

public final class IdentityUtils {
    private IdentityUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static String getIdentityFileName(String string, String string2, String string3) {
        if (GenericUtils.isEmpty(string2)) {
            return null;
        }
        return GenericUtils.trimToEmpty(string) + string2.toLowerCase() + GenericUtils.trimToEmpty(string3);
    }

    public static KeyPairProvider createKeyPairProvider(Map map, boolean bl2) {
        if (MapEntryUtils.isEmpty(map)) {
            return null;
        }
        TreeMap treeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        map.forEach((string, keyPair) -> {
            BuiltinIdentities builtinIdentities = BuiltinIdentities.fromName(string);
            if (builtinIdentities == null) {
                builtinIdentities = BuiltinIdentities.fromKeyPair(keyPair);
            }
            if (bl2 && (builtinIdentities == null || !builtinIdentities.isSupported())) {
                return;
            }
            String string2 = KeyUtils.getKeyType(keyPair);
            if (GenericUtils.isEmpty(string2)) {
                return;
            }
            KeyPair keyPair2 = treeMap.put(string2, keyPair);
            if (keyPair2 != null) {
                return;
            }
        });
        if (MapEntryUtils.isEmpty(treeMap)) {
            return null;
        }
        return new MappedKeyPairProvider(treeMap);
    }

    public static NavigableMap loadIdentities(SessionContext sessionContext, Map map, FilePasswordProvider filePasswordProvider, OpenOption ... openOptionArray) {
        if (MapEntryUtils.isEmpty(map)) {
            return Collections.emptyNavigableMap();
        }
        TreeMap<String, Throwable> treeMap = new TreeMap<String, Throwable>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry entry : map.entrySet()) {
            Iterable iterable;
            String string = (String)entry.getKey();
            Path path = (Path)entry.getValue();
            PathResource pathResource = new PathResource(path, openOptionArray);
            Serializable serializable2 = null;
            try (InputStream inputStream = pathResource.openInputStream();){
                iterable = SecurityUtils.loadKeyPairIdentities(sessionContext, pathResource, inputStream, filePasswordProvider);
            }
            catch (Throwable throwable) {
                serializable2 = throwable;
                throw throwable;
            }
            if (iterable == null) continue;
            for (Serializable serializable2 : iterable) {
                KeyPair keyPair = (KeyPair)((Object)treeMap.put(string, (Throwable)serializable2));
                ValidateUtils.checkTrue(keyPair == null, "Multiple keys for type=%s due to %s", string, path);
            }
        }
        return treeMap;
    }
}

