/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.IOException;
import java.net.ProtocolException;
import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.FilePasswordProvider$Decoder;
import org.apache.sshd.common.config.keys.FilePasswordProvider$ResourceDecodeResult;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;

@FunctionalInterface
public interface FilePasswordProvider {
    public static final FilePasswordProvider EMPTY = (sessionContext, namedResource, n2) -> null;

    public String getPassword(SessionContext var1, NamedResource var2, int var3);

    default public FilePasswordProvider$ResourceDecodeResult handleDecodeAttemptResult(SessionContext sessionContext, NamedResource namedResource, int n2, String string, Exception exception) {
        return FilePasswordProvider$ResourceDecodeResult.TERMINATE;
    }

    default public Object decode(SessionContext sessionContext, NamedResource namedResource, FilePasswordProvider$Decoder filePasswordProvider$Decoder) {
        int n2 = 0;
        while (true) {
            String string;
            if (GenericUtils.isEmpty(string = this.getPassword(sessionContext, namedResource, n2))) {
                throw new FailedLoginException("No password data for encrypted resource=" + namedResource);
            }
            try {
                Object object = filePasswordProvider$Decoder.decode(string);
                this.handleDecodeAttemptResult(sessionContext, namedResource, n2, string, null);
                return object;
            }
            catch (IOException | RuntimeException | GeneralSecurityException exception) {
                FilePasswordProvider$ResourceDecodeResult filePasswordProvider$ResourceDecodeResult = this.handleDecodeAttemptResult(sessionContext, namedResource, n2, string, exception);
                if (filePasswordProvider$ResourceDecodeResult == null) {
                    throw exception;
                }
                switch (filePasswordProvider$ResourceDecodeResult) {
                    case TERMINATE: {
                        throw exception;
                    }
                    case RETRY: {
                        break;
                    }
                    case IGNORE: {
                        return null;
                    }
                    default: {
                        throw new ProtocolException("Unsupported decode attempt result (" + (Object)((Object)filePasswordProvider$ResourceDecodeResult) + ") for " + namedResource);
                    }
                }
                ++n2;
                continue;
            }
            break;
        }
    }

    public static FilePasswordProvider of(String string) {
        return (sessionContext, namedResource, n2) -> string;
    }
}

