/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.BuiltinIdentities$1;
import org.apache.sshd.common.config.keys.BuiltinIdentities$2;
import org.apache.sshd.common.config.keys.Identity;
import org.apache.sshd.common.config.keys.KeyTypeNamesSupport;
import org.apache.sshd.common.keyprovider.KeyTypeIndicator;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public class BuiltinIdentities
extends Enum
implements Identity {
    public static final /* enum */ BuiltinIdentities RSA = new BuiltinIdentities("RSA", 0, "RSA", RSAPublicKey.class, RSAPrivateKey.class, "ssh-rsa");
    public static final /* enum */ BuiltinIdentities DSA = new BuiltinIdentities("DSA", 1, "DSA", DSAPublicKey.class, DSAPrivateKey.class, "ssh-dss");
    public static final /* enum */ BuiltinIdentities ECDSA = new BuiltinIdentities$1("ECDSA", "EC", ECPublicKey.class, ECPrivateKey.class, ECCurves.VALUES.stream().map(KeyTypeIndicator::getKeyType).collect(Collectors.toList()));
    public static final /* enum */ BuiltinIdentities ED25119 = new BuiltinIdentities$2("ED25519", "EdDSA", SecurityUtils.getEDDSAPublicKeyType(), SecurityUtils.getEDDSAPrivateKeyType(), "ssh-ed25519");
    public static final Set VALUES;
    public static final NavigableSet NAMES;
    private final String name;
    private final String algorithm;
    private final Class pubType;
    private final Class prvType;
    private final NavigableSet types;
    private static final /* synthetic */ BuiltinIdentities[] $VALUES;

    public static BuiltinIdentities[] values() {
        return (BuiltinIdentities[])$VALUES.clone();
    }

    public static BuiltinIdentities valueOf(String string) {
        return Enum.valueOf(BuiltinIdentities.class, string);
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BuiltinIdentities(Class clazz, String string3) {
        this((String)var1_-1, (int)var2_-1, (String)((Object)clazz), (String)((Object)clazz), (Class)((Object)string3), (Class)var5_3, (String)var6_4);
        void var6_4;
        void var5_3;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BuiltinIdentities(Class clazz, Class clazz2, String string3) {
        this((String)var1_-1, (int)var2_-1, (String)((Object)clazz), (String)((Object)clazz2), (Class)((Object)string3), (Class)var6_4, Collections.singletonList(ValidateUtils.checkNotNullAndNotEmpty((String)var7_5, "No key type specified")));
        void var7_5;
        void var6_4;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BuiltinIdentities(Class clazz, Class clazz2, Collection collection) {
        void var7_5;
        void var6_4;
        void var2_-1;
        void var1_-1;
        this.name = ((String)((Object)clazz)).toLowerCase();
        this.algorithm = ((String)((Object)clazz2)).toUpperCase();
        this.pubType = collection;
        this.prvType = var6_4;
        this.types = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, ValidateUtils.checkNotNullAndNotEmpty((Collection)var7_5, "No key type names provided", new Object[0])));
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public NavigableSet getSupportedKeyTypes() {
        return this.types;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public final Class getPublicKeyType() {
        return this.pubType;
    }

    @Override
    public final Class getPrivateKeyType() {
        return this.prvType;
    }

    public static BuiltinIdentities fromName(String string) {
        return (BuiltinIdentities)NamedResource.findByName(string, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static BuiltinIdentities fromAlgorithm(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        for (BuiltinIdentities builtinIdentities : VALUES) {
            if (!string.equalsIgnoreCase(builtinIdentities.getAlgorithm())) continue;
            return builtinIdentities;
        }
        return null;
    }

    public static BuiltinIdentities fromKeyPair(KeyPair keyPair) {
        BuiltinIdentities builtinIdentities;
        if (keyPair == null) {
            return null;
        }
        BuiltinIdentities builtinIdentities2 = BuiltinIdentities.fromKey(keyPair.getPublic());
        if (Objects.equals(builtinIdentities2, builtinIdentities = BuiltinIdentities.fromKey(keyPair.getPrivate()))) {
            return builtinIdentities2;
        }
        return null;
    }

    public static BuiltinIdentities fromKey(Key key) {
        return BuiltinIdentities.fromKeyType(key == null ? null : key.getClass());
    }

    public static BuiltinIdentities fromKeyType(Class clazz) {
        if (clazz == null || !Key.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (BuiltinIdentities builtinIdentities : VALUES) {
            Class clazz2 = builtinIdentities.getPublicKeyType();
            Class clazz3 = builtinIdentities.getPrivateKeyType();
            if (clazz3 == null || clazz2 == null || clazz3 == PrivateKey.class || clazz2 == PublicKey.class || !clazz2.isAssignableFrom(clazz) && !clazz3.isAssignableFrom(clazz)) continue;
            return builtinIdentities;
        }
        return null;
    }

    public static BuiltinIdentities fromKeyTypeName(String string) {
        return (BuiltinIdentities)KeyTypeNamesSupport.findSupporterByKeyTypeName(string, VALUES);
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    /* synthetic */ BuiltinIdentities(String string, String string2, Class clazz, Class clazz2, Collection collection, BuiltinIdentities$1 builtinIdentities$1) {
        this((String)var1_-1, (int)string2, (String)((Object)clazz), (String)((Object)clazz2), (Class)((Object)collection), (Class)((Object)builtinIdentities$1), (Collection)var7_6);
        void var7_6;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    /* synthetic */ BuiltinIdentities(String string, String string2, Class clazz, Class clazz2, String string3, BuiltinIdentities$1 builtinIdentities$1) {
        this((String)var1_-1, (int)string2, (String)((Object)clazz), (String)((Object)clazz2), (Class)((Object)string3), (Class)((Object)builtinIdentities$1), (String)var7_6);
        void var7_6;
        void var1_-1;
    }

    static {
        $VALUES = new BuiltinIdentities[]{RSA, DSA, ECDSA, ED25119};
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinIdentities.class));
        NAMES = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, NamedResource.getNameList(VALUES)));
    }
}

