/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.PublicKey;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryDataResolver;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.input.NoCloseInputStream;
import org.apache.sshd.common.util.io.input.NoCloseReader;

public class AuthorizedKeyEntry
extends PublicKeyEntry {
    public static final char BOOLEAN_OPTION_NEGATION_INDICATOR = '!';
    private static final long serialVersionUID = -9007505285002809156L;
    private String comment;
    private Map loginOptions = Collections.emptyMap();

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public Map getLoginOptions() {
        return this.loginOptions;
    }

    public void setLoginOptions(Map map) {
        this.loginOptions = map == null ? Collections.emptyMap() : map;
    }

    public PublicKey resolvePublicKey(SessionContext sessionContext, PublicKeyEntryResolver publicKeyEntryResolver) {
        return this.resolvePublicKey(sessionContext, this.getLoginOptions(), publicKeyEntryResolver);
    }

    @Override
    public PublicKey appendPublicKey(SessionContext sessionContext, Appendable appendable, PublicKeyEntryResolver publicKeyEntryResolver) {
        Map map = this.getLoginOptions();
        if (MapEntryUtils.isNotEmpty(map)) {
            int n2 = 0;
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                if (n2 > 0) {
                    appendable.append(',');
                }
                appendable.append(string);
                if (!"true".equals(string2)) {
                    appendable.append('=').append(string2);
                }
                ++n2;
            }
            if (n2 > 0) {
                appendable.append(' ');
            }
        }
        PublicKey publicKey = super.appendPublicKey(sessionContext, appendable, publicKeyEntryResolver);
        String string = this.getComment();
        if (!GenericUtils.isEmpty(string)) {
            appendable.append(' ').append(string);
        }
        return publicKey;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public String toString() {
        String string = super.toString();
        String string2 = this.getComment();
        Map map = this.getLoginOptions();
        return (MapEntryUtils.isEmpty(map) ? "" : map.toString() + " ") + string + (GenericUtils.isEmpty(string2) ? "" : " " + string2);
    }

    public static List readAuthorizedKeys(URL uRL) {
        try (InputStream inputStream = uRL.openStream();){
            List list = AuthorizedKeyEntry.readAuthorizedKeys(inputStream, true);
            return list;
        }
    }

    public static List readAuthorizedKeys(Path path, OpenOption ... openOptionArray) {
        try (InputStream inputStream = Files.newInputStream(path, openOptionArray);){
            List list = AuthorizedKeyEntry.readAuthorizedKeys(inputStream, true);
            return list;
        }
    }

    public static List readAuthorizedKeys(InputStream inputStream, boolean bl2) {
        try (InputStreamReader inputStreamReader = new InputStreamReader(NoCloseInputStream.resolveInputStream(inputStream, bl2), StandardCharsets.UTF_8);){
            List list = AuthorizedKeyEntry.readAuthorizedKeys(inputStreamReader, true);
            return list;
        }
    }

    public static List readAuthorizedKeys(Reader reader, boolean bl2) {
        try (BufferedReader bufferedReader = new BufferedReader(NoCloseReader.resolveReader(reader, bl2));){
            List list = AuthorizedKeyEntry.readAuthorizedKeys(bufferedReader);
            return list;
        }
    }

    public static List readAuthorizedKeys(BufferedReader bufferedReader) {
        ArrayList<AuthorizedKeyEntry> arrayList = null;
        String string = bufferedReader.readLine();
        while (string != null) {
            block6: {
                AuthorizedKeyEntry authorizedKeyEntry;
                block5: {
                    try {
                        authorizedKeyEntry = AuthorizedKeyEntry.parseAuthorizedKeyEntry(string);
                        if (authorizedKeyEntry != null) break block5;
                        break block6;
                    }
                    catch (Error | RuntimeException throwable) {
                        throw new StreamCorruptedException("Failed (" + throwable.getClass().getSimpleName() + ") to parse key entry=" + string + ": " + throwable.getMessage());
                    }
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<AuthorizedKeyEntry>();
                }
                arrayList.add(authorizedKeyEntry);
            }
            string = bufferedReader.readLine();
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    public static AuthorizedKeyEntry parseAuthorizedKeyEntry(String string) {
        return AuthorizedKeyEntry.parseAuthorizedKeyEntry(string, null);
    }

    public static AuthorizedKeyEntry parseAuthorizedKeyEntry(String string, PublicKeyEntryDataResolver publicKeyEntryDataResolver) {
        AuthorizedKeyEntry authorizedKeyEntry;
        String string2;
        Object object;
        String string3 = GenericUtils.replaceWhitespaceAndTrim(string);
        if (GenericUtils.isEmpty(string3) || string3.charAt(0) == '#') {
            return null;
        }
        int n2 = string3.indexOf(32);
        if (n2 <= 0) {
            throw new IllegalArgumentException("Bad format (no key data delimiter): " + string3);
        }
        int n3 = string3.indexOf(32, n2 + 1);
        if (n3 <= n2) {
            n3 = string3.length();
        }
        if ((object = PublicKeyEntry.getKeyDataEntryResolver(string2 = string3.substring(0, n2))) == null) {
            object = KeyUtils.getPublicKeyEntryDecoder(string2);
        }
        if (object == null) {
            AbstractMap.SimpleImmutableEntry simpleImmutableEntry = AuthorizedKeyEntry.resolveEntryComponents(string3);
            authorizedKeyEntry = AuthorizedKeyEntry.parseAuthorizedKeyEntry((String)simpleImmutableEntry.getValue());
            ValidateUtils.checkTrue(authorizedKeyEntry != null, "Bad format (no key data after login options): %s", (Object)string3);
            authorizedKeyEntry.setLoginOptions(AuthorizedKeyEntry.parseLoginOptions((String)simpleImmutableEntry.getKey()));
        } else {
            String string4 = n3 < string3.length() - 1 ? string3.substring(0, n3).trim() : string3;
            String string5 = n3 < string3.length() - 1 ? string3.substring(n3 + 1).trim() : null;
            authorizedKeyEntry = (AuthorizedKeyEntry)AuthorizedKeyEntry.parsePublicKeyEntry(new AuthorizedKeyEntry(), string4, publicKeyEntryDataResolver);
            authorizedKeyEntry.setComment(string5);
        }
        return authorizedKeyEntry;
    }

    public static AbstractMap.SimpleImmutableEntry resolveEntryComponents(String string) {
        String string2 = GenericUtils.replaceWhitespaceAndTrim(string);
        if (GenericUtils.isEmpty(string2) || string2.charAt(0) == '#') {
            return null;
        }
        int n2 = 0;
        while (n2 < string2.length()) {
            int n3 = string2.indexOf(32, n2);
            if (n3 < n2) {
                throw new IllegalArgumentException("Bad format (no key data delimiter): " + string2);
            }
            int n4 = string2.indexOf(34, n3 + 1);
            if (n4 > n3) {
                n2 = n4 + 1;
                continue;
            }
            String string3 = string2.substring(0, n3).trim();
            String string4 = string2.substring(n3 + 1).trim();
            return new AbstractMap.SimpleImmutableEntry<String, String>(string3, string4);
        }
        throw new IllegalArgumentException("Bad format (no key data contents): " + string2);
    }

    public static NavigableMap parseLoginOptions(String string) {
        int n2;
        String string2 = GenericUtils.replaceWhitespaceAndTrim(string);
        int n3 = GenericUtils.length(string2);
        if (n3 <= 0) {
            return Collections.emptyNavigableMap();
        }
        TreeMap treeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        int n4 = 0;
        for (int i2 = 0; i2 < n3 && (n2 = string2.indexOf(44, i2)) >= i2; ++i2) {
            int n5 = string2.indexOf(34, i2);
            if (n5 >= n4 && n5 < n2) {
                char c2;
                n2 = string2.indexOf(34, n5 + 1);
                if (n2 <= n5) {
                    throw new IllegalArgumentException("Bad format (imbalanced quoted command): " + string2);
                }
                ++n2;
                while (n2 < n3 && (c2 = string2.charAt(n2)) != ',') {
                    if (c2 != ' ') {
                        throw new IllegalArgumentException("Bad format (incorrect list format): " + string2);
                    }
                    ++n2;
                }
            }
            AuthorizedKeyEntry.addLoginOption(treeMap, string2.substring(n4, n2));
            i2 = n4 = n2 + 1;
        }
        if (n4 < n3) {
            AuthorizedKeyEntry.addLoginOption(treeMap, string2.substring(n4));
        }
        return treeMap;
    }

    public static AbstractMap.SimpleImmutableEntry addLoginOption(Map map, String string) {
        AbstractMap.SimpleImmutableEntry<String, String> simpleImmutableEntry;
        String string2;
        String string3 = GenericUtils.trimToEmpty(string);
        if (GenericUtils.isEmpty(string3)) {
            return null;
        }
        int n2 = string3.indexOf(61);
        String string4 = n2 < 0 ? string3 : GenericUtils.trimToEmpty(string3.substring(0, n2));
        CharSequence charSequence = n2 < 0 ? null : GenericUtils.trimToEmpty(string3.substring(n2 + 1));
        if ((charSequence = GenericUtils.stripQuotes(charSequence)) == null) {
            charSequence = Boolean.toString(string4.charAt(0) != '!');
        }
        if ((string2 = map.put((simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<String, String>(string4, charSequence.toString())).getKey(), simpleImmutableEntry.getValue())) != null) {
            if (n2 < 0) {
                throw new IllegalStateException("Bad format (boolean option (" + string4 + ") re-specified): " + string3);
            }
            map.put(simpleImmutableEntry.getKey(), string2 + "," + simpleImmutableEntry.getValue());
        }
        return simpleImmutableEntry;
    }
}

