/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config;

import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;

public enum TimeValueConfig {
    SECONDS('s', 'S', TimeUnit.SECONDS.toMillis(1L)),
    MINUTES('m', 'M', TimeUnit.MINUTES.toMillis(1L)),
    HOURS('h', 'H', TimeUnit.HOURS.toMillis(1L)),
    DAYS('d', 'D', TimeUnit.DAYS.toMillis(1L)),
    WEEKS('w', 'W', TimeUnit.DAYS.toMillis(7L));

    public static final Set VALUES;
    private final char loChar;
    private final char hiChar;
    private final long interval;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private TimeValueConfig(long l2) {
        void var5_3;
        void var4_2;
        this.loChar = (char)l2;
        this.hiChar = var4_2;
        this.interval = var5_3;
    }

    public final char getLowerCaseValue() {
        return this.loChar;
    }

    public final char getUpperCaseValue() {
        return this.hiChar;
    }

    public final long getInterval() {
        return this.interval;
    }

    public static TimeValueConfig fromValueChar(char c2) {
        if (c2 <= ' ' || c2 >= '\u007f') {
            return null;
        }
        for (TimeValueConfig timeValueConfig : VALUES) {
            if (timeValueConfig.getLowerCaseValue() != c2 && timeValueConfig.getUpperCaseValue() != c2) continue;
            return timeValueConfig;
        }
        return null;
    }

    public static long durationOf(String string) {
        Map map = TimeValueConfig.parse(string);
        return TimeValueConfig.durationOf(map);
    }

    public static Map parse(String string) {
        Object object;
        if (GenericUtils.isEmpty(string)) {
            return Collections.emptyMap();
        }
        int n2 = 0;
        EnumMap<TimeValueConfig, Long> enumMap = new EnumMap<TimeValueConfig, Long>(TimeValueConfig.class);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9') continue;
            if (i2 <= n2) {
                throw new IllegalArgumentException("parse(" + string + ") missing count value at index=" + i2);
            }
            TimeValueConfig timeValueConfig = TimeValueConfig.fromValueChar(c2);
            if (timeValueConfig == null) {
                throw new IllegalArgumentException("parse(" + string + ") unknown time value character: '" + c2 + "'");
            }
            object = string.substring(n2, i2);
            long l2 = Long.parseLong((String)object);
            if (l2 < 0L) {
                throw new IllegalArgumentException("parse(" + string + ") negative count (" + (String)object + ") for " + timeValueConfig.name());
            }
            Long l3 = enumMap.put(timeValueConfig, l2);
            if (l3 != null) {
                throw new IllegalArgumentException("parse(" + string + ") " + timeValueConfig.name() + " value re-specified: current=" + l2 + ", previous=" + l3);
            }
            n2 = i2 + 1;
            if (n2 >= string.length()) break;
        }
        if (n2 < string.length()) {
            String string2 = string.substring(n2);
            long l4 = Long.parseLong(string2);
            if (l4 < 0L) {
                throw new IllegalArgumentException("parse(" + string + ") negative count (" + string2 + ") for last component");
            }
            object = enumMap.put(SECONDS, l4);
            if (object != null) {
                throw new IllegalArgumentException("parse(" + string + ") last component (" + SECONDS.name() + ") value re-specified: current=" + l4 + ", previous=" + object);
            }
        }
        return enumMap;
    }

    public static long durationOf(Map map) {
        if (MapEntryUtils.isEmpty(map)) {
            return -1L;
        }
        long l2 = 0L;
        for (Map.Entry entry : map.entrySet()) {
            TimeValueConfig timeValueConfig = (TimeValueConfig)((Object)entry.getKey());
            Number number = (Number)entry.getValue();
            long l3 = number.longValue();
            if (l3 < 0L) {
                throw new IllegalArgumentException("valueOf(" + map + ") bad factor (" + number + ") for " + timeValueConfig.name());
            }
            long l4 = timeValueConfig.getInterval() * l3;
            l2 += l4;
        }
        return l2;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(TimeValueConfig.class));
    }
}

