/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.sshd.common.BuiltinFactory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.cipher.BuiltinCiphers$ParseResult;
import org.apache.sshd.common.compression.BuiltinCompressions;
import org.apache.sshd.common.compression.BuiltinCompressions$ParseResult;
import org.apache.sshd.common.compression.CompressionFactory;
import org.apache.sshd.common.config.CompressionConfigValue;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.common.kex.BuiltinDHFactories$ParseResult;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.apache.sshd.common.mac.BuiltinMacs$ParseResult;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.BuiltinSignatures$ParseResult;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public final class SshConfigFileReader {
    private SshConfigFileReader() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static BuiltinCiphers$ParseResult getCiphers(PropertyResolver propertyResolver) {
        return BuiltinCiphers.parseCiphersList(propertyResolver == null ? null : propertyResolver.getString("Ciphers"));
    }

    public static BuiltinMacs$ParseResult getMacs(PropertyResolver propertyResolver) {
        return BuiltinMacs.parseMacsList(propertyResolver == null ? null : propertyResolver.getString("MACs"));
    }

    public static BuiltinSignatures$ParseResult getSignatures(PropertyResolver propertyResolver) {
        return BuiltinSignatures.parseSignatureList(propertyResolver == null ? null : propertyResolver.getString("HostKeyAlgorithms"));
    }

    public static BuiltinDHFactories$ParseResult getKexFactories(PropertyResolver propertyResolver) {
        return BuiltinDHFactories.parseDHFactoriesList(propertyResolver == null ? null : propertyResolver.getString("KexAlgorithms"));
    }

    public static CompressionFactory getCompression(PropertyResolver propertyResolver) {
        return CompressionConfigValue.fromName(propertyResolver == null ? null : propertyResolver.getString("Compression"));
    }

    public static AbstractFactoryManager configure(AbstractFactoryManager abstractFactoryManager, PropertyResolver propertyResolver, boolean bl2, boolean bl3) {
        SshConfigFileReader.configureCiphers(abstractFactoryManager, propertyResolver, bl2, bl3);
        SshConfigFileReader.configureSignatures(abstractFactoryManager, propertyResolver, bl2, bl3);
        SshConfigFileReader.configureMacs(abstractFactoryManager, propertyResolver, bl2, bl3);
        SshConfigFileReader.configureCompression(abstractFactoryManager, propertyResolver, bl2, bl3);
        return abstractFactoryManager;
    }

    public static AbstractFactoryManager configureCiphers(AbstractFactoryManager abstractFactoryManager, PropertyResolver propertyResolver, boolean bl2, boolean bl3) {
        Objects.requireNonNull(propertyResolver, "No properties to configure");
        return SshConfigFileReader.configureCiphers(abstractFactoryManager, propertyResolver.getString("Ciphers"), bl2, bl3);
    }

    public static AbstractFactoryManager configureCiphers(AbstractFactoryManager abstractFactoryManager, String string, boolean bl2, boolean bl3) {
        Objects.requireNonNull(abstractFactoryManager, "No manager to configure");
        if (GenericUtils.isEmpty(string)) {
            return abstractFactoryManager;
        }
        BuiltinCiphers$ParseResult builtinCiphers$ParseResult = BuiltinCiphers.parseCiphersList(string);
        List list = builtinCiphers$ParseResult.getUnsupportedFactories();
        ValidateUtils.checkTrue(bl2 || GenericUtils.isEmpty(list), "Unsupported cipher(s) (%s) in %s", list, string);
        List list2 = BuiltinFactory.setUpFactories(bl3, builtinCiphers$ParseResult.getParsedFactories());
        abstractFactoryManager.setCipherFactories((List)ValidateUtils.checkNotNullAndNotEmpty(list2, "No known/unsupported ciphers(s): %s", string));
        return abstractFactoryManager;
    }

    public static AbstractFactoryManager configureSignatures(AbstractFactoryManager abstractFactoryManager, PropertyResolver propertyResolver, boolean bl2, boolean bl3) {
        Objects.requireNonNull(propertyResolver, "No properties to configure");
        return SshConfigFileReader.configureSignatures(abstractFactoryManager, propertyResolver.getString("HostKeyAlgorithms"), bl2, bl3);
    }

    public static AbstractFactoryManager configureSignatures(AbstractFactoryManager abstractFactoryManager, String string, boolean bl2, boolean bl3) {
        Objects.requireNonNull(abstractFactoryManager, "No manager to configure");
        if (GenericUtils.isEmpty(string)) {
            return abstractFactoryManager;
        }
        BuiltinSignatures$ParseResult builtinSignatures$ParseResult = BuiltinSignatures.parseSignatureList(string);
        List list = builtinSignatures$ParseResult.getUnsupportedFactories();
        ValidateUtils.checkTrue(bl2 || GenericUtils.isEmpty(list), "Unsupported signatures (%s) in %s", list, string);
        List list2 = BuiltinFactory.setUpFactories(bl3, builtinSignatures$ParseResult.getParsedFactories());
        abstractFactoryManager.setSignatureFactories((List)ValidateUtils.checkNotNullAndNotEmpty(list2, "No known/supported signatures: %s", string));
        return abstractFactoryManager;
    }

    public static AbstractFactoryManager configureMacs(AbstractFactoryManager abstractFactoryManager, PropertyResolver propertyResolver, boolean bl2, boolean bl3) {
        Objects.requireNonNull(propertyResolver, "No properties to configure");
        return SshConfigFileReader.configureMacs(abstractFactoryManager, propertyResolver.getString("MACs"), bl2, bl3);
    }

    public static AbstractFactoryManager configureMacs(AbstractFactoryManager abstractFactoryManager, String string, boolean bl2, boolean bl3) {
        Objects.requireNonNull(abstractFactoryManager, "No manager to configure");
        if (GenericUtils.isEmpty(string)) {
            return abstractFactoryManager;
        }
        BuiltinMacs$ParseResult builtinMacs$ParseResult = BuiltinMacs.parseMacsList(string);
        List list = builtinMacs$ParseResult.getUnsupportedFactories();
        ValidateUtils.checkTrue(bl2 || GenericUtils.isEmpty(list), "Unsupported MAC(s) (%s) in %s", list, string);
        List list2 = BuiltinFactory.setUpFactories(bl3, builtinMacs$ParseResult.getParsedFactories());
        abstractFactoryManager.setMacFactories((List)ValidateUtils.checkNotNullAndNotEmpty(list2, "No known/supported MAC(s): %s", string));
        return abstractFactoryManager;
    }

    public static AbstractFactoryManager configureKeyExchanges(AbstractFactoryManager abstractFactoryManager, PropertyResolver propertyResolver, boolean bl2, Function function, boolean bl3) {
        Objects.requireNonNull(propertyResolver, "No properties to configure");
        return SshConfigFileReader.configureKeyExchanges(abstractFactoryManager, propertyResolver.getString("KexAlgorithms"), bl2, function, bl3);
    }

    public static AbstractFactoryManager configureKeyExchanges(AbstractFactoryManager abstractFactoryManager, String string, boolean bl2, Function function, boolean bl3) {
        Objects.requireNonNull(abstractFactoryManager, "No manager to configure");
        Objects.requireNonNull(function, "No DHFactory transformer");
        if (GenericUtils.isEmpty(string)) {
            return abstractFactoryManager;
        }
        BuiltinDHFactories$ParseResult builtinDHFactories$ParseResult = BuiltinDHFactories.parseDHFactoriesList(string);
        List list = builtinDHFactories$ParseResult.getUnsupportedFactories();
        ValidateUtils.checkTrue(bl2 || GenericUtils.isEmpty(list), "Unsupported KEX(s) (%s) in %s", list, string);
        List list2 = NamedFactory.setUpTransformedFactories(bl3, builtinDHFactories$ParseResult.getParsedFactories(), function);
        abstractFactoryManager.setKeyExchangeFactories((List)ValidateUtils.checkNotNullAndNotEmpty(list2, "No known/supported KEXS(s): %s", string));
        return abstractFactoryManager;
    }

    public static AbstractFactoryManager configureCompression(AbstractFactoryManager abstractFactoryManager, PropertyResolver propertyResolver, boolean bl2, boolean bl3) {
        Objects.requireNonNull(abstractFactoryManager, "No manager to configure");
        Objects.requireNonNull(propertyResolver, "No properties to configure");
        String string = propertyResolver.getString("Compression");
        if (GenericUtils.isEmpty(string)) {
            return abstractFactoryManager;
        }
        CompressionConfigValue compressionConfigValue = CompressionConfigValue.fromName(string);
        ValidateUtils.checkTrue(bl2 || compressionConfigValue != null, "Unsupported compression value: %s", (Object)string);
        if (compressionConfigValue != null && compressionConfigValue.isSupported()) {
            abstractFactoryManager.setCompressionFactories(Collections.singletonList(compressionConfigValue));
        }
        return abstractFactoryManager;
    }

    public static AbstractFactoryManager configureCompression(AbstractFactoryManager abstractFactoryManager, String string, boolean bl2, boolean bl3) {
        Objects.requireNonNull(abstractFactoryManager, "No manager to configure");
        if (GenericUtils.isEmpty(string)) {
            return abstractFactoryManager;
        }
        CompressionConfigValue compressionConfigValue = CompressionConfigValue.fromName(string);
        if (compressionConfigValue != null) {
            if (bl3 || compressionConfigValue.isSupported()) {
                abstractFactoryManager.setCompressionFactories(Collections.singletonList(compressionConfigValue));
            }
        } else {
            BuiltinCompressions$ParseResult builtinCompressions$ParseResult = BuiltinCompressions.parseCompressionsList(string);
            List list = builtinCompressions$ParseResult.getUnsupportedFactories();
            ValidateUtils.checkTrue(bl2 || GenericUtils.isEmpty(list), "Unsupported compressions(s) (%s) in %s", list, string);
            List list2 = BuiltinFactory.setUpFactories(bl3, builtinCompressions$ParseResult.getParsedFactories());
            if (GenericUtils.size(list2) > 0) {
                abstractFactoryManager.setCompressionFactories(list2);
            }
        }
        return abstractFactoryManager;
    }
}

