/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import org.apache.sshd.common.util.GenericUtils;

public enum LogLevelValue {
    QUIET(Level.OFF),
    FATAL(Level.SEVERE),
    ERROR(Level.SEVERE),
    INFO(Level.INFO),
    VERBOSE(Level.FINE),
    DEBUG(Level.FINE),
    DEBUG1(Level.FINE),
    DEBUG2(Level.FINER),
    DEBUG3(Level.FINEST);

    public static final Set VALUES;
    private final Level level;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private LogLevelValue() {
        void var3_2;
        this.level = var3_2;
    }

    public Level getLoggingLevel() {
        return this.level;
    }

    public static LogLevelValue fromName(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        for (LogLevelValue logLevelValue : VALUES) {
            if (!string.equalsIgnoreCase(logLevelValue.name())) continue;
            return logLevelValue;
        }
        return null;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(LogLevelValue.class));
    }
}

