/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.CompressionConfigValue;
import org.apache.sshd.common.config.LogLevelValue;
import org.apache.sshd.common.config.SyslogFacilityValue;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.input.NoCloseInputStream;
import org.apache.sshd.common.util.io.input.NoCloseReader;

public final class ConfigFileReaderSupport {
    public static final char COMMENT_CHAR = '#';
    public static final String COMPRESSION_PROP = "Compression";
    public static final String DEFAULT_COMPRESSION = CompressionConfigValue.NO.getName();
    public static final String MAX_SESSIONS_CONFIG_PROP = "MaxSessions";
    public static final int DEFAULT_MAX_SESSIONS = 10;
    public static final String PUBKEY_AUTH_CONFIG_PROP = "PubkeyAuthentication";
    public static final String DEFAULT_PUBKEY_AUTH = "yes";
    public static final boolean DEFAULT_PUBKEY_AUTH_VALUE = ConfigFileReaderSupport.parseBooleanValue("yes");
    public static final String PASSWORD_AUTH_CONFIG_PROP = "PasswordAuthentication";
    public static final String DEFAULT_PASSWORD_AUTH = "yes";
    public static final boolean DEFAULT_PASSWORD_AUTH_VALUE = ConfigFileReaderSupport.parseBooleanValue("yes");
    public static final String KBD_INTERACTIVE_CONFIG_PROP = "KbdInteractiveAuthentication";
    public static final String DEFAULT_KBD_INTERACTIVE_AUTH = "yes";
    public static final boolean DEFAULT_KBD_INTERACTIVE_AUTH_VALUE = ConfigFileReaderSupport.parseBooleanValue("yes");
    public static final String PREFERRED_AUTHS_CONFIG_PROP = "PreferredAuthentications";
    public static final String LISTEN_ADDRESS_CONFIG_PROP = "ListenAddress";
    public static final String DEFAULT_BIND_ADDRESS = "0.0.0.0";
    public static final String PORT_CONFIG_PROP = "Port";
    public static final String KEEP_ALIVE_CONFIG_PROP = "TCPKeepAlive";
    public static final boolean DEFAULT_KEEP_ALIVE = true;
    public static final String USE_DNS_CONFIG_PROP = "UseDNS";
    public static final boolean DEFAULT_USE_DNS = true;
    public static final String AUTH_KEYS_FILE_CONFIG_PROP = "AuthorizedKeysFile";
    public static final String MAX_AUTH_TRIES_CONFIG_PROP = "MaxAuthTries";
    public static final int DEFAULT_MAX_AUTH_TRIES = 6;
    public static final String MAX_STARTUPS_CONFIG_PROP = "MaxStartups";
    public static final int DEFAULT_MAX_STARTUPS = 10;
    public static final String LOGIN_GRACE_TIME_CONFIG_PROP = "LoginGraceTime";
    public static final long DEFAULT_LOGIN_GRACE_TIME = TimeUnit.SECONDS.toMillis(120L);
    public static final String KEY_REGENERATE_INTERVAL_CONFIG_PROP = "KeyRegenerationInterval";
    public static final long DEFAULT_REKEY_TIME_LIMIT = TimeUnit.HOURS.toMillis(1L);
    public static final String CIPHERS_CONFIG_PROP = "Ciphers";
    public static final String MACS_CONFIG_PROP = "MACs";
    public static final String KEX_ALGORITHMS_CONFIG_PROP = "KexAlgorithms";
    public static final String HOST_KEY_ALGORITHMS_CONFIG_PROP = "HostKeyAlgorithms";
    public static final String LOG_LEVEL_CONFIG_PROP = "LogLevel";
    public static final LogLevelValue DEFAULT_LOG_LEVEL = LogLevelValue.INFO;
    public static final String SYSLOG_FACILITY_CONFIG_PROP = "SyslogFacility";
    public static final SyslogFacilityValue DEFAULT_SYSLOG_FACILITY = SyslogFacilityValue.AUTH;
    public static final String SUBSYSTEM_CONFIG_PROP = "Subsystem";

    private ConfigFileReaderSupport() {
        throw new UnsupportedOperationException("No instance");
    }

    public static Properties readConfigFile(Path path, OpenOption ... openOptionArray) {
        try (InputStream inputStream = Files.newInputStream(path, openOptionArray);){
            Properties properties = ConfigFileReaderSupport.readConfigFile(inputStream, true);
            return properties;
        }
    }

    public static Properties readConfigFile(URL uRL) {
        try (InputStream inputStream = uRL.openStream();){
            Properties properties = ConfigFileReaderSupport.readConfigFile(inputStream, true);
            return properties;
        }
    }

    public static Properties readConfigFile(InputStream inputStream, boolean bl2) {
        try (InputStreamReader inputStreamReader = new InputStreamReader(NoCloseInputStream.resolveInputStream(inputStream, bl2), StandardCharsets.UTF_8);){
            Properties properties = ConfigFileReaderSupport.readConfigFile(inputStreamReader, true);
            return properties;
        }
    }

    public static Properties readConfigFile(Reader reader, boolean bl2) {
        try (BufferedReader bufferedReader = new BufferedReader(NoCloseReader.resolveReader(reader, bl2));){
            Properties properties = ConfigFileReaderSupport.readConfigFile(bufferedReader);
            return properties;
        }
    }

    public static Properties readConfigFile(BufferedReader bufferedReader) {
        Properties properties = new Properties();
        int n2 = 1;
        String string = bufferedReader.readLine();
        while (string != null) {
            int n3;
            if (!GenericUtils.isEmpty(string = GenericUtils.replaceWhitespaceAndTrim(string)) && (n3 = string.indexOf(35)) != 0) {
                if (n3 > 0) {
                    string = string.substring(0, n3);
                    string = string.trim();
                }
                if ((n3 = string.indexOf(32)) < 0) {
                    n3 = string.indexOf(61);
                }
                if (n3 < 0) {
                    throw new StreamCorruptedException("No delimiter at line " + n2 + ": " + string);
                }
                String string2 = string.substring(0, n3);
                String string3 = string.substring(n3 + 1).trim();
                String string4 = properties.getProperty(string2);
                if (!GenericUtils.isEmpty(string4)) {
                    string3 = string4 + "," + string3;
                }
                properties.setProperty(string2, string3);
            }
            string = bufferedReader.readLine();
            ++n2;
        }
        return properties;
    }

    public static boolean parseBooleanValue(String string) {
        if (GenericUtils.isEmpty(string)) {
            return false;
        }
        return PropertyResolverUtils.TRUE_VALUES.contains(string);
    }

    public static String yesNoValueOf(boolean bl2) {
        return bl2 ? "yes" : "no";
    }
}

