/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sshd.common.compression.BuiltinCompressions;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.compression.CompressionFactory;
import org.apache.sshd.common.util.GenericUtils;

public enum CompressionConfigValue implements CompressionFactory
{
    YES((CompressionFactory)BuiltinCompressions.zlib),
    NO((CompressionFactory)BuiltinCompressions.none),
    DELAYED((CompressionFactory)BuiltinCompressions.delayedZlib);

    public static final Set VALUES;
    private final CompressionFactory factory;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private CompressionConfigValue() {
        void var3_2;
        this.factory = var3_2;
    }

    @Override
    public final String getName() {
        return this.factory.getName();
    }

    @Override
    public final Compression create() {
        return (Compression)this.factory.create();
    }

    @Override
    public boolean isSupported() {
        return this.factory.isSupported();
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public boolean isDelayed() {
        return this.factory.isDelayed();
    }

    @Override
    public boolean isCompressionExecuted() {
        return this.factory.isCompressionExecuted();
    }

    public static CompressionConfigValue fromName(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        for (CompressionConfigValue compressionConfigValue : VALUES) {
            if (!string.equalsIgnoreCase(compressionConfigValue.name())) continue;
            return compressionConfigValue;
        }
        return null;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(CompressionConfigValue.class));
    }
}

