/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.compression;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.sshd.common.compression.BaseCompression;
import org.apache.sshd.common.compression.Compression$Type;
import org.apache.sshd.common.util.buffer.Buffer;

public class CompressionZlib
extends BaseCompression {
    private static final int BUF_SIZE = 4096;
    private byte[] tmpbuf = new byte[4096];
    private Deflater compresser;
    private Inflater decompresser;

    public CompressionZlib() {
        this("zlib");
    }

    protected CompressionZlib(String string) {
        super(string);
    }

    @Override
    public boolean isDelayed() {
        return false;
    }

    @Override
    public void init(Compression$Type compression$Type, int n2) {
        this.compresser = new Deflater(n2);
        this.decompresser = new Inflater();
    }

    @Override
    public void compress(Buffer buffer) {
        this.compresser.setInput(buffer.array(), buffer.rpos(), buffer.available());
        buffer.wpos(buffer.rpos());
        int n2 = this.compresser.deflate(this.tmpbuf, 0, this.tmpbuf.length, 2);
        while (n2 > 0) {
            buffer.putRawBytes(this.tmpbuf, 0, n2);
            n2 = this.compresser.deflate(this.tmpbuf, 0, this.tmpbuf.length, 2);
        }
    }

    @Override
    public void uncompress(Buffer buffer, Buffer buffer2) {
        this.decompresser.setInput(buffer.array(), buffer.rpos(), buffer.available());
        try {
            int n2 = this.decompresser.inflate(this.tmpbuf);
            while (n2 > 0) {
                buffer2.putRawBytes(this.tmpbuf, 0, n2);
                n2 = this.decompresser.inflate(this.tmpbuf);
            }
        }
        catch (DataFormatException dataFormatException) {
            throw new IOException("Error decompressing data", dataFormatException);
        }
    }
}

