/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.compression;

import java.io.StreamCorruptedException;
import org.apache.sshd.common.compression.BaseCompression;
import org.apache.sshd.common.compression.Compression$Type;
import org.apache.sshd.common.util.buffer.Buffer;

public class CompressionNone
extends BaseCompression {
    private Compression$Type type;
    private int level;

    public CompressionNone() {
        super("none");
    }

    @Override
    public void init(Compression$Type compression$Type, int n2) {
        this.type = compression$Type;
        this.level = n2;
    }

    @Override
    public boolean isCompressionExecuted() {
        return false;
    }

    @Override
    public void compress(Buffer buffer) {
        if (!Compression$Type.Deflater.equals((Object)this.type)) {
            throw new StreamCorruptedException("Not set up for compression: " + (Object)((Object)this.type));
        }
    }

    @Override
    public void uncompress(Buffer buffer, Buffer buffer2) {
        if (!Compression$Type.Inflater.equals((Object)this.type)) {
            throw new StreamCorruptedException("Not set up for de-compression: " + (Object)((Object)this.type));
        }
        if (buffer != buffer2) {
            throw new StreamCorruptedException("Separate de-compression buffers provided");
        }
    }

    @Override
    public boolean isDelayed() {
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + (Object)((Object)this.type) + "/" + this.level + "]";
    }
}

