/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.compression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.compression.BuiltinCompressions$1;
import org.apache.sshd.common.compression.BuiltinCompressions$2;
import org.apache.sshd.common.compression.BuiltinCompressions$3;
import org.apache.sshd.common.compression.BuiltinCompressions$ParseResult;
import org.apache.sshd.common.compression.CompressionFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public abstract class BuiltinCompressions
extends Enum
implements CompressionFactory {
    public static final /* enum */ BuiltinCompressions none = new BuiltinCompressions$1("none");
    public static final /* enum */ BuiltinCompressions zlib = new BuiltinCompressions$2("zlib");
    public static final /* enum */ BuiltinCompressions delayedZlib = new BuiltinCompressions$3("zlib@openssh.com");
    public static final Set VALUES;
    private static final Map EXTENSIONS;
    private final String name;
    private static final /* synthetic */ BuiltinCompressions[] $VALUES;

    public static BuiltinCompressions[] values() {
        return (BuiltinCompressions[])$VALUES.clone();
    }

    public static BuiltinCompressions valueOf(String string) {
        return Enum.valueOf(BuiltinCompressions.class, string);
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BuiltinCompressions() {
        void var3_2;
        void var2_-1;
        void var1_-1;
        this.name = var3_2;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean isDelayed() {
        return false;
    }

    @Override
    public boolean isCompressionExecuted() {
        return true;
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public final boolean isSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerExtension(CompressionFactory compressionFactory) {
        String string = Objects.requireNonNull(compressionFactory, "No extension provided").getName();
        ValidateUtils.checkTrue(BuiltinCompressions.fromFactoryName(string) == null, "Extension overrides built-in: %s", (Object)string);
        Map map = EXTENSIONS;
        synchronized (map) {
            ValidateUtils.checkTrue(!EXTENSIONS.containsKey(string), "Extension overrides existing: %s", (Object)string);
            EXTENSIONS.put(string, compressionFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableSet getRegisteredExtensions() {
        Map map = EXTENSIONS;
        synchronized (map) {
            return GenericUtils.asSortedSet(NamedResource.BY_NAME_COMPARATOR, EXTENSIONS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompressionFactory unregisterExtension(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        Map map = EXTENSIONS;
        synchronized (map) {
            return (CompressionFactory)EXTENSIONS.remove(string);
        }
    }

    public static BuiltinCompressions fromFactoryName(String string) {
        return (BuiltinCompressions)NamedResource.findByName(string, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static BuiltinCompressions$ParseResult parseCompressionsList(String string) {
        return BuiltinCompressions.parseCompressionsList(GenericUtils.split(string, ','));
    }

    public static BuiltinCompressions$ParseResult parseCompressionsList(String ... stringArray) {
        return BuiltinCompressions.parseCompressionsList(GenericUtils.isEmpty(stringArray) ? Collections.emptyList() : Arrays.asList(stringArray));
    }

    public static BuiltinCompressions$ParseResult parseCompressionsList(Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return BuiltinCompressions$ParseResult.EMPTY;
        }
        ArrayList<CompressionFactory> arrayList = new ArrayList<CompressionFactory>(collection.size());
        List list = Collections.emptyList();
        for (String string : collection) {
            CompressionFactory compressionFactory = BuiltinCompressions.resolveFactory(string);
            if (compressionFactory != null) {
                arrayList.add(compressionFactory);
                continue;
            }
            if (list.isEmpty()) {
                list = new ArrayList();
            }
            list.add(string);
        }
        return new BuiltinCompressions$ParseResult(arrayList, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompressionFactory resolveFactory(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        BuiltinCompressions builtinCompressions = BuiltinCompressions.fromFactoryName(string);
        if (builtinCompressions != null) {
            return builtinCompressions;
        }
        Map map = EXTENSIONS;
        synchronized (map) {
            return (CompressionFactory)EXTENSIONS.get(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ BuiltinCompressions(String string, BuiltinCompressions$1 builtinCompressions$1) {
        this((String)var1_-1, (int)builtinCompressions$1, (String)var3_2);
        void var3_2;
        void var1_-1;
    }

    static {
        $VALUES = new BuiltinCompressions[]{none, zlib, delayedZlib};
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinCompressions.class));
        EXTENSIONS = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    }
}

