/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.math.BigInteger;
import java.security.interfaces.ECKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.OptionalFeature;
import org.apache.sshd.common.cipher.ECCurves$ECPointCompression;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.digest.DigestFactory;
import org.apache.sshd.common.keyprovider.KeySizeIndicator;
import org.apache.sshd.common.keyprovider.KeyTypeIndicator;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public enum ECCurves implements NamedResource,
OptionalFeature,
KeySizeIndicator,
KeyTypeIndicator
{
    nistp256("nistp256", new int[]{1, 2, 840, 10045, 3, 1, 7}, new ECParameterSpec(new EllipticCurve(new ECFieldFp(new BigInteger("FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF", 16)), new BigInteger("FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC", 16), new BigInteger("5ac635d8aa3a93e7b3ebbd55769886bc651d06b0cc53b0f63bce3c3e27d2604b", 16)), new ECPoint(new BigInteger("6B17D1F2E12C4247F8BCE6E563A440F277037D812DEB33A0F4A13945D898C296", 16), new BigInteger("4FE342E2FE1A7F9B8EE7EB4A7C0F9E162BCE33576B315ECECBB6406837BF51F5", 16)), new BigInteger("FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551", 16), 1), 32, (DigestFactory)BuiltinDigests.sha256),
    nistp384("nistp384", new int[]{1, 3, 132, 0, 34}, new ECParameterSpec(new EllipticCurve(new ECFieldFp(new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFF", 16)), new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFC", 16), new BigInteger("B3312FA7E23EE7E4988E056BE3F82D19181D9C6EFE8141120314088F5013875AC656398D8A2ED19D2A85C8EDD3EC2AEF", 16)), new ECPoint(new BigInteger("AA87CA22BE8B05378EB1C71EF320AD746E1D3B628BA79B9859F741E082542A385502F25DBF55296C3A545E3872760AB7", 16), new BigInteger("3617DE4A96262C6F5D9E98BF9292DC29F8F41DBD289A147CE9DA3113B5F0B8C00A60B1CE1D7E819D7A431D7C90EA0E5F", 16)), new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC7634D81F4372DDF581A0DB248B0A77AECEC196ACCC52973", 16), 1), 48, (DigestFactory)BuiltinDigests.sha384),
    nistp521("nistp521", new int[]{1, 3, 132, 0, 35}, new ECParameterSpec(new EllipticCurve(new ECFieldFp(new BigInteger("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", 16)), new BigInteger("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC", 16), new BigInteger("0051953EB9618E1C9A1F929A21A0B68540EEA2DA725B99B315F3B8B489918EF109E156193951EC7E937B1652C0BD3BB1BF073573DF883D2C34F1EF451FD46B503F00", 16)), new ECPoint(new BigInteger("00C6858E06B70404E9CD9E3ECB662395B4429C648139053FB521F828AF606B4D3DBAA14B5E77EFE75928FE1DC127A2FFA8DE3348B3C1856A429BF97E7E31C2E5BD66", 16), new BigInteger("011839296A789A3BC0045C8A5FB42C7D1BD998F54449579B446817AFBD17273E662C97EE72995EF42640C550B9013FAD0761353C7086A272C24088BE94769FD16650", 16)), new BigInteger("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFA51868783BF2F966B7FCC0148F709A5D03BB5C9B8899C47AEBB6FB71E91386409", 16), 1), 66, (DigestFactory)BuiltinDigests.sha512);

    public static final Set VALUES;
    public static final NavigableSet NAMES;
    public static final NavigableSet KEY_TYPES;
    public static final Comparator BY_KEY_SIZE;
    public static final List SORTED_KEY_SIZE;
    private final String name;
    private final String keyType;
    private final String oidString;
    private final List oidValue;
    private final ECParameterSpec params;
    private final int keySize;
    private final int numOctets;
    private final DigestFactory digestFactory;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private ECCurves(ECParameterSpec eCParameterSpec, int n2, DigestFactory digestFactory) {
        void var7_5;
        void var6_4;
        this.name = ValidateUtils.checkNotNullAndNotEmpty((String)((Object)eCParameterSpec), "No curve name");
        this.oidString = NumberUtils.join('.', ValidateUtils.checkNotNullAndNotEmpty((int[])n2, "No OID"));
        this.oidValue = Collections.unmodifiableList(NumberUtils.asList((int[])n2));
        this.keyType = "ecdsa-sha2-" + (String)((Object)eCParameterSpec);
        this.params = (ECParameterSpec)ValidateUtils.checkNotNull((Object)digestFactory, "No EC params for %s", (Object)eCParameterSpec);
        this.keySize = ECCurves.getCurveSize((ECParameterSpec)((Object)digestFactory));
        this.numOctets = var6_4;
        this.digestFactory = (DigestFactory)Objects.requireNonNull(var7_5, "No digestFactory");
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final String getOID() {
        return this.oidString;
    }

    public final List getOIDValue() {
        return this.oidValue;
    }

    @Override
    public final String getKeyType() {
        return this.keyType;
    }

    @Override
    public final boolean isSupported() {
        return SecurityUtils.isECCSupported() && this.digestFactory.isSupported();
    }

    public final ECParameterSpec getParameters() {
        return this.params;
    }

    @Override
    public final int getKeySize() {
        return this.keySize;
    }

    public final int getNumPointOctets() {
        return this.numOctets;
    }

    public final Digest getDigestForParams() {
        return (Digest)this.digestFactory.create();
    }

    public static ECCurves fromKeyType(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        for (ECCurves eCCurves : VALUES) {
            if (!string.equalsIgnoreCase(eCCurves.getKeyType())) continue;
            return eCCurves;
        }
        return null;
    }

    public static ECCurves fromCurveName(String string) {
        return (ECCurves)NamedResource.findByName(string, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static ECCurves fromECKey(ECKey eCKey) {
        return ECCurves.fromCurveParameters(eCKey == null ? null : eCKey.getParams());
    }

    public static ECCurves fromCurveParameters(ECParameterSpec eCParameterSpec) {
        if (eCParameterSpec == null) {
            return null;
        }
        return ECCurves.fromCurveSize(ECCurves.getCurveSize(eCParameterSpec));
    }

    public static ECCurves fromCurveSize(int n2) {
        if (n2 <= 0) {
            return null;
        }
        for (ECCurves eCCurves : VALUES) {
            if (n2 != eCCurves.getKeySize()) continue;
            return eCCurves;
        }
        return null;
    }

    public static ECCurves fromOIDValue(List list) {
        if (GenericUtils.isEmpty(list)) {
            return null;
        }
        for (ECCurves eCCurves : VALUES) {
            List list2 = eCCurves.getOIDValue();
            if (list.size() != list2.size()) continue;
            boolean bl2 = true;
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                Number number = (Number)list2.get(i2);
                Number number2 = (Number)list.get(i2);
                if (number.intValue() == number2.intValue()) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            return eCCurves;
        }
        return null;
    }

    public static ECCurves fromOID(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        for (ECCurves eCCurves : VALUES) {
            if (!string.equalsIgnoreCase(eCCurves.getOID())) continue;
            return eCCurves;
        }
        return null;
    }

    public static int getCurveSize(ECParameterSpec eCParameterSpec) {
        EllipticCurve ellipticCurve = Objects.requireNonNull(eCParameterSpec, "No EC params").getCurve();
        ECField eCField = Objects.requireNonNull(ellipticCurve, "No EC curve").getField();
        return Objects.requireNonNull(eCField, "No EC field").getFieldSize();
    }

    public static byte[] encodeECPoint(ECPoint eCPoint, ECParameterSpec eCParameterSpec) {
        return ECCurves.encodeECPoint(eCPoint, eCParameterSpec.getCurve());
    }

    public static byte[] encodeECPoint(ECPoint eCPoint, EllipticCurve ellipticCurve) {
        int n2 = (ellipticCurve.getField().getFieldSize() + 7) / 8;
        byte[] byArray = new byte[2 * n2 + 1];
        byArray[0] = 4;
        byte[] byArray2 = ECCurves.removeLeadingZeroes(eCPoint.getAffineX().toByteArray());
        System.arraycopy(byArray2, 0, byArray, 1 + n2 - byArray2.length, byArray2.length);
        byte[] byArray3 = ECCurves.removeLeadingZeroes(eCPoint.getAffineY().toByteArray());
        System.arraycopy(byArray3, 0, byArray, 1 + n2 + n2 - byArray3.length, byArray3.length);
        return byArray;
    }

    private static byte[] removeLeadingZeroes(byte[] byArray) {
        int n2;
        if (byArray[0] != 0) {
            return byArray;
        }
        for (n2 = 1; n2 < byArray.length - 1 && byArray[n2] == 0; ++n2) {
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static BigInteger octetStringToInteger(byte ... byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return BigInteger.ZERO;
        }
        return new BigInteger(1, byArray);
    }

    public static ECPoint octetStringToEcPoint(byte ... byArray) {
        if (NumberUtils.isEmpty(byArray)) {
            return null;
        }
        int n2 = ECCurves.findFirstNonZeroIndex(byArray);
        if (n2 < 0) {
            throw new IllegalArgumentException("All zeroes ECPoint N/A");
        }
        byte by = byArray[n2];
        ECCurves$ECPointCompression eCCurves$ECPointCompression = ECCurves$ECPointCompression.fromIndicatorValue(by);
        if (eCCurves$ECPointCompression == null) {
            throw new UnsupportedOperationException("Unknown compression indicator value: 0x" + Integer.toHexString(by & 0xFF));
        }
        return eCCurves$ECPointCompression.octetStringToEcPoint(byArray, n2 + 1, byArray.length - n2 - 1);
    }

    private static int findFirstNonZeroIndex(byte ... byArray) {
        if (NumberUtils.isEmpty(byArray)) {
            return -1;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == 0) continue;
            return i2;
        }
        return -1;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(ECCurves.class));
        NAMES = Collections.unmodifiableNavigableSet(GenericUtils.mapSort(VALUES, ECCurves::getName, String.CASE_INSENSITIVE_ORDER));
        KEY_TYPES = Collections.unmodifiableNavigableSet(GenericUtils.mapSort(VALUES, ECCurves::getKeyType, String.CASE_INSENSITIVE_ORDER));
        BY_KEY_SIZE = (eCCurves, eCCurves2) -> {
            int n2 = eCCurves == null ? Integer.MAX_VALUE : eCCurves.getKeySize();
            int n3 = eCCurves2 == null ? Integer.MAX_VALUE : eCCurves2.getKeySize();
            return Integer.compare(n2, n3);
        };
        SORTED_KEY_SIZE = Collections.unmodifiableList(VALUES.stream().sorted(BY_KEY_SIZE).collect(Collectors.toList()));
    }
}

