/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.security.spec.ECPoint;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sshd.common.cipher.ECCurves$1;
import org.apache.sshd.common.cipher.ECCurves$ECPointCompression$1;
import org.apache.sshd.common.cipher.ECCurves$ECPointCompression$2;
import org.apache.sshd.common.cipher.ECCurves$ECPointCompression$3;

public abstract class ECCurves$ECPointCompression
extends Enum {
    public static final /* enum */ ECCurves$ECPointCompression VARIANT2 = new ECCurves$ECPointCompression$1(2);
    public static final /* enum */ ECCurves$ECPointCompression VARIANT3 = new ECCurves$ECPointCompression$2(3);
    public static final /* enum */ ECCurves$ECPointCompression UNCOMPRESSED = new ECCurves$ECPointCompression$3(4);
    public static final Set VALUES;
    private final byte indicatorValue;
    private static final /* synthetic */ ECCurves$ECPointCompression[] $VALUES;

    public static ECCurves$ECPointCompression[] values() {
        return (ECCurves$ECPointCompression[])$VALUES.clone();
    }

    public static ECCurves$ECPointCompression valueOf(String string) {
        return Enum.valueOf(ECCurves$ECPointCompression.class, string);
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private ECCurves$ECPointCompression() {
        void var3_2;
        void var2_-1;
        void var1_-1;
        this.indicatorValue = var3_2;
    }

    public final byte getIndicatorValue() {
        return this.indicatorValue;
    }

    public abstract ECPoint octetStringToEcPoint(byte[] var1, int var2, int var3);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] ecPointToOctetString(String string, ECPoint eCPoint) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(196);){
            this.writeECPoint(byteArrayOutputStream, string, eCPoint);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("ecPointToOctetString(" + string + ") failed (" + iOException.getClass().getSimpleName() + ") to write data: " + iOException.getMessage(), iOException);
        }
    }

    public void writeECPoint(OutputStream outputStream, String string, ECPoint eCPoint) {
        if (outputStream == null) {
            throw new EOFException("No output stream");
        }
        throw new StreamCorruptedException("writeECPoint(" + this.name() + ")[" + eCPoint + "] N/A");
    }

    protected void writeCoordinate(OutputStream outputStream, String string, BigInteger bigInteger, int n2) {
        byte[] byArray = bigInteger.toByteArray();
        int n3 = 0;
        int n4 = byArray.length;
        if (n4 > n2 && byArray[0] == 0) {
            ++n3;
            --n4;
        }
        if (n4 > n2) {
            throw new StreamCorruptedException("writeCoordinate(" + this.name() + ")[" + string + "] value length (" + n4 + ") exceeds max. (" + n2 + ") for " + bigInteger);
        }
        if (n4 < n2) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n3, byArray2, n2 - n4, n4);
            byArray = byArray2;
            n3 = 0;
            n4 = byArray.length;
        }
        outputStream.write(byArray, n3, n4);
    }

    public static ECCurves$ECPointCompression fromIndicatorValue(int n2) {
        if (n2 < 0 || n2 > 255) {
            return null;
        }
        for (ECCurves$ECPointCompression eCCurves$ECPointCompression : VALUES) {
            if (n2 != eCCurves$ECPointCompression.getIndicatorValue()) continue;
            return eCCurves$ECPointCompression;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ ECCurves$ECPointCompression(byte by, ECCurves$1 eCCurves$1) {
        this((String)var1_-1, (int)eCCurves$1, (byte)var3_2);
        void var3_2;
        void var1_-1;
    }

    static {
        $VALUES = new ECCurves$ECPointCompression[]{VARIANT2, VARIANT3, UNCOMPRESSED};
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(ECCurves$ECPointCompression.class));
    }
}

