/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.security.spec.ECPoint;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.cipher.ECCurves$ECPointCompression;
import org.apache.sshd.common.config.keys.KeyEntryResolver;

final class ECCurves$ECPointCompression$3
extends ECCurves$ECPointCompression {
    ECCurves$ECPointCompression$3(byte by) {
    }

    @Override
    public ECPoint octetStringToEcPoint(byte[] byArray, int n2, int n3) {
        int n4 = n3 / 2;
        if (n3 != n4 * 2) {
            throw new IllegalArgumentException("octetStringToEcPoint(" + this.name() + ")  invalid remainder octets representation:  expected=" + 2 * n4 + ", actual=" + n3);
        }
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[n4];
        System.arraycopy(byArray, n2, byArray2, 0, n4);
        System.arraycopy(byArray, n2 + n4, byArray3, 0, n4);
        BigInteger bigInteger = ECCurves.octetStringToInteger(byArray2);
        BigInteger bigInteger2 = ECCurves.octetStringToInteger(byArray3);
        return new ECPoint(bigInteger, bigInteger2);
    }

    @Override
    public void writeECPoint(OutputStream outputStream, String string, ECPoint eCPoint) {
        ECCurves eCCurves = ECCurves.fromCurveName(string);
        if (eCCurves == null) {
            throw new StreamCorruptedException("writeECPoint(" + this.name() + ")[" + string + "] cannot determine octets count");
        }
        int n2 = eCCurves.getNumPointOctets();
        KeyEntryResolver.encodeInt(outputStream, 1 + 2 * n2);
        outputStream.write(this.getIndicatorValue());
        this.writeCoordinate(outputStream, "X", eCPoint.getAffineX(), n2);
        this.writeCoordinate(outputStream, "Y", eCPoint.getAffineY(), n2);
    }
}

