/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import org.apache.sshd.common.cipher.Cipher$Mode;
import org.apache.sshd.common.cipher.CipherInformation;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;

public interface Cipher
extends CipherInformation {
    public void init(Cipher$Mode var1, byte[] var2, byte[] var3);

    default public void update(byte[] byArray) {
        this.update(byArray, 0, NumberUtils.length(byArray));
    }

    public void update(byte[] var1, int var2, int var3);

    default public void updateAAD(byte[] byArray) {
        this.updateAAD(byArray, 0, NumberUtils.length(byArray));
    }

    public void updateAAD(byte[] var1, int var2, int var3);

    default public void updateWithAAD(byte[] byArray, int n2, int n3, int n4) {
        this.updateAAD(byArray, n2, n3);
        this.update(byArray, n2 + n3, n4);
    }

    public static boolean checkSupported(String string, int n2) {
        ValidateUtils.checkNotNullAndNotEmpty(string, "No transformation");
        if (n2 <= 0) {
            throw new IllegalArgumentException("Bad key length (" + n2 + ") for cipher=" + string);
        }
        try {
            int n3 = javax.crypto.Cipher.getMaxAllowedKeyLength(string);
            return n3 >= n2;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

