/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import org.apache.sshd.common.cipher.ChaCha20Cipher$ChaChaEngine;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.cipher.Cipher$Mode;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.mac.Poly1305Mac;
import org.apache.sshd.common.util.ValidateUtils;

public class ChaCha20Cipher
implements Cipher {
    protected final ChaCha20Cipher$ChaChaEngine headerEngine = new ChaCha20Cipher$ChaChaEngine();
    protected final ChaCha20Cipher$ChaChaEngine bodyEngine = new ChaCha20Cipher$ChaChaEngine();
    protected final Mac mac = new Poly1305Mac();
    protected Cipher$Mode mode;

    @Override
    public String getAlgorithm() {
        return "ChaCha20";
    }

    @Override
    public void init(Cipher$Mode cipher$Mode, byte[] byArray, byte[] byArray2) {
        this.mode = cipher$Mode;
        this.bodyEngine.initKey(Arrays.copyOfRange(byArray, 0, 32));
        this.bodyEngine.initNonce(byArray2);
        this.mac.init(this.bodyEngine.polyKey());
        this.headerEngine.initKey(Arrays.copyOfRange(byArray, 32, 64));
        this.headerEngine.initNonce(byArray2);
        this.headerEngine.initCounter(0L);
    }

    @Override
    public void updateAAD(byte[] byArray, int n2, int n3) {
        ValidateUtils.checkState(this.mode != null, "Cipher not initialized");
        ValidateUtils.checkTrue(n3 == 4, "AAD only supported for encrypted packet length");
        if (this.mode == Cipher$Mode.Decrypt) {
            this.mac.update(byArray, n2, n3);
        }
        this.headerEngine.crypt(byArray, n2, n3, byArray, n2);
        if (this.mode == Cipher$Mode.Encrypt) {
            this.mac.update(byArray, n2, n3);
        }
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        ValidateUtils.checkState(this.mode != null, "Cipher not initialized");
        if (this.mode == Cipher$Mode.Decrypt) {
            this.mac.update(byArray, n2, n3);
            byte[] byArray2 = this.mac.doFinal();
            if (!Mac.equals(byArray, n2 + n3, byArray2, 0, byArray2.length)) {
                throw new AEADBadTagException("Tag mismatch");
            }
        }
        this.bodyEngine.crypt(byArray, n2, n3, byArray, n2);
        if (this.mode == Cipher$Mode.Encrypt) {
            this.mac.update(byArray, n2, n3);
            this.mac.doFinal(byArray, n2 + n3);
        }
        this.headerEngine.advanceNonce();
        this.headerEngine.initCounter(0L);
        this.bodyEngine.advanceNonce();
        this.mac.init(this.bodyEngine.polyKey());
    }

    @Override
    public String getTransformation() {
        return "ChaCha20";
    }

    @Override
    public int getIVSize() {
        return 8;
    }

    @Override
    public int getAuthenticationTagSize() {
        return 16;
    }

    @Override
    public int getCipherBlockSize() {
        return 8;
    }

    @Override
    public int getKdfSize() {
        return 64;
    }

    @Override
    public int getKeySize() {
        return 256;
    }
}

