/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.nio.charset.StandardCharsets;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public class ChaCha20Cipher$ChaChaEngine {
    private static final int BLOCK_BYTES = 64;
    private static final int BLOCK_INTS = 16;
    private static final int KEY_OFFSET = 4;
    private static final int KEY_BYTES = 32;
    private static final int KEY_INTS = 8;
    private static final int COUNTER_OFFSET = 12;
    private static final int NONCE_OFFSET = 14;
    private static final int NONCE_BYTES = 8;
    private static final int NONCE_INTS = 2;
    private static final int[] ENGINE_STATE_HEADER = ChaCha20Cipher$ChaChaEngine.unpackSigmaString("expand 32-byte k".getBytes(StandardCharsets.US_ASCII));
    protected final int[] x = new int[16];
    protected final int[] engineState = new int[16];
    protected final byte[] nonce = new byte[8];
    protected long initialNonce;

    protected ChaCha20Cipher$ChaChaEngine() {
        System.arraycopy(ENGINE_STATE_HEADER, 0, this.engineState, 0, 4);
    }

    protected void initKey(byte[] byArray) {
        ChaCha20Cipher$ChaChaEngine.unpackIntsLE(byArray, 0, 8, this.engineState, 4);
    }

    protected void initNonce(byte[] byArray) {
        this.initialNonce = BufferUtils.getLong(byArray, 0, NumberUtils.length(byArray));
        ChaCha20Cipher$ChaChaEngine.unpackIntsLE(byArray, 0, 2, this.engineState, 14);
        System.arraycopy(byArray, 0, this.nonce, 0, 8);
    }

    protected void advanceNonce() {
        long l2 = BufferUtils.getLong(this.nonce, 0, 8) + 1L;
        ValidateUtils.checkState(l2 != this.initialNonce, "Packet sequence number cannot be reused with the same key");
        BufferUtils.putLong(l2, this.nonce, 0, 8);
        ChaCha20Cipher$ChaChaEngine.unpackIntsLE(this.nonce, 0, 2, this.engineState, 14);
    }

    protected void initCounter(long l2) {
        this.engineState[12] = (int)l2;
        this.engineState[13] = (int)(l2 >>> 32);
    }

    protected void crypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        while (n3 > 0) {
            System.arraycopy(this.engineState, 0, this.x, 0, 16);
            ChaCha20Cipher$ChaChaEngine.permute(this.x);
            int n5 = Math.min(64, n3);
            int n6 = 0;
            int n7 = 0;
            while (n6 < n5) {
                int n8 = this.engineState[n7] + this.x[n7];
                int n9 = Math.min(4, n3);
                int n10 = ChaCha20Cipher$ChaChaEngine.unpackIntLE(byArray, n2, n9);
                int n11 = n8 ^ n10;
                ChaCha20Cipher$ChaChaEngine.packIntLE(n11, byArray2, n4, n9);
                n2 += n9;
                n4 += n9;
                n3 -= n9;
                n6 += 4;
                ++n7;
            }
            this.engineState[12] = this.engineState[12] + 1;
            n6 = this.engineState[12];
            if (n6 != 0) continue;
            this.engineState[13] = this.engineState[13] + 1;
        }
    }

    protected byte[] polyKey() {
        byte[] byArray = new byte[32];
        this.initCounter(0L);
        this.crypt(byArray, 0, byArray.length, byArray, 0);
        this.initCounter(1L);
        return byArray;
    }

    protected static void permute(int[] nArray) {
        for (int i2 = 0; i2 < 10; ++i2) {
            ChaCha20Cipher$ChaChaEngine.columnRound(nArray);
            ChaCha20Cipher$ChaChaEngine.diagonalRound(nArray);
        }
    }

    protected static void columnRound(int[] nArray) {
        ChaCha20Cipher$ChaChaEngine.quarterRound(nArray, 0, 4, 8, 12);
        ChaCha20Cipher$ChaChaEngine.quarterRound(nArray, 1, 5, 9, 13);
        ChaCha20Cipher$ChaChaEngine.quarterRound(nArray, 2, 6, 10, 14);
        ChaCha20Cipher$ChaChaEngine.quarterRound(nArray, 3, 7, 11, 15);
    }

    protected static void diagonalRound(int[] nArray) {
        ChaCha20Cipher$ChaChaEngine.quarterRound(nArray, 0, 5, 10, 15);
        ChaCha20Cipher$ChaChaEngine.quarterRound(nArray, 1, 6, 11, 12);
        ChaCha20Cipher$ChaChaEngine.quarterRound(nArray, 2, 7, 8, 13);
        ChaCha20Cipher$ChaChaEngine.quarterRound(nArray, 3, 4, 9, 14);
    }

    protected static void quarterRound(int[] nArray, int n2, int n3, int n4, int n5) {
        int n6 = n2;
        nArray[n6] = nArray[n6] + nArray[n3];
        nArray[n5] = Integer.rotateLeft(nArray[n5] ^ nArray[n2], 16);
        int n7 = n4;
        nArray[n7] = nArray[n7] + nArray[n5];
        nArray[n3] = Integer.rotateLeft(nArray[n3] ^ nArray[n4], 12);
        int n8 = n2;
        nArray[n8] = nArray[n8] + nArray[n3];
        nArray[n5] = Integer.rotateLeft(nArray[n5] ^ nArray[n2], 8);
        int n9 = n4;
        nArray[n9] = nArray[n9] + nArray[n5];
        nArray[n3] = Integer.rotateLeft(nArray[n3] ^ nArray[n4], 7);
    }

    private static int unpackIntLE(byte[] byArray, int n2) {
        return ChaCha20Cipher$ChaChaEngine.unpackIntLE(byArray, n2, 4);
    }

    private static int unpackIntLE(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 |= Byte.toUnsignedInt(byArray[n2 + i2]) << i2 * 8;
        }
        return n4;
    }

    private static void unpackIntsLE(byte[] byArray, int n2, int n3, int[] nArray, int n4) {
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[n4++] = ChaCha20Cipher$ChaChaEngine.unpackIntLE(byArray, n2);
            n2 += 4;
        }
    }

    private static int[] unpackSigmaString(byte[] byArray) {
        int[] nArray = new int[4];
        ChaCha20Cipher$ChaChaEngine.unpackIntsLE(byArray, 0, 4, nArray, 0);
        return nArray;
    }

    private static void packIntLE(int n2, byte[] byArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            byArray[n3 + i2] = (byte)(n2 >>> i2 * 8);
        }
    }
}

