/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.BaseCipher;
import org.apache.sshd.common.cipher.BuiltinCiphers$1;
import org.apache.sshd.common.cipher.BuiltinCiphers$10;
import org.apache.sshd.common.cipher.BuiltinCiphers$11;
import org.apache.sshd.common.cipher.BuiltinCiphers$12;
import org.apache.sshd.common.cipher.BuiltinCiphers$13;
import org.apache.sshd.common.cipher.BuiltinCiphers$14;
import org.apache.sshd.common.cipher.BuiltinCiphers$2;
import org.apache.sshd.common.cipher.BuiltinCiphers$3;
import org.apache.sshd.common.cipher.BuiltinCiphers$4;
import org.apache.sshd.common.cipher.BuiltinCiphers$5;
import org.apache.sshd.common.cipher.BuiltinCiphers$6;
import org.apache.sshd.common.cipher.BuiltinCiphers$7;
import org.apache.sshd.common.cipher.BuiltinCiphers$8;
import org.apache.sshd.common.cipher.BuiltinCiphers$9;
import org.apache.sshd.common.cipher.BuiltinCiphers$ParseResult;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.cipher.CipherFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class BuiltinCiphers
extends Enum
implements CipherFactory {
    public static final /* enum */ BuiltinCiphers none = new BuiltinCiphers$1("none", 0, 0, 0, "None", 0, "None", 8);
    public static final /* enum */ BuiltinCiphers aes128cbc = new BuiltinCiphers$2("aes128-cbc", 16, 0, 16, "AES", 128, "AES/CBC/NoPadding", 16);
    public static final /* enum */ BuiltinCiphers aes128ctr = new BuiltinCiphers$3("aes128-ctr", 16, 0, 16, "AES", 128, "AES/CTR/NoPadding", 16);
    public static final /* enum */ BuiltinCiphers aes128gcm = new BuiltinCiphers$4("aes128-gcm@openssh.com", 12, 16, 16, "AES", 128, "AES/GCM/NoPadding", 16);
    public static final /* enum */ BuiltinCiphers aes256gcm = new BuiltinCiphers$5("aes256-gcm@openssh.com", 12, 16, 32, "AES", 256, "AES/GCM/NoPadding", 16);
    public static final /* enum */ BuiltinCiphers aes192cbc = new BuiltinCiphers$6("aes192-cbc", 16, 0, 24, "AES", 192, "AES/CBC/NoPadding", 16);
    public static final /* enum */ BuiltinCiphers aes192ctr = new BuiltinCiphers$7("aes192-ctr", 16, 0, 24, "AES", 192, "AES/CTR/NoPadding", 16);
    public static final /* enum */ BuiltinCiphers aes256cbc = new BuiltinCiphers$8("aes256-cbc", 16, 0, 32, "AES", 256, "AES/CBC/NoPadding", 16);
    public static final /* enum */ BuiltinCiphers aes256ctr = new BuiltinCiphers$9("aes256-ctr", 16, 0, 32, "AES", 256, "AES/CTR/NoPadding", 16);
    @Deprecated
    public static final /* enum */ BuiltinCiphers arcfour128 = new BuiltinCiphers$10("arcfour128", 8, 0, 16, "ARCFOUR", 128, "RC4", 8);
    @Deprecated
    public static final /* enum */ BuiltinCiphers arcfour256 = new BuiltinCiphers$11("arcfour256", 8, 0, 32, "ARCFOUR", 256, "RC4", 8);
    @Deprecated
    public static final /* enum */ BuiltinCiphers blowfishcbc = new BuiltinCiphers$12("blowfish-cbc", 8, 0, 16, "Blowfish", 128, "Blowfish/CBC/NoPadding", 8);
    public static final /* enum */ BuiltinCiphers cc20p1305_openssh = new BuiltinCiphers$13("chacha20-poly1305@openssh.com", 8, 16, 64, "ChaCha", 256, "ChaCha", 8);
    @Deprecated
    public static final /* enum */ BuiltinCiphers tripledescbc = new BuiltinCiphers$14("3des-cbc", 8, 0, 24, "DESede", 192, "DESede/CBC/NoPadding", 8);
    public static final Set VALUES;
    private static final Map EXTENSIONS;
    private final String factoryName;
    private final int ivsize;
    private final int authSize;
    private final int kdfSize;
    private final int keysize;
    private final int blkSize;
    private final String algorithm;
    private final String transformation;
    private final boolean supported;
    private static final /* synthetic */ BuiltinCiphers[] $VALUES;

    public static BuiltinCiphers[] values() {
        return (BuiltinCiphers[])$VALUES.clone();
    }

    public static BuiltinCiphers valueOf(String string) {
        return Enum.valueOf(BuiltinCiphers.class, string);
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BuiltinCiphers(int n2, int n3, String string3, int n4, String string4, int n5) {
        void var10_8;
        void var9_7;
        void var2_-1;
        void var1_-1;
        this.factoryName = (String)n2;
        this.ivsize = n3;
        this.authSize = (int)string3;
        this.kdfSize = n4;
        this.keysize = n5;
        this.algorithm = string4;
        this.transformation = var9_7;
        this.blkSize = var10_8;
        this.supported = "none".equals(n2) || Cipher.checkSupported(this.transformation, this.keysize);
    }

    @Override
    public final String getName() {
        return this.factoryName;
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public boolean isSupported() {
        return this.supported;
    }

    @Override
    public int getKeySize() {
        return this.keysize;
    }

    @Override
    public int getIVSize() {
        return this.ivsize;
    }

    @Override
    public int getAuthenticationTagSize() {
        return this.authSize;
    }

    @Override
    public int getKdfSize() {
        return this.kdfSize;
    }

    @Override
    public int getCipherBlockSize() {
        return this.blkSize;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getTransformation() {
        return this.transformation;
    }

    @Override
    public Cipher create() {
        return new BaseCipher(this.getIVSize(), this.getAuthenticationTagSize(), this.getKdfSize(), this.getAlgorithm(), this.getKeySize(), this.getTransformation(), this.getCipherBlockSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerExtension(CipherFactory cipherFactory) {
        String string = Objects.requireNonNull(cipherFactory, "No extension provided").getName();
        ValidateUtils.checkTrue(BuiltinCiphers.fromFactoryName(string) == null, "Extension overrides built-in: %s", (Object)string);
        Map map = EXTENSIONS;
        synchronized (map) {
            ValidateUtils.checkTrue(!EXTENSIONS.containsKey(string), "Extension overrides existing: %s", (Object)string);
            EXTENSIONS.put(string, cipherFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableSet getRegisteredExtensions() {
        Map map = EXTENSIONS;
        synchronized (map) {
            return GenericUtils.asSortedSet(NamedResource.BY_NAME_COMPARATOR, EXTENSIONS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamedFactory unregisterExtension(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        Map map = EXTENSIONS;
        synchronized (map) {
            return (NamedFactory)EXTENSIONS.remove(string);
        }
    }

    public static BuiltinCiphers fromString(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        for (BuiltinCiphers builtinCiphers : VALUES) {
            if (!string.equalsIgnoreCase(builtinCiphers.name())) continue;
            return builtinCiphers;
        }
        return null;
    }

    public static BuiltinCiphers fromFactory(NamedFactory namedFactory) {
        if (namedFactory == null) {
            return null;
        }
        return BuiltinCiphers.fromFactoryName(namedFactory.getName());
    }

    public static BuiltinCiphers fromFactoryName(String string) {
        return (BuiltinCiphers)NamedResource.findByName(string, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static BuiltinCiphers$ParseResult parseCiphersList(String string) {
        return BuiltinCiphers.parseCiphersList(GenericUtils.split(string, ','));
    }

    public static BuiltinCiphers$ParseResult parseCiphersList(String ... stringArray) {
        return BuiltinCiphers.parseCiphersList(GenericUtils.isEmpty(stringArray) ? Collections.emptyList() : Arrays.asList(stringArray));
    }

    public static BuiltinCiphers$ParseResult parseCiphersList(Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return BuiltinCiphers$ParseResult.EMPTY;
        }
        ArrayList<CipherFactory> arrayList = new ArrayList<CipherFactory>(collection.size());
        List list = Collections.emptyList();
        for (String string : collection) {
            CipherFactory cipherFactory = BuiltinCiphers.resolveFactory(string);
            if (cipherFactory != null) {
                arrayList.add(cipherFactory);
                continue;
            }
            if (list.isEmpty()) {
                list = new ArrayList();
            }
            list.add(string);
        }
        return new BuiltinCiphers$ParseResult(arrayList, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CipherFactory resolveFactory(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        BuiltinCiphers builtinCiphers = BuiltinCiphers.fromFactoryName(string);
        if (builtinCiphers != null) {
            return builtinCiphers;
        }
        Map map = EXTENSIONS;
        synchronized (map) {
            return (CipherFactory)EXTENSIONS.get(string);
        }
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    /* synthetic */ BuiltinCiphers(String string, int n2, int n3, int n4, String string2, int n5, String string3, int n6, BuiltinCiphers$1 builtinCiphers$1) {
        this((String)var1_-1, n2, (String)n3, n4, (int)string2, n5, string3, n6, (String)((Object)builtinCiphers$1), (int)var10_9);
        void var10_9;
        void var1_-1;
    }

    static {
        $VALUES = new BuiltinCiphers[]{none, aes128cbc, aes128ctr, aes128gcm, aes256gcm, aes192cbc, aes192ctr, aes256cbc, aes256ctr, arcfour128, arcfour256, blowfishcbc, cc20p1305_openssh, tripledescbc};
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinCiphers.class));
        EXTENSIONS = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    }
}

