/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sshd.common.util.GenericUtils;

public final class BuiltinCiphers$Constants {
    public static final String NONE = "none";
    public static final Pattern NONE_CIPHER_PATTERN = Pattern.compile("(^|.*,)none($|,.*)");
    public static final String AES128_CBC = "aes128-cbc";
    public static final String AES128_CTR = "aes128-ctr";
    public static final String AES128_GCM = "aes128-gcm@openssh.com";
    public static final String AES192_CBC = "aes192-cbc";
    public static final String AES192_CTR = "aes192-ctr";
    public static final String AES256_CBC = "aes256-cbc";
    public static final String AES256_CTR = "aes256-ctr";
    public static final String AES256_GCM = "aes256-gcm@openssh.com";
    public static final String ARCFOUR128 = "arcfour128";
    public static final String ARCFOUR256 = "arcfour256";
    public static final String BLOWFISH_CBC = "blowfish-cbc";
    public static final String CC20P1305_OPENSSH = "chacha20-poly1305@openssh.com";
    public static final String TRIPLE_DES_CBC = "3des-cbc";

    private BuiltinCiphers$Constants() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static boolean isNoneCipherIncluded(String string) {
        if (GenericUtils.isEmpty(string)) {
            return false;
        }
        Matcher matcher = NONE_CIPHER_PATTERN.matcher(string);
        return matcher.matches();
    }
}

