/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.sshd.common.cipher.BaseCipher;
import org.apache.sshd.common.cipher.BaseGCMCipher$CounterGCMParameterSpec;
import org.apache.sshd.common.cipher.Cipher$Mode;
import org.apache.sshd.common.util.security.SecurityUtils;

public class BaseGCMCipher
extends BaseCipher {
    protected Cipher$Mode mode;
    protected boolean initialized;
    protected BaseGCMCipher$CounterGCMParameterSpec parameters;
    protected SecretKey secretKey;

    public BaseGCMCipher(int n2, int n3, int n4, String string, int n5, String string2, int n6) {
        super(n2, n3, n4, string, n5, string2, n6);
    }

    @Override
    protected Cipher createCipherInstance(Cipher$Mode cipher$Mode, byte[] byArray, byte[] byArray2) {
        this.mode = cipher$Mode;
        this.secretKey = new SecretKeySpec(byArray, this.getAlgorithm());
        this.parameters = new BaseGCMCipher$CounterGCMParameterSpec(this.getAuthenticationTagSize() * 8, byArray2);
        return SecurityUtils.getCipher(this.getTransformation());
    }

    protected Cipher getInitializedCipherInstance() {
        Cipher cipher = this.getCipherInstance();
        if (!this.initialized) {
            cipher.init(this.mode == Cipher$Mode.Encrypt ? 1 : 2, (Key)this.secretKey, this.parameters);
            this.initialized = true;
        }
        return cipher;
    }

    @Override
    public void updateAAD(byte[] byArray, int n2, int n3) {
        this.getInitializedCipherInstance().updateAAD(byArray, n2, n3);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        if (this.mode == Cipher$Mode.Decrypt) {
            n3 += this.getAuthenticationTagSize();
        }
        Cipher cipher = this.getInitializedCipherInstance();
        cipher.doFinal(byArray, n2, n3, byArray, n2);
        this.parameters.incrementCounter();
        this.initialized = false;
    }
}

