/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import javax.crypto.spec.GCMParameterSpec;
import org.apache.sshd.common.util.buffer.BufferUtils;

public class BaseGCMCipher$CounterGCMParameterSpec
extends GCMParameterSpec {
    protected final byte[] iv;
    protected final long initialCounter;

    protected BaseGCMCipher$CounterGCMParameterSpec(int n2, byte[] byArray) {
        super(n2, byArray);
        if (byArray.length != 12) {
            throw new IllegalArgumentException("GCM nonce must be 12 bytes, but given len=" + byArray.length);
        }
        this.iv = (byte[])byArray.clone();
        this.initialCounter = BufferUtils.getLong(this.iv, this.iv.length - 8, 8);
    }

    protected void incrementCounter() {
        int n2 = this.iv.length - 8;
        long l2 = BufferUtils.getLong(this.iv, n2, 8);
        long l3 = l2 + 1L;
        if (l3 == this.initialCounter) {
            throw new IllegalStateException("GCM IV would be reused");
        }
        BufferUtils.putLong(l3, this.iv, n2, 8);
    }

    @Override
    public byte[] getIV() {
        return (byte[])this.iv.clone();
    }
}

