/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.sshd.common.cipher.BaseCipher$CipherFactory;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.cipher.Cipher$Mode;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public class BaseCipher
implements Cipher {
    static BaseCipher$CipherFactory factory = SecurityUtils::getCipher;
    static boolean alwaysReInit;
    protected Cipher$Mode mode;
    private javax.crypto.Cipher cipher;
    private final int ivsize;
    private final int authSize;
    private final int kdfSize;
    private final String algorithm;
    private final int keySize;
    private final int blkSize;
    private final String transformation;
    private String s;
    private SecretKey secretKey;

    public BaseCipher(int n2, int n3, int n4, String string, int n5, String string2, int n6) {
        this.ivsize = n2;
        this.authSize = n3;
        this.kdfSize = n4;
        this.algorithm = ValidateUtils.checkNotNullAndNotEmpty(string, "No algorithm");
        this.keySize = n5;
        this.transformation = ValidateUtils.checkNotNullAndNotEmpty(string2, "No transformation");
        this.blkSize = n6;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    public String getTransformation() {
        return this.transformation;
    }

    @Override
    public int getIVSize() {
        return this.ivsize;
    }

    @Override
    public int getAuthenticationTagSize() {
        return this.authSize;
    }

    @Override
    public int getKdfSize() {
        return this.kdfSize;
    }

    @Override
    public int getCipherBlockSize() {
        return this.blkSize;
    }

    @Override
    public void init(Cipher$Mode cipher$Mode, byte[] byArray, byte[] byArray2) {
        byArray = this.initializeKeyData(cipher$Mode, byArray, this.getKdfSize());
        byArray2 = this.initializeIVData(cipher$Mode, byArray2, this.getIVSize());
        this.cipher = this.createCipherInstance(cipher$Mode, byArray, byArray2);
    }

    protected javax.crypto.Cipher getCipherInstance() {
        return this.cipher;
    }

    protected javax.crypto.Cipher createCipherInstance(Cipher$Mode cipher$Mode, byte[] byArray, byte[] byArray2) {
        javax.crypto.Cipher cipher = factory.getCipher(this.getTransformation());
        this.mode = cipher$Mode;
        this.secretKey = new SecretKeySpec(byArray, this.getAlgorithm());
        cipher.init(Cipher$Mode.Encrypt.equals((Object)cipher$Mode) ? 1 : 2, (Key)this.secretKey, new IvParameterSpec(byArray2));
        return cipher;
    }

    protected byte[] initializeKeyData(Cipher$Mode cipher$Mode, byte[] byArray, int n2) {
        return BaseCipher.resize(byArray, n2);
    }

    protected byte[] initializeIVData(Cipher$Mode cipher$Mode, byte[] byArray, int n2) {
        return BaseCipher.resize(byArray, n2);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        try {
            int n4 = this.cipher.update(byArray, n2, n3, byArray, n2);
            if (n4 < n3 || alwaysReInit) {
                if ((n4 += this.cipher.doFinal(byArray, n2 + n4)) != n3) {
                    throw new GeneralSecurityException("Cipher.doFinal() did not return all bytes: " + n4 + " != " + n3);
                }
                this.reInit(byArray, n2, n3);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new GeneralSecurityException("BaseCipher.update() for " + this.getTransformation() + '/' + this.getKeySize() + " failed (" + (Object)((Object)this.mode) + ')', generalSecurityException);
        }
    }

    protected void reInit(byte[] byArray, int n2, int n3) {
        this.cipher.init(Cipher$Mode.Encrypt.equals((Object)this.mode) ? 1 : 2, (Key)this.secretKey, this.determineNewParameters(byArray, n2, n3));
    }

    protected AlgorithmParameterSpec determineNewParameters(byte[] byArray, int n2, int n3) {
        throw new UnsupportedOperationException(this.getClass() + " needs to override determineNewParameters()");
    }

    @Override
    public void updateAAD(byte[] byArray, int n2, int n3) {
        throw new UnsupportedOperationException(this.getClass() + " does not support AAD operations");
    }

    protected static byte[] resize(byte[] byArray, int n2) {
        if (byArray.length > n2) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        BaseCipher baseCipher = this;
        synchronized (baseCipher) {
            if (this.s == null) {
                this.s = this.getClass().getSimpleName() + "[" + this.getAlgorithm() + ", ivSize=" + this.getIVSize() + ", kdfSize=" + this.getKdfSize() + "," + this.getTransformation() + ", blkSize=" + this.getCipherBlockSize() + "]";
            }
        }
        return this.s;
    }
}

