/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.apache.sshd.common.cipher.BaseCipher;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class BaseCTRCipher
extends BaseCipher {
    private long blocksProcessed;

    public BaseCTRCipher(int n2, int n3, int n4, String string, int n5, String string2, int n6) {
        super(n2, n3, n4, string, n5, string2, n6);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        this.blocksProcessed += (long)(n3 / this.getCipherBlockSize());
        super.update(byArray, n2, n3);
    }

    @Override
    protected void reInit(byte[] byArray, int n2, int n3) {
        super.reInit(byArray, n2, n3);
        this.blocksProcessed = 0L;
    }

    @Override
    protected AlgorithmParameterSpec determineNewParameters(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = (byte[])this.getCipherInstance().getIV().clone();
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(byArray2, byArray2.length - 8, 8);
        long l2 = byteArrayBuffer.getLong();
        long l3 = l2 & Long.MIN_VALUE;
        l2 &= Long.MAX_VALUE;
        long l4 = (l2 += this.blocksProcessed) & Long.MIN_VALUE;
        l2 = l2 & Long.MAX_VALUE | l3 ^ l4;
        int n4 = (int)((l3 & l4) >>> 63);
        this.addCarry(byArray2, byArray2.length - 8, n4);
        byteArrayBuffer.wpos(byArray2.length - 8);
        byteArrayBuffer.putLong(l2);
        return new IvParameterSpec(byArray2);
    }

    private void addCarry(byte[] byArray, int n2, int n3) {
        int n4 = n3;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n5 = (byArray[i2] & 0xFF) + n4;
            byArray[i2] = (byte)n5;
            n4 = n5 >> 8;
        }
    }
}

