/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelHolder;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.core.CoreModuleProperties;

public abstract class Window
extends AbstractLoggingBean
implements Closeable,
ChannelHolder {
    protected final Object lock = new Object();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Channel channelInstance;
    private final String suffix;
    private long size;
    private long maxSize;
    private long packetSize;

    protected Window(Channel channel, boolean bl2) {
        this.channelInstance = Objects.requireNonNull(channel, "No channel provided");
        this.suffix = bl2 ? "client" : "server";
    }

    protected static Predicate largerThan(long l2) {
        return window -> window.size > l2;
    }

    @Override
    public Channel getChannel() {
        return this.channelInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.size;
        }
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public long getPacketSize() {
        return this.packetSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(long l2, long l3, PropertyResolver propertyResolver) {
        BufferUtils.validateUint32Value(l2, "Illegal initial size: %d");
        BufferUtils.validateUint32Value(l3, "Illegal packet size: %d");
        ValidateUtils.checkTrue(l3 > 0L, "Packet size must be positive: %d", l3);
        long l4 = (Long)CoreModuleProperties.LIMIT_PACKET_SIZE.getRequired(propertyResolver);
        if (l3 > l4) {
            throw new IllegalArgumentException("Requested packet size (" + l3 + ") exceeds max. allowed: " + l4);
        }
        Object object = this.lock;
        synchronized (object) {
            this.maxSize = l2;
            this.packetSize = l3;
            this.updateSize(l2);
        }
        boolean bl2 = this.log.isDebugEnabled();
        if (this.initialized.getAndSet(true) && bl2) {
            this.log.debug("init({}) re-initializing", (Object)this);
        }
        if (bl2) {
            this.log.debug("init({}) size={}, max={}, packet={}", new Object[]{this, this.getSize(), this.getMaxSize(), this.getPacketSize()});
        }
    }

    public abstract void consume(long var1);

    protected void updateSize(long l2) {
        BufferUtils.validateUint32Value(l2, "Invalid updated size: %d", (Object)l2);
        this.size = l2;
        this.lock.notifyAll();
    }

    protected void checkInitialized(String string) {
        if (!this.initialized.get()) {
            throw new IllegalStateException(string + " - window not initialized: " + this);
        }
    }

    public boolean isOpen() {
        return !this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed.getAndSet(true) && this.log.isDebugEnabled()) {
            this.log.debug("Closing {}", (Object)this);
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.suffix + "](" + this.getChannel() + ")";
    }
}

