/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.EnumMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.channel.PtyMode;

public final class SttySupport {
    public static final int DEFAULT_TERMINAL_WIDTH = 80;
    public static final int DEFAULT_TERMINAL_HEIGHT = 24;
    public static final String SSHD_STTY_COMMAND_PROP = "sshd.sttyCommand";
    public static final String DEFAULT_SSHD_STTY_COMMAND = "stty";
    private static final AtomicReference STTY_COMMAND_HOLDER = new AtomicReference<String>(System.getProperty("sshd.sttyCommand", "stty"));
    private static final AtomicReference TTY_PROPS_HOLDER = new AtomicReference<Object>(null);
    private static final AtomicLong TTY_PROPS_LAST_FETCHED_HOLDER = new AtomicLong(0L);

    private SttySupport() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static Map getUnixPtyModes() {
        return SttySupport.parsePtyModes(SttySupport.getTtyProps());
    }

    public static Map parsePtyModes(String string) {
        EnumMap<PtyMode, Integer> enumMap = new EnumMap<PtyMode, Integer>(PtyMode.class);
        for (PtyMode ptyMode : PtyMode.MODES) {
            int n2;
            if (ptyMode == PtyMode.TTY_OP_ISPEED || ptyMode == PtyMode.TTY_OP_OSPEED) continue;
            String string2 = ptyMode.name().toLowerCase();
            if (string2.charAt(0) == 'v') {
                n2 = SttySupport.findChar(string, string2 = string2.substring(1));
                if (n2 < 0 && "reprint".equals(string2)) {
                    n2 = SttySupport.findChar(string, "rprnt");
                }
                if (n2 < 0) continue;
                enumMap.put(ptyMode, n2);
                continue;
            }
            n2 = SttySupport.findFlag(string, string2);
            if (n2 < 0) continue;
            enumMap.put(ptyMode, n2);
        }
        return enumMap;
    }

    private static int findFlag(String string, String string2) {
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.indexOf(string2, n2);
            int n4 = n3 + string2.length();
            if (n3 < 0) {
                return -1;
            }
            if (n3 > 0 && Character.isLetterOrDigit(string.charAt(n3 - 1)) || n4 < string.length() && Character.isLetterOrDigit(string.charAt(n4))) {
                n2 = n4;
                continue;
            }
            return n3 == 0 ? 1 : (string.charAt(n3 - 1) == '-' ? 0 : 1);
        }
        return -1;
    }

    private static int findChar(String string, String string2) {
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.indexOf(string2, n2);
            int n4 = string.indexOf(61, n3);
            int n5 = string.indexOf(59, n3);
            if (n3 < 0 || n4 < 0 || n5 < n4) {
                return -1;
            }
            if (n3 > 0 && Character.isLetterOrDigit(string.charAt(n3 - 1)) || n4 < string.length() && Character.isLetterOrDigit(string.charAt(n4))) {
                n2 = n3 + string2.length();
                continue;
            }
            String string3 = string.substring(n4 + 1, n5 < 0 ? string.length() : n5).trim();
            if (string3.contains("undef")) {
                return -1;
            }
            if (string3.length() == 2 && string3.charAt(0) == '^') {
                int n6 = (string3.charAt(1) - 65 + 129) % 128;
                return n6;
            }
            try {
                return Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }

    public static int getTerminalWidth() {
        try {
            int n2 = SttySupport.getTerminalProperty("columns");
            if (n2 == -1) {
                n2 = 80;
            }
            return n2;
        }
        catch (Exception exception) {
            return 80;
        }
    }

    public static int getTerminalHeight() {
        try {
            int n2 = SttySupport.getTerminalProperty("rows");
            if (n2 == -1) {
                n2 = 24;
            }
            return n2;
        }
        catch (Exception exception) {
            return 24;
        }
    }

    public static int getTerminalProperty(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(SttySupport.getTtyProps(), ";\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.startsWith(string)) {
                int n2 = string2.lastIndexOf(32);
                return Integer.parseInt(string2.substring(n2).trim());
            }
            if (!string2.endsWith(string)) continue;
            int n3 = string2.indexOf(32);
            return Integer.parseInt(string2.substring(0, n3).trim());
        }
        return -1;
    }

    public static String getTtyProps() {
        long l2 = System.currentTimeMillis();
        long l3 = TTY_PROPS_LAST_FETCHED_HOLDER.get();
        if (TTY_PROPS_HOLDER.get() == null || l2 - l3 > 1000L) {
            TTY_PROPS_HOLDER.set(SttySupport.stty("-a"));
            TTY_PROPS_LAST_FETCHED_HOLDER.set(System.currentTimeMillis());
        }
        return (String)TTY_PROPS_HOLDER.get();
    }

    public static String stty(String string) {
        return SttySupport.exec("stty " + string + " < /dev/tty").trim();
    }

    public static String exec(String string) {
        return SttySupport.exec("sh", "-c", string);
    }

    private static String exec(String ... stringArray) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            String string;
            Process process = Runtime.getRuntime().exec(stringArray);
            SttySupport.copyStream(process.getInputStream(), byteArrayOutputStream);
            SttySupport.copyStream(process.getErrorStream(), byteArrayOutputStream);
            process.waitFor();
            String string2 = string = new String(byteArrayOutputStream.toByteArray(), Charset.defaultCharset());
            return string2;
        }
    }

    private static int copyStream(InputStream inputStream, OutputStream outputStream) {
        int n2 = 0;
        int n3;
        while ((n3 = inputStream.read()) != -1) {
            outputStream.write(n3);
            ++n2;
        }
        return n2;
    }

    public static String getSttyCommand() {
        return (String)STTY_COMMAND_HOLDER.get();
    }

    public static void setSttyCommand(String string) {
        STTY_COMMAND_HOLDER.set(string);
    }
}

