/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.Closeable;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.SimpleIoOutputStream$DefaultIoWriteFuture;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.io.IoUtils;

public class SimpleIoOutputStream
extends AbstractCloseable
implements IoOutputStream {
    protected final ChannelOutputStream os;

    public SimpleIoOutputStream(ChannelOutputStream channelOutputStream) {
        this.os = channelOutputStream;
    }

    @Override
    protected void doCloseImmediately() {
        IoUtils.closeQuietly((Closeable)this.os);
        super.doCloseImmediately();
    }

    @Override
    public IoWriteFuture writeBuffer(Buffer buffer) {
        this.os.write(buffer.array(), buffer.rpos(), buffer.available());
        this.os.flush();
        SimpleIoOutputStream$DefaultIoWriteFuture simpleIoOutputStream$DefaultIoWriteFuture = new SimpleIoOutputStream$DefaultIoWriteFuture(this, null);
        simpleIoOutputStream$DefaultIoWriteFuture.setValue(true);
        return simpleIoOutputStream$DefaultIoWriteFuture;
    }
}

