/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.net.SocketTimeoutException;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.channel.WindowClosedException;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public class RemoteWindow
extends Window {
    private static final Predicate SPACE_AVAILABLE_PREDICATE = Window.largerThan(0L);

    public RemoteWindow(Channel channel, boolean bl2) {
        super(channel, bl2);
    }

    @Override
    public void init(long l2, long l3, PropertyResolver propertyResolver) {
        super.init(l2, l3, propertyResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(long l2) {
        long l3;
        BufferUtils.validateUint32Value(l2, "Invalid consumption length: %d");
        this.checkInitialized("consume");
        Object object = this.lock;
        synchronized (object) {
            l3 = this.getSize() - l2;
            if (l3 >= 0L) {
                this.updateSize(l3);
            }
        }
        if (l3 < 0L) {
            throw new IllegalStateException("consume(" + this + ") required length (" + l2 + ") above available: " + (l3 + l2));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Consume {} by {} down to {}", new Object[]{this, l2, l3});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(long l2) {
        long l3;
        long l4;
        BufferUtils.validateUint32Value(l2, "Invalid window expansion size: %d");
        this.checkInitialized("expand");
        Object object = this.lock;
        synchronized (object) {
            l4 = this.getSize();
            l3 = Math.min(l4 + l2, 0xFFFFFFFFL);
            this.updateSize(l3);
        }
        if (l3 - l4 != l2) {
            this.log.warn("expand({}) window increase from {} by {} too large, set to {}", new Object[]{this, l4, l2, l3});
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("expand({}) increase window from {} by {} up to {}", new Object[]{this, l4, l2, l3});
        }
    }

    public void waitAndConsume(long l2, long l3) {
        this.waitAndConsume(l2, Duration.ofMillis(l3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAndConsume(long l2, Duration duration) {
        BufferUtils.validateUint32Value(l2, "Invalid wait consume length: %d", (Object)l2);
        this.checkInitialized("waitAndConsume");
        if (l2 == 0L) {
            return;
        }
        boolean bl2 = this.log.isDebugEnabled();
        Object object = this.lock;
        synchronized (object) {
            this.waitForCondition(RemoteWindow.largerThan(l2 - 1L), duration);
            if (bl2) {
                this.log.debug("waitAndConsume({}) - requested={}, available={}", new Object[]{this, l2, this.getSize()});
            }
            this.consume(l2);
        }
    }

    public long waitForSpace(long l2) {
        return this.waitForSpace(Duration.ofMillis(l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long waitForSpace(Duration duration) {
        long l2;
        this.checkInitialized("waitForSpace");
        Object object = this.lock;
        synchronized (object) {
            this.waitForCondition(SPACE_AVAILABLE_PREDICATE, duration);
            l2 = this.getSize();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("waitForSpace({}) available: {}", (Object)this, (Object)l2);
        }
        return l2;
    }

    protected void waitForCondition(Predicate predicate, Duration duration) {
        Objects.requireNonNull(predicate, "No condition");
        ValidateUtils.checkTrue(GenericUtils.isPositive(duration), "Non-positive max. wait time: %s", (Object)duration.toString());
        Instant instant = Instant.now();
        Instant instant2 = instant.plus(duration);
        while (this.isOpen() && instant.compareTo(instant2) < 0) {
            if (predicate.test(this)) {
                return;
            }
            Duration duration2 = Duration.between(instant, instant2);
            this.lock.wait(duration2.toMillis(), duration2.getNano() % 1000000);
            instant = Instant.now();
        }
        if (!this.isOpen()) {
            throw new WindowClosedException(this.toString());
        }
        throw new SocketTimeoutException("waitForCondition(" + this + ") timeout exceeded: " + duration);
    }
}

