/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;

public enum PtyMode {
    VINTR(1),
    VQUIT(2),
    VERASE(3),
    VKILL(4),
    VEOF(5),
    VEOL(6),
    VEOL2(7),
    VSTART(8),
    VSTOP(9),
    VSUSP(10),
    VDSUSP(11),
    VREPRINT(12),
    VWERASE(13),
    VLNEXT(14),
    VFLUSH(15),
    VSWTCH(16),
    VSTATUS(17),
    VDISCARD(18),
    IGNPAR(30),
    PARMRK(31),
    INPCK(32),
    ISTRIP(33),
    INLCR(34),
    IGNCR(35),
    ICRNL(36),
    IUCLC(37),
    IXON(38),
    IXANY(39),
    IXOFF(40),
    IMAXBEL(41),
    IUTF8(42),
    ISIG(50),
    ICANON(51),
    XCASE(52),
    ECHO(53),
    ECHOE(54),
    ECHOK(55),
    ECHONL(56),
    NOFLSH(57),
    TOSTOP(58),
    IEXTEN(59),
    ECHOCTL(60),
    ECHOKE(61),
    PENDIN(62),
    OPOST(70),
    OLCUC(71),
    ONLCR(72),
    OCRNL(73),
    ONOCR(74),
    ONLRET(75),
    CS7(90),
    CS8(91),
    PARENB(92),
    PARODD(93),
    TTY_OP_ISPEED(128),
    TTY_OP_OSPEED(129);

    public static final byte TTY_OP_END = 0;
    public static final Integer FALSE_SETTING;
    public static final Integer TRUE_SETTING;
    public static final Set MODES;
    public static final NavigableMap COMMANDS;
    public static final ToIntFunction OPCODE_EXTRACTOR;
    public static final Comparator BY_OPCODE;
    private final int v;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private PtyMode() {
        void var3_2;
        this.v = var3_2;
    }

    public int toInt() {
        return this.v;
    }

    public static PtyMode fromInt(int n2) {
        return (PtyMode)((Object)COMMANDS.get(0xFF & n2));
    }

    public static PtyMode fromName(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        for (PtyMode ptyMode : MODES) {
            if (!string.equalsIgnoreCase(ptyMode.name())) continue;
            return ptyMode;
        }
        return null;
    }

    public static Map createEnabledOptions(PtyMode ... ptyModeArray) {
        return PtyMode.createEnabledOptions(GenericUtils.of(ptyModeArray));
    }

    public static Map createEnabledOptions(Collection collection) {
        if (GenericUtils.isEmpty(collection)) {
            return Collections.emptyMap();
        }
        EnumMap<PtyMode, Integer> enumMap = new EnumMap<PtyMode, Integer>(PtyMode.class);
        for (PtyMode ptyMode : collection) {
            enumMap.put(ptyMode, TRUE_SETTING);
        }
        return enumMap;
    }

    public static Set resolveEnabledOptions(Map map, PtyMode ... ptyModeArray) {
        return PtyMode.resolveEnabledOptions(map, GenericUtils.of(ptyModeArray));
    }

    public static Set resolveEnabledOptions(Map map, Collection collection) {
        if (MapEntryUtils.isEmpty(map) || GenericUtils.isEmpty(collection)) {
            return Collections.emptySet();
        }
        EnumSet<PtyMode> enumSet = EnumSet.noneOf(PtyMode.class);
        for (PtyMode ptyMode : collection) {
            if (!PtyMode.getBooleanSettingValue(map, ptyMode)) continue;
            enumSet.add(ptyMode);
        }
        return enumSet;
    }

    public static boolean getBooleanSettingValue(Map map, PtyMode ptyMode) {
        if (ptyMode == null || MapEntryUtils.isEmpty(map)) {
            return false;
        }
        return PtyMode.getBooleanSettingValue(map.get((Object)ptyMode));
    }

    public static boolean getBooleanSettingValue(Map map, Collection collection, boolean bl2) {
        if (MapEntryUtils.isEmpty(map) || GenericUtils.isEmpty(collection)) {
            return bl2;
        }
        int n2 = 0;
        for (PtyMode ptyMode : collection) {
            Object v2 = map.get((Object)ptyMode);
            if (v2 == null) continue;
            ++n2;
            if (!PtyMode.getBooleanSettingValue(v2)) continue;
            return true;
        }
        if (n2 > 0) {
            return false;
        }
        return bl2;
    }

    public static boolean getBooleanSettingValue(Object object) {
        return object instanceof Number && PtyMode.getBooleanSettingValue(((Number)object).intValue());
    }

    public static boolean getBooleanSettingValue(int n2) {
        return n2 != 0;
    }

    public static boolean isCharSetting(PtyMode ptyMode) {
        if (ptyMode == null) {
            return false;
        }
        String string = ptyMode.name();
        char c2 = string.charAt(0);
        return c2 == 'v' || c2 == 'V';
    }

    static {
        FALSE_SETTING = 0;
        TRUE_SETTING = 1;
        MODES = Collections.unmodifiableSet(EnumSet.allOf(PtyMode.class));
        COMMANDS = Collections.unmodifiableNavigableMap(MapEntryUtils.toSortedMap(MODES, PtyMode::toInt, Function.identity(), Comparator.naturalOrder()));
        OPCODE_EXTRACTOR = ptyMode -> ptyMode == null ? -1 : ptyMode.toInt();
        BY_OPCODE = (ptyMode, ptyMode2) -> {
            int n2 = OPCODE_EXTRACTOR.applyAsInt(ptyMode);
            int n3 = OPCODE_EXTRACTOR.applyAsInt(ptyMode2);
            return Integer.compare(n2, n3);
        };
    }
}

