/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.StreamCorruptedException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.core.CoreModuleProperties;

public class LocalWindow
extends Window {
    private final AbstractChannel channel;
    private final AtomicLong adjustment = new AtomicLong();
    private long released;

    public LocalWindow(AbstractChannel abstractChannel, boolean bl2) {
        super(abstractChannel, bl2);
        this.channel = abstractChannel;
    }

    @Override
    public AbstractChannel getChannel() {
        return this.channel;
    }

    public void init(PropertyResolver propertyResolver) {
        this.init((Long)CoreModuleProperties.WINDOW_SIZE.getRequired(propertyResolver), (Long)CoreModuleProperties.MAX_PACKET_SIZE.getRequired(propertyResolver), propertyResolver);
        this.released = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(long l2) {
        long l3;
        BufferUtils.validateUint32Value(l2, "Invalid consumption length: %d");
        this.checkInitialized("consume");
        Object object = this.lock;
        synchronized (object) {
            l3 = this.getSize() - l2;
            if (l3 >= 0L) {
                this.updateSize(l3);
            }
        }
        if (l3 < 0L) {
            throw new StreamCorruptedException("consume(" + this + ") required length (" + l2 + ") above available: " + (l3 + l2));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Consume {} by {} down to {}", new Object[]{this, l2, l3});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(long l2) {
        long l3;
        this.checkInitialized("check");
        if (l2 < 0L) {
            throw new IllegalArgumentException("LocalWindow: number of released bytes must be positive, was " + l2);
        }
        long l4 = this.getMaxSize();
        long l5 = this.getPacketSize();
        boolean bl2 = false;
        Object object = this.lock;
        synchronized (object) {
            long l6;
            long l7;
            this.released += l2;
            if (!(this.released <= l5 / 2L && this.released <= l4 / 10L && this.released <= 16384L || (l7 = this.getSize()) >= l4 / 2L && l4 - l7 <= 3L * l5 || (l6 = Math.min(l7 + this.released, l4)) <= l7)) {
                long l8 = this.adjustment.addAndGet(l6 - l7);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Increase {}: released now {}, total {}, adjustment {}, new size {}", new Object[]{this, l2, this.released, l8, l6});
                }
                this.released = 0L;
                bl2 = true;
                this.updateSize(l6);
            }
        }
        if (bl2 && (l3 = this.adjustment.getAndSet(0L)) > 0L) {
            this.getChannel().sendWindowAdjust(l3);
        }
    }
}

