/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.ChannelPipedSink;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.core.CoreModuleProperties;

public class ChannelPipedInputStream
extends InputStream
implements ChannelPipedSink {
    private final LocalWindow localWindow;
    private final byte[] b = new byte[1];
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final Lock lock = new ReentrantLock();
    private final Condition dataAvailable = this.lock.newCondition();
    private final AtomicBoolean writerClosed = new AtomicBoolean(false);
    private Buffer buffer = new ByteArrayBuffer();
    private long timeout;

    public ChannelPipedInputStream(PropertyResolver propertyResolver, LocalWindow localWindow) {
        this(localWindow, (Duration)CoreModuleProperties.WINDOW_TIMEOUT.getRequired(propertyResolver));
    }

    public ChannelPipedInputStream(LocalWindow localWindow, Duration duration) {
        this(localWindow, Objects.requireNonNull(duration, "No window timeout provided").toMillis());
    }

    public ChannelPipedInputStream(LocalWindow localWindow, long l2) {
        this.localWindow = Objects.requireNonNull(localWindow, "No local window provided");
        this.timeout = l2;
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    public void setTimeout(long l2) {
        this.timeout = l2;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public int available() {
        this.lock.lock();
        try {
            if (!this.isOpen()) {
                int n2 = 0;
                return n2;
            }
            int n3 = this.buffer.available();
            if (n3 == 0 && this.writerClosed.get()) {
                int n4 = -1;
                return n4;
            }
            int n5 = n3;
            return n5;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() {
        byte[] byArray = this.b;
        synchronized (this.b) {
            int n2 = this.read(this.b, 0, 1);
            if (n2 == -1) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return -1;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.b[0] & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return 0;
        }
        long l2 = System.currentTimeMillis();
        this.lock.lock();
        try {
            int n4 = 0;
            while (true) {
                if (!this.isOpen()) {
                    throw new IOException("Closed");
                }
                if (this.buffer.available() > 0) break;
                if (this.writerClosed.get()) {
                    int n5 = -1;
                    return n5;
                }
                try {
                    if (this.timeout > 0L) {
                        long l3 = this.timeout - (System.currentTimeMillis() - l2);
                        if (l3 <= 0L) {
                            throw new SocketException("Timeout (" + this.timeout + ") exceeded after " + n4 + " cycles");
                        }
                        this.dataAvailable.await(l3, TimeUnit.MILLISECONDS);
                    } else {
                        this.dataAvailable.await();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw (IOException)new InterruptedIOException("Interrupted at cycle #" + n4 + " while waiting for data to become available").initCause(interruptedException);
                }
                ++n4;
            }
            if (n3 > this.buffer.available()) {
                n3 = this.buffer.available();
            }
            this.buffer.getRawBytes(byArray, n2, n3);
            if ((long)this.buffer.rpos() > this.localWindow.getPacketSize() || this.buffer.available() == 0) {
                this.buffer.compact();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.localWindow.isOpen()) {
            this.localWindow.release(n3);
        }
        return n3;
    }

    @Override
    public void eof() {
        this.lock.lock();
        try {
            this.writerClosed.set(true);
            this.dataAvailable.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            this.open.set(false);
            this.buffer = null;
            this.dataAvailable.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(byte[] byArray, int n2, int n3) {
        this.lock.lock();
        try {
            if (this.writerClosed.get() || !this.isOpen()) {
                throw new IOException("Pipe closed");
            }
            this.buffer.putRawBytes(byArray, n2, n3);
            this.dataAvailable.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

