/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelHolder;
import org.apache.sshd.common.channel.ChannelOutputStream$OpenState;
import org.apache.sshd.common.channel.ChannelOutputStream$WriteState;
import org.apache.sshd.common.channel.RemoteWindow;
import org.apache.sshd.common.channel.WindowClosedException;
import org.apache.sshd.common.channel.exception.SshChannelClosedException;
import org.apache.sshd.common.channel.throttle.ChannelStreamWriter;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.slf4j.Logger;

public class ChannelOutputStream
extends OutputStream
implements java.nio.channels.Channel,
ChannelHolder {
    protected final AtomicReference openState = new AtomicReference<ChannelOutputStream$OpenState>(ChannelOutputStream$OpenState.OPEN);
    protected final Logger log;
    private final AbstractChannel channelInstance;
    private final ChannelStreamWriter packetWriter;
    private final RemoteWindow remoteWindow;
    private final Duration maxWaitTimeout;
    private final byte cmd;
    private final boolean eofOnClose;
    private final AtomicBoolean noDelay = new AtomicBoolean();
    private final Object bufferLock = new Object();
    private Buffer buffer;
    private int bufferLength;
    private int lastSize;
    private boolean isFlushing;

    public ChannelOutputStream(AbstractChannel abstractChannel, RemoteWindow remoteWindow, Logger logger, byte by, boolean bl2) {
        this(abstractChannel, remoteWindow, (Duration)CoreModuleProperties.WAIT_FOR_SPACE_TIMEOUT.getRequired(abstractChannel), logger, by, bl2);
    }

    public ChannelOutputStream(AbstractChannel abstractChannel, RemoteWindow remoteWindow, long l2, Logger logger, byte by, boolean bl2) {
        this(abstractChannel, remoteWindow, Duration.ofMillis(l2), logger, by, bl2);
    }

    public ChannelOutputStream(AbstractChannel abstractChannel, RemoteWindow remoteWindow, Duration duration, Logger logger, byte by, boolean bl2) {
        this.channelInstance = Objects.requireNonNull(abstractChannel, "No channel");
        this.packetWriter = this.channelInstance.resolveChannelStreamWriter(abstractChannel, by);
        this.remoteWindow = Objects.requireNonNull(remoteWindow, "No remote window");
        Objects.requireNonNull(duration, "No maxWaitTimeout");
        ValidateUtils.checkTrue(GenericUtils.isPositive(duration), "Non-positive max. wait time: %s", (Object)duration);
        this.maxWaitTimeout = duration;
        this.log = Objects.requireNonNull(logger, "No logger");
        this.cmd = by;
        this.eofOnClose = bl2;
        this.buffer = this.newBuffer(0);
    }

    @Override
    public AbstractChannel getChannel() {
        return this.channelInstance;
    }

    public byte getCommandType() {
        return this.cmd;
    }

    public boolean isEofOnClose() {
        return this.eofOnClose;
    }

    public boolean isNoDelay() {
        return this.noDelay.get();
    }

    public void setNoDelay(boolean bl2) {
        this.noDelay.set(bl2);
    }

    @Override
    public boolean isOpen() {
        return ChannelOutputStream$OpenState.OPEN == this.openState.get();
    }

    @Override
    public void write(int n2) {
        this.write(new byte[]{(byte)n2}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(byte[] byArray, int n2, int n3) {
        AbstractChannel abstractChannel = this.getChannel();
        if (!this.isOpen()) {
            throw new SshChannelClosedException(abstractChannel.getChannelId(), "write(" + this + ") len=" + n3 + " - channel already closed");
        }
        Session session = abstractChannel.getSession();
        boolean bl2 = this.log.isDebugEnabled();
        boolean bl3 = this.log.isTraceEnabled();
        boolean bl4 = false;
        int n4 = this.maxWaitTimeout.getNano();
        long l2 = TimeUnit.NANOSECONDS.toMillis(n4);
        long l3 = TimeUnit.SECONDS.toMillis(this.maxWaitTimeout.getSeconds()) + l2;
        n4 = (int)((long)n4 - TimeUnit.MILLISECONDS.toNanos(l2));
        block12: while (n3 > 0) {
            bl4 = false;
            ChannelOutputStream$WriteState channelOutputStream$WriteState = ChannelOutputStream$WriteState.BUFFERED;
            Object object = this.bufferLock;
            synchronized (object) {
                while (this.isFlushing) {
                    try {
                        this.bufferLock.wait(l3, n4);
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptedIOException interruptedIOException = new InterruptedIOException(abstractChannel.getChannelId() + ": write interrupted waiting for flush()");
                        interruptedIOException.initCause(interruptedException);
                        Thread.currentThread().interrupt();
                        throw interruptedIOException;
                    }
                }
                while (n3 > 0) {
                    long l4 = Math.min(this.remoteWindow.getSize() + (long)this.lastSize, this.remoteWindow.getPacketSize());
                    long l5 = Math.min((long)n3, l4 - (long)this.bufferLength);
                    if (l5 <= 0L) {
                        channelOutputStream$WriteState = this.bufferLength > 0 ? ChannelOutputStream$WriteState.NEED_FLUSH : ChannelOutputStream$WriteState.NEED_SPACE;
                        session.resetIdleTimeout();
                        break;
                    }
                    ValidateUtils.checkTrue(l5 <= Integer.MAX_VALUE, "Accumulated bytes length exceeds int boundary: %d", l5);
                    this.buffer.putRawBytes(byArray, n2, (int)l5);
                    this.bufferLength = (int)((long)this.bufferLength + l5);
                    n2 = (int)((long)n2 + l5);
                    n3 = (int)((long)n3 - l5);
                }
            }
            switch (channelOutputStream$WriteState) {
                case NEED_FLUSH: {
                    this.flush();
                    bl4 = true;
                    session.resetIdleTimeout();
                    continue block12;
                }
                case NEED_SPACE: {
                    try {
                        long l6 = this.remoteWindow.waitForSpace(this.maxWaitTimeout);
                        if (bl3) {
                            this.log.trace("write({}) len={} - available={}", new Object[]{this, n3, l6});
                        }
                    }
                    catch (IOException iOException) {
                        LoggingUtils.debug(this.log, "write({}) failed ({}) to wait for space of len={}: {}", this, iOException.getClass().getSimpleName(), n3, iOException.getMessage(), iOException);
                        if (iOException instanceof WindowClosedException && ChannelOutputStream$OpenState.OPEN == this.openState.getAndSet(ChannelOutputStream$OpenState.CLOSED) && bl2) {
                            this.log.debug("write({})[len={}] closing due to window closed", (Object)this, (Object)n3);
                        }
                        throw iOException;
                    }
                    catch (InterruptedException interruptedException) {
                        throw (IOException)new InterruptedIOException("Interrupted while waiting for remote space on write len=" + n3 + " to " + this).initCause(interruptedException);
                    }
                    session.resetIdleTimeout();
                    continue block12;
                }
            }
        }
        if (this.isNoDelay() && !bl4) {
            this.flush();
        } else {
            session.resetIdleTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Buffer buffer;
        int n2;
        AbstractChannel abstractChannel = this.getChannel();
        if (ChannelOutputStream$OpenState.CLOSED.equals(this.openState.get())) {
            throw new SshChannelClosedException(abstractChannel.getChannelId(), "flush(" + this + ") length=" + this.bufferLength + " - stream is already closed");
        }
        Session session = abstractChannel.getSession();
        boolean bl2 = this.log.isTraceEnabled();
        Object object = this.bufferLock;
        synchronized (object) {
            n2 = this.bufferLength;
            if (this.isFlushing) {
                return;
            }
            if (n2 == 0) {
                this.bufferLock.notifyAll();
                return;
            }
            this.isFlushing = true;
            buffer = this.buffer;
        }
        try {
            while (n2 > 0) {
                Buffer buffer2;
                long l2;
                session.resetIdleTimeout();
                long l3 = n2;
                try {
                    l2 = this.remoteWindow.waitForSpace(this.maxWaitTimeout);
                    if (bl2) {
                        this.log.trace("flush({}) len={}, available={}", new Object[]{this, l3, l2});
                    }
                }
                catch (IOException iOException) {
                    LoggingUtils.debug(this.log, "flush({}) failed ({}) to wait for space of len={}: {}", this, iOException.getClass().getSimpleName(), l3, iOException.getMessage(), iOException);
                    throw iOException;
                }
                long l4 = Math.min(l2, l3);
                long l5 = Math.min(l4, this.remoteWindow.getPacketSize());
                if (l5 > Integer.MAX_VALUE) {
                    throw new StreamCorruptedException("Accumulated " + SshConstants.getCommandMessageName(this.cmd) + " command bytes size (" + l5 + ") exceeds int boundaries");
                }
                int n3 = buffer.wpos();
                buffer.wpos(this.cmd == 95 ? 14 : 10);
                buffer.putUInt(l5);
                buffer.wpos(buffer.wpos() + (int)l5);
                if (l3 == l5) {
                    buffer2 = this.newBuffer((int)l5);
                    n2 = 0;
                } else {
                    long l6 = l3 - l5;
                    buffer2 = this.newBuffer((int)Math.max(l6, l5));
                    buffer2.putRawBytes(buffer.array(), n3 - (int)l6, (int)l6);
                    n2 = (int)l6;
                }
                Object object2 = this.bufferLock;
                synchronized (object2) {
                    this.buffer = buffer2;
                    this.bufferLength = n2;
                    this.lastSize = (int)l5;
                }
                session.resetIdleTimeout();
                this.remoteWindow.waitAndConsume(l5, this.maxWaitTimeout);
                if (bl2) {
                    this.log.trace("flush({}) send {} len={}", new Object[]{abstractChannel, SshConstants.getCommandMessageName(this.cmd), l5});
                }
                this.packetWriter.writeData(buffer);
                buffer = buffer2;
            }
        }
        catch (WindowClosedException windowClosedException) {
            if (ChannelOutputStream$OpenState.OPEN == this.openState.getAndSet(ChannelOutputStream$OpenState.CLOSED) && this.log.isDebugEnabled()) {
                this.log.debug("flush({}) closing due to window closed", (Object)this);
            }
            throw windowClosedException;
        }
        catch (InterruptedException interruptedException) {
            throw (IOException)new InterruptedIOException("Interrupted while waiting for remote space flush len=" + this.bufferLength + " to " + this).initCause(interruptedException);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new SshException(exception);
        }
        finally {
            Object object3 = this.bufferLock;
            synchronized (object3) {
                this.isFlushing = false;
                this.bufferLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.openState.compareAndSet(ChannelOutputStream$OpenState.OPEN, ChannelOutputStream$OpenState.CLOSING)) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("close({}) closing", (Object)this);
        }
        try {
            this.flush();
            if (this.isEofOnClose()) {
                AbstractChannel abstractChannel = this.getChannel();
                abstractChannel.sendEof();
            }
        }
        finally {
            try {
                if (!(this.packetWriter instanceof Channel)) {
                    this.packetWriter.close();
                }
            }
            finally {
                this.openState.set(ChannelOutputStream$OpenState.CLOSED);
            }
        }
    }

    protected Buffer newBuffer(int n2) {
        AbstractChannel abstractChannel = this.getChannel();
        Session session = abstractChannel.getSession();
        Buffer buffer = session.createBuffer(this.cmd, n2 <= 0 ? 12 : 12 + n2);
        buffer.putUInt(abstractChannel.getRecipient());
        if (this.cmd == 95) {
            buffer.putUInt(1L);
        }
        buffer.putUInt(0L);
        return buffer;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getChannel() + "] " + SshConstants.getCommandMessageName(this.cmd & 0xFF);
    }
}

