/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.EOFException;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream$BufferedFuture;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream$WriteState;
import org.apache.sshd.common.channel.ChannelHolder;
import org.apache.sshd.common.channel.IoWriteFutureImpl;
import org.apache.sshd.common.channel.RemoteWindow;
import org.apache.sshd.common.channel.throttle.ChannelStreamWriter;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.io.WritePendingException;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.closeable.AbstractCloseable$State;

public class ChannelAsyncOutputStream
extends AbstractCloseable
implements ChannelHolder,
IoOutputStream {
    protected final AtomicReference lastWrite = new AtomicReference();
    protected final ChannelAsyncOutputStream$WriteState writeState = new ChannelAsyncOutputStream$WriteState();
    private final Channel channelInstance;
    private final ChannelStreamWriter packetWriter;
    private final byte cmd;
    private final Object packetWriteId;

    public ChannelAsyncOutputStream(Channel channel, byte by) {
        this.channelInstance = Objects.requireNonNull(channel, "No channel");
        this.packetWriter = this.channelInstance.resolveChannelStreamWriter(channel, by);
        this.cmd = by;
        this.packetWriteId = channel.toString() + "[" + SshConstants.getCommandMessageName(by) + "]";
    }

    @Override
    public Channel getChannel() {
        return this.channelInstance;
    }

    public byte getCommandType() {
        return this.cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoWriteFuture writeBuffer(Buffer buffer) {
        if (this.isClosing()) {
            throw new EOFException("Closing: " + this);
        }
        IoWriteFutureImpl ioWriteFutureImpl = new IoWriteFutureImpl(this.packetWriteId, buffer);
        ChannelAsyncOutputStream$WriteState channelAsyncOutputStream$WriteState = this.writeState;
        synchronized (channelAsyncOutputStream$WriteState) {
            if (!AbstractCloseable$State.Opened.equals((Object)this.writeState.openState)) {
                throw new EOFException("Closing: " + this);
            }
            if (this.writeState.writeInProgress) {
                throw new WritePendingException("A write operation is already pending; cannot write " + buffer.available() + " bytes");
            }
            this.writeState.toSend = this.writeState.totalLength = buffer.available();
            this.writeState.pendingWrite = ioWriteFutureImpl;
            this.writeState.writeInProgress = true;
        }
        this.lastWrite.set(ioWriteFutureImpl);
        ioWriteFutureImpl.addListener(ioWriteFuture -> this.lastWrite.compareAndSet(ioWriteFuture, null));
        this.doWriteIfPossible(false);
        return ioWriteFutureImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preClose() {
        ChannelAsyncOutputStream$WriteState channelAsyncOutputStream$WriteState = this.writeState;
        synchronized (channelAsyncOutputStream$WriteState) {
            this.writeState.openState = (AbstractCloseable$State)((Object)this.state.get());
        }
        super.preClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCloseImmediately() {
        ChannelAsyncOutputStream$WriteState channelAsyncOutputStream$WriteState = this.writeState;
        synchronized (channelAsyncOutputStream$WriteState) {
            this.writeState.openState = (AbstractCloseable$State)((Object)this.state.get());
        }
        try {
            if (!(this.packetWriter instanceof Channel)) {
                try {
                    this.packetWriter.close();
                }
                catch (IOException iOException) {
                    this.error("doCloseImmediately({}) Failed ({}) to close packet writer: {}", this, iOException.getClass().getSimpleName(), iOException.getMessage(), iOException);
                }
            }
            super.doCloseImmediately();
        }
        finally {
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        int n2;
        int n3;
        IoWriteFutureImpl ioWriteFutureImpl = null;
        ChannelAsyncOutputStream$WriteState channelAsyncOutputStream$WriteState = this.writeState;
        synchronized (channelAsyncOutputStream$WriteState) {
            this.writeState.openState = AbstractCloseable$State.Closed;
            ioWriteFutureImpl = this.writeState.pendingWrite;
            this.writeState.pendingWrite = null;
            this.writeState.writeInProgress = false;
            n3 = this.writeState.totalLength;
            n2 = this.writeState.toSend;
        }
        this.lastWrite.set(null);
        if (ioWriteFutureImpl != null) {
            this.terminateFuture(ioWriteFutureImpl);
        }
        if (n2 > 0) {
            this.log.warn("doCloseImmediately({}): still have {} bytes of {} on closing channel", new Object[]{this, n2, n3});
        }
    }

    protected void terminateFuture(IoWriteFutureImpl ioWriteFutureImpl) {
        if (!ioWriteFutureImpl.isDone()) {
            if (ioWriteFutureImpl.getBuffer().available() > 0) {
                ioWriteFutureImpl.setValue(new EOFException("Channel closing"));
            } else {
                ioWriteFutureImpl.setValue(Boolean.TRUE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CloseFuture doCloseGracefully() {
        IoWriteFutureImpl ioWriteFutureImpl;
        IoWriteFuture ioWriteFuture = (IoWriteFuture)this.lastWrite.get();
        ChannelAsyncOutputStream$WriteState channelAsyncOutputStream$WriteState = this.writeState;
        synchronized (channelAsyncOutputStream$WriteState) {
            ioWriteFutureImpl = this.writeState.pendingWrite;
        }
        if (ioWriteFuture == null) {
            return this.builder().build().close(false);
        }
        if (this.log.isDebugEnabled() && ioWriteFutureImpl instanceof ChannelAsyncOutputStream$BufferedFuture && ((ChannelAsyncOutputStream$BufferedFuture)ioWriteFutureImpl).waitOnWindow) {
            this.log.debug("doCloseGracefully({}): writing last data (waiting on window expansion)", (Object)this);
        }
        return this.builder().when((SshFuture)ioWriteFuture).build().close(false);
    }

    public void onWindowExpanded() {
        this.doWriteIfPossible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteIfPossible(boolean bl2) {
        AbstractCloseable$State abstractCloseable$State;
        Object object = null;
        Object object2 = this.writeState;
        synchronized (object2) {
            this.writeState.windowExpanded |= bl2;
            if (this.writeState.pendingWrite == null) {
                return;
            }
            abstractCloseable$State = this.writeState.openState;
            object = this.writeState.pendingWrite;
            this.writeState.pendingWrite = null;
            this.writeState.windowExpanded = false;
        }
        while (object != null) {
            if (this.abortWrite(abstractCloseable$State)) {
                this.terminateFuture((IoWriteFutureImpl)object);
                break;
            }
            object2 = this.writePacket((IoWriteFutureImpl)object, bl2);
            if (object2 == null) break;
            ChannelAsyncOutputStream$WriteState channelAsyncOutputStream$WriteState = this.writeState;
            synchronized (channelAsyncOutputStream$WriteState) {
                abstractCloseable$State = this.writeState.openState;
                if (this.writeState.windowExpanded) {
                    this.writeState.windowExpanded = false;
                    bl2 = true;
                    object = object2;
                } else {
                    if (!this.abortWrite(abstractCloseable$State)) {
                        this.writeState.pendingWrite = object2;
                    } else {
                        this.writeState.writeInProgress = false;
                    }
                    object = null;
                }
            }
            if (object != null || !this.abortWrite(abstractCloseable$State)) continue;
            this.terminateFuture((IoWriteFutureImpl)object2);
            break;
        }
    }

    private boolean abortWrite(AbstractCloseable$State abstractCloseable$State) {
        return AbstractCloseable$State.Immediate.equals((Object)abstractCloseable$State) || AbstractCloseable$State.Closed.equals((Object)abstractCloseable$State);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IoWriteFutureImpl writePacket(IoWriteFutureImpl ioWriteFutureImpl, boolean bl2) {
        Object object;
        Buffer buffer = ioWriteFutureImpl.getBuffer();
        int n2 = buffer.available();
        if (n2 <= 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("writePacket({}) current buffer sent", (Object)this);
            }
            ChannelAsyncOutputStream$WriteState channelAsyncOutputStream$WriteState = this.writeState;
            synchronized (channelAsyncOutputStream$WriteState) {
                this.writeState.writeInProgress = false;
            }
            ioWriteFutureImpl.setValue(Boolean.TRUE);
            return null;
        }
        Channel channel = this.getChannel();
        RemoteWindow remoteWindow = channel.getRemoteWindow();
        long l2 = remoteWindow.getSize();
        long l3 = remoteWindow.getPacketSize();
        int n3 = (int)Math.min((long)n2, Math.min(l3, l2));
        IoWriteFutureImpl ioWriteFutureImpl2 = ioWriteFutureImpl;
        if (n3 < n2 && !(ioWriteFutureImpl2 instanceof ChannelAsyncOutputStream$BufferedFuture)) {
            object = new ByteArrayBuffer(n2);
            ((Buffer)object).putBuffer(buffer, false);
            ioWriteFutureImpl2 = new ChannelAsyncOutputStream$BufferedFuture(ioWriteFutureImpl.getId(), (Buffer)object);
            ioWriteFutureImpl2.addListener(ioWriteFuture -> ioWriteFutureImpl.setValue(ioWriteFuture.getException() != null ? ioWriteFuture.getException() : Boolean.valueOf(ioWriteFuture.isWritten())));
        }
        if (n3 <= 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("writePacket({})[resume={}] waiting for window space {}", new Object[]{this, bl2, l2});
            }
            ((ChannelAsyncOutputStream$BufferedFuture)ioWriteFutureImpl2).waitOnWindow = true;
            return ioWriteFutureImpl2;
        }
        if (ioWriteFutureImpl2 instanceof ChannelAsyncOutputStream$BufferedFuture) {
            ((ChannelAsyncOutputStream$BufferedFuture)ioWriteFutureImpl2).waitOnWindow = false;
        }
        buffer = ioWriteFutureImpl2.getBuffer();
        if (this.log.isTraceEnabled()) {
            this.log.trace("writePacket({})[resume={}] attempting to write {} out of {}", new Object[]{this, bl2, n3, n2});
        }
        if (n3 >= 0x7FFFFFF3) {
            object = new IllegalArgumentException("Command " + SshConstants.getCommandMessageName(this.cmd) + " length (" + n3 + ") exceeds int boundaries");
            ChannelAsyncOutputStream$WriteState channelAsyncOutputStream$WriteState = this.writeState;
            synchronized (channelAsyncOutputStream$WriteState) {
                this.writeState.writeInProgress = false;
            }
            ioWriteFutureImpl2.setValue(object);
            throw object;
        }
        remoteWindow.consume(n3);
        try {
            object = this.packetWriter.writeData(this.createSendBuffer(buffer, channel, n3));
        }
        catch (Throwable throwable) {
            ChannelAsyncOutputStream$WriteState channelAsyncOutputStream$WriteState = this.writeState;
            synchronized (channelAsyncOutputStream$WriteState) {
                this.writeState.writeInProgress = false;
            }
            ioWriteFutureImpl2.setValue(throwable);
            return null;
        }
        IoWriteFutureImpl ioWriteFutureImpl3 = ioWriteFutureImpl2;
        object.addListener(ioWriteFuture -> this.onWritten(ioWriteFutureImpl3, n2, n3, (IoWriteFuture)ioWriteFuture));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onWritten(IoWriteFutureImpl ioWriteFutureImpl, int n2, int n3, IoWriteFuture ioWriteFuture) {
        if (ioWriteFuture.isWritten()) {
            if (n2 > n3) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("onWritten({}) completed write of {} out of {}", new Object[]{this, n3, n2});
                }
                ChannelAsyncOutputStream$WriteState channelAsyncOutputStream$WriteState = this.writeState;
                synchronized (channelAsyncOutputStream$WriteState) {
                    this.writeState.toSend -= n3;
                    this.writeState.pendingWrite = ioWriteFutureImpl;
                }
                this.doWriteIfPossible(false);
            } else {
                ChannelAsyncOutputStream$WriteState channelAsyncOutputStream$WriteState = this.writeState;
                synchronized (channelAsyncOutputStream$WriteState) {
                    this.writeState.toSend = 0;
                    this.writeState.pendingWrite = null;
                    this.writeState.writeInProgress = false;
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("onWritten({}) completed write len={}", (Object)this, (Object)n2);
                }
                ioWriteFutureImpl.setValue(Boolean.TRUE);
            }
        } else {
            Throwable throwable = ioWriteFuture.getException();
            this.debug("onWritten({}) failed ({}) to complete write of {} out of {}: {}", this, throwable.getClass().getSimpleName(), n3, n2, throwable.getMessage(), throwable);
            ChannelAsyncOutputStream$WriteState channelAsyncOutputStream$WriteState = this.writeState;
            synchronized (channelAsyncOutputStream$WriteState) {
                this.writeState.pendingWrite = null;
                this.writeState.writeInProgress = false;
            }
            ioWriteFutureImpl.setValue(throwable);
        }
    }

    protected Buffer createSendBuffer(Buffer buffer, Channel channel, int n2) {
        SessionContext.validateSessionPayloadSize(n2, "Invalid send buffer length: %d");
        Session session = channel.getSession();
        Buffer buffer2 = session.createBuffer(this.cmd, n2 + 12);
        buffer2.putUInt(channel.getRecipient());
        if (this.cmd == 95) {
            buffer2.putUInt(1L);
        }
        buffer2.putUInt(n2);
        buffer2.putRawBytes(buffer.array(), buffer.rpos(), n2);
        buffer.rpos(buffer.rpos() + n2);
        return buffer2;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getChannel() + "] cmd=" + SshConstants.getCommandMessageName(this.cmd & 0xFF);
    }
}

