/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.EOFException;
import java.io.IOException;
import java.util.Objects;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelAsyncInputStream$IoReadFutureImpl;
import org.apache.sshd.common.channel.ChannelHolder;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.io.IoInputStream;
import org.apache.sshd.common.io.IoReadFuture;
import org.apache.sshd.common.io.ReadPendingException;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;

public class ChannelAsyncInputStream
extends AbstractCloseable
implements ChannelHolder,
IoInputStream {
    private final Channel channelInstance;
    private final Buffer buffer = new ByteArrayBuffer();
    private final Object readFutureId;
    private ChannelAsyncInputStream$IoReadFutureImpl pending;

    public ChannelAsyncInputStream(Channel channel) {
        this.channelInstance = Objects.requireNonNull(channel, "No channel");
        this.readFutureId = this.toString();
    }

    @Override
    public Channel getChannel() {
        return this.channelInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Readable readable) {
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            this.buffer.putBuffer(readable);
        }
        this.doRead(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoReadFuture read(Buffer buffer) {
        ChannelAsyncInputStream$IoReadFutureImpl channelAsyncInputStream$IoReadFutureImpl = new ChannelAsyncInputStream$IoReadFutureImpl(this.readFutureId, buffer);
        if (this.isClosing()) {
            Buffer buffer2 = this.buffer;
            synchronized (buffer2) {
                if (this.pending != null) {
                    throw new ReadPendingException("Previous pending read not handled");
                }
                if (this.buffer.available() > 0) {
                    Buffer buffer3 = channelAsyncInputStream$IoReadFutureImpl.buffer;
                    int n2 = buffer3.putBuffer(this.buffer, false);
                    this.buffer.compact();
                    channelAsyncInputStream$IoReadFutureImpl.setValue(n2);
                } else {
                    channelAsyncInputStream$IoReadFutureImpl.setValue(new EOFException("Closed"));
                }
            }
        }
        Buffer buffer4 = this.buffer;
        synchronized (buffer4) {
            if (this.pending != null) {
                throw new ReadPendingException("Previous pending read not handled");
            }
            this.pending = channelAsyncInputStream$IoReadFutureImpl;
        }
        this.doRead(false);
        return channelAsyncInputStream$IoReadFutureImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preClose() {
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            if (this.buffer.available() == 0 && this.pending != null) {
                this.pending.setValue(new EOFException("Closed"));
            }
        }
        super.preClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CloseFuture doCloseGracefully() {
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            return this.builder().when((SshFuture)this.pending).build().close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRead(boolean bl2) {
        ChannelAsyncInputStream$IoReadFutureImpl channelAsyncInputStream$IoReadFutureImpl = null;
        int n2 = 0;
        boolean bl3 = this.log.isDebugEnabled();
        Object object = this.buffer;
        synchronized (object) {
            if (this.buffer.available() > 0) {
                if (bl2 && bl3) {
                    this.log.debug("Resuming read due to incoming data on {}", (Object)this);
                }
                channelAsyncInputStream$IoReadFutureImpl = this.pending;
                this.pending = null;
                if (channelAsyncInputStream$IoReadFutureImpl != null) {
                    n2 = channelAsyncInputStream$IoReadFutureImpl.buffer.putBuffer(this.buffer, false);
                    this.buffer.compact();
                }
            } else if (!bl2 && bl3) {
                this.log.debug("Delaying read until data is available on {}", (Object)this);
            }
        }
        if (n2 > 0) {
            object = this.getChannel();
            try {
                LocalWindow localWindow = object.getLocalWindow();
                localWindow.release(n2);
            }
            catch (IOException iOException) {
                Session session = object.getSession();
                session.exceptionCaught(iOException);
            }
            channelAsyncInputStream$IoReadFutureImpl.setValue(n2);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getChannel() + "]";
    }
}

