/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.EOFException;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.future.DefaultVerifiableSshFuture;
import org.apache.sshd.common.io.IoReadFuture;
import org.apache.sshd.common.util.buffer.Buffer;

public class ChannelAsyncInputStream$IoReadFutureImpl
extends DefaultVerifiableSshFuture
implements IoReadFuture {
    final Buffer buffer;

    public ChannelAsyncInputStream$IoReadFutureImpl(Object object, Buffer buffer) {
        super(object, null);
        this.buffer = buffer;
    }

    @Override
    public Buffer getBuffer() {
        return this.isDone() ? this.buffer : null;
    }

    @Override
    public IoReadFuture verify(long l2, CancelOption ... cancelOptionArray) {
        long l3 = System.nanoTime();
        Number number = (Number)this.verifyResult(Number.class, l2, cancelOptionArray);
        long l4 = System.nanoTime();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Read {} bytes after {} nanos", (Object)number, (Object)(l4 - l3));
        }
        return this;
    }

    @Override
    public int getRead() {
        Object object = this.getValue();
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof EOFException) {
            return -1;
        }
        if (object instanceof RuntimeException) {
            throw (RuntimeException)object;
        }
        if (object instanceof Error) {
            throw (Error)object;
        }
        if (object instanceof Throwable) {
            throw new RuntimeSshException("Error reading from channel.", (Throwable)object);
        }
        throw (IllegalStateException)this.formatExceptionMessage(IllegalStateException::new, "Unknown read value type: %s", object.getClass().getName());
    }

    @Override
    public Throwable getException() {
        Object object = this.getValue();
        if (object instanceof Throwable) {
            return (Throwable)object;
        }
        return null;
    }
}

