/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.AttributeRepository$AttributeKey;
import org.apache.sshd.common.AttributeStore;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.ChannelIdentifier;
import org.apache.sshd.common.channel.ChannelListenerManager;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.channel.RemoteWindow;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.channel.throttle.ChannelStreamWriterResolverManager;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public interface Channel
extends AttributeStore,
Closeable,
PropertyResolver,
ChannelIdentifier,
ChannelListenerManager,
ChannelStreamWriterResolverManager,
SessionHolder {
    public static final String CHANNEL_EXEC = "exec";
    public static final String CHANNEL_SHELL = "shell";
    public static final String CHANNEL_SUBSYSTEM = "subsystem";

    public long getRecipient();

    public LocalWindow getLocalWindow();

    public RemoteWindow getRemoteWindow();

    public List getRequestHandlers();

    public void addRequestHandler(RequestHandler var1);

    default public void addRequestHandlers(Collection collection) {
        GenericUtils.forEach(collection, this::addRequestHandler);
    }

    public void removeRequestHandler(RequestHandler var1);

    default public void removeRequestHandlers(Collection collection) {
        GenericUtils.forEach(collection, this::removeRequestHandler);
    }

    public void handleClose();

    public void handleWindowAdjust(Buffer var1);

    public void handleRequest(Buffer var1);

    public void handleData(Buffer var1);

    public void handleExtendedData(Buffer var1);

    public void handleEof();

    public void handleSuccess();

    public void handleFailure();

    public void init(ConnectionService var1, Session var2, long var3);

    public void handleChannelRegistrationResult(ConnectionService var1, Session var2, long var3, boolean var5);

    public void handleChannelUnregistration(ConnectionService var1);

    public boolean isInitialized();

    public boolean isEofSignalled();

    public OpenFuture open(long var1, long var3, long var5, Buffer var7);

    public void handleOpenSuccess(long var1, long var3, long var5, Buffer var7);

    public void handleOpenFailure(Buffer var1);

    @Override
    default public Object resolveAttribute(AttributeRepository$AttributeKey attributeRepository$AttributeKey) {
        return Channel.resolveAttribute(this, attributeRepository$AttributeKey);
    }

    public static Object resolveAttribute(Channel channel, AttributeRepository$AttributeKey attributeRepository$AttributeKey) {
        Objects.requireNonNull(attributeRepository$AttributeKey, "No key");
        if (channel == null) {
            return null;
        }
        Object object = channel.getAttribute(attributeRepository$AttributeKey);
        return object != null ? object : Session.resolveAttribute(channel.getSession(), attributeRepository$AttributeKey);
    }

    public IoWriteFuture writePacket(Buffer var1);
}

