/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.EOFException;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.ChannelIdentifier;
import org.apache.sshd.common.channel.IoWriteFutureImpl;
import org.apache.sshd.common.channel.exception.SshChannelBufferedOutputException;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import org.apache.sshd.common.util.functors.UnaryEquator;
import org.apache.sshd.core.CoreModuleProperties;

public class BufferedIoOutputStream
extends AbstractInnerCloseable
implements ChannelIdentifier,
IoOutputStream {
    protected final Object id;
    protected final long channelId;
    protected final int maxPendingBytesCount;
    protected final Duration maxWaitForPendingWrites;
    protected final IoOutputStream out;
    protected final AtomicInteger pendingBytesCount = new AtomicInteger();
    protected final AtomicLong writtenBytesCount = new AtomicLong();
    protected final Queue writes = new ConcurrentLinkedQueue();
    protected final AtomicReference currentWrite = new AtomicReference();
    protected final AtomicReference pendingException = new AtomicReference();

    public BufferedIoOutputStream(Object object, long l2, IoOutputStream ioOutputStream, PropertyResolver propertyResolver) {
        this(object, l2, ioOutputStream, (Integer)CoreModuleProperties.BUFFERED_IO_OUTPUT_MAX_PENDING_WRITE_SIZE.getRequired(propertyResolver), (Duration)CoreModuleProperties.BUFFERED_IO_OUTPUT_MAX_PENDING_WRITE_WAIT.getRequired(propertyResolver));
    }

    public BufferedIoOutputStream(Object object, long l2, IoOutputStream ioOutputStream, int n2, Duration duration) {
        this.id = Objects.requireNonNull(object, "No stream identifier provided");
        this.channelId = l2;
        this.out = Objects.requireNonNull(ioOutputStream, "No delegate output stream provided");
        this.maxPendingBytesCount = n2;
        ValidateUtils.checkTrue(n2 > 0, "Invalid max. pending bytes count: %d", n2);
        this.maxWaitForPendingWrites = Objects.requireNonNull(duration, "No max. pending time value provided");
    }

    @Override
    public long getChannelId() {
        return this.channelId;
    }

    public Object getId() {
        return this.id;
    }

    @Override
    public IoWriteFuture writeBuffer(Buffer buffer) {
        if (this.isClosing()) {
            throw new EOFException("Closed/ing - state=" + this.state);
        }
        this.waitForAvailableWriteSpace(buffer.available());
        IoWriteFutureImpl ioWriteFutureImpl = new IoWriteFutureImpl(this.getId(), buffer);
        this.writes.add(ioWriteFutureImpl);
        this.startWriting();
        return ioWriteFutureImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForAvailableWriteSpace(int n2) {
        long l2 = System.currentTimeMillis() + this.maxWaitForPendingWrites.toMillis();
        AtomicInteger atomicInteger = this.pendingBytesCount;
        synchronized (atomicInteger) {
            int n3 = this.pendingBytesCount.get();
            while (n3 > 0 && n3 + n2 > this.maxPendingBytesCount && this.pendingException.get() == null) {
                long l3 = l2 - System.currentTimeMillis();
                if (l3 <= 0L) {
                    this.pendingException.compareAndSet(null, new SshChannelBufferedOutputException(this.channelId, "Max. pending write timeout expired after " + this.writtenBytesCount + " bytes"));
                    throw (SshChannelBufferedOutputException)this.pendingException.get();
                }
                try {
                    this.pendingBytesCount.wait(l3);
                }
                catch (InterruptedException interruptedException) {
                    this.pendingException.compareAndSet(null, new SshChannelBufferedOutputException(this.channelId, "Waiting for pending writes interrupted after " + this.writtenBytesCount + " bytes"));
                    throw (SshChannelBufferedOutputException)this.pendingException.get();
                }
                n3 = this.pendingBytesCount.get();
            }
            IOException iOException = (IOException)this.pendingException.get();
            if (iOException != null) {
                throw iOException;
            }
            this.pendingBytesCount.addAndGet(n2);
        }
    }

    private IoWriteFutureImpl getWriteRequest() {
        IoWriteFutureImpl ioWriteFutureImpl = null;
        while (ioWriteFutureImpl == null) {
            ioWriteFutureImpl = (IoWriteFutureImpl)this.writes.peek();
            if (ioWriteFutureImpl == null) {
                return null;
            }
            Throwable throwable = (Throwable)this.pendingException.get();
            if (throwable != null) {
                this.log.error("startWriting({})[{}] propagate to {} write requests pending error={}[{}]", new Object[]{this.getId(), this.out, this.writes.size(), this.getClass().getSimpleName(), throwable.getMessage()});
                IoWriteFutureImpl ioWriteFutureImpl2 = this.currentWrite.getAndSet(null);
                for (IoWriteFutureImpl ioWriteFutureImpl3 : this.writes) {
                    if (UnaryEquator.isSameReference(ioWriteFutureImpl3, ioWriteFutureImpl2)) continue;
                    ioWriteFutureImpl.setValue(throwable);
                }
                this.writes.clear();
                return null;
            }
            if (!this.currentWrite.compareAndSet(null, ioWriteFutureImpl)) {
                return null;
            }
            if (!ioWriteFutureImpl.isDone()) continue;
            this.currentWrite.set(null);
            ioWriteFutureImpl = null;
        }
        return ioWriteFutureImpl;
    }

    protected void startWriting() {
        IoWriteFutureImpl ioWriteFutureImpl = this.getWriteRequest();
        if (ioWriteFutureImpl == null) {
            return;
        }
        Buffer buffer = ioWriteFutureImpl.getBuffer();
        int n2 = buffer.available();
        this.out.writeBuffer(buffer).addListener(ioWriteFuture -> {
            if (ioWriteFuture.isWritten()) {
                ioWriteFutureImpl.setValue(Boolean.TRUE);
            } else {
                ioWriteFutureImpl.setValue(ioWriteFuture.getException());
            }
            this.finishWrite(ioWriteFutureImpl, n2);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishWrite(IoWriteFutureImpl ioWriteFutureImpl, int n2) {
        if (ioWriteFutureImpl.isWritten()) {
            int n3;
            long l2 = this.writtenBytesCount.addAndGet(n2);
            AtomicInteger atomicInteger = this.pendingBytesCount;
            synchronized (atomicInteger) {
                n3 = this.pendingBytesCount.addAndGet(0 - n2);
                this.pendingBytesCount.notifyAll();
            }
            if (n3 < 0) {
                this.log.error("finishWrite({})[{}] - pending byte counts underflow ({}) after {} bytes", new Object[]{this.getId(), this.out, n3, l2});
                this.pendingException.compareAndSet(null, new SshChannelBufferedOutputException(this.channelId, "Pending byte counts underflow"));
            }
        } else {
            Throwable throwable = ioWriteFutureImpl.getException();
            if (throwable instanceof SshChannelBufferedOutputException) {
                this.pendingException.compareAndSet(null, (SshChannelBufferedOutputException)throwable);
            } else {
                this.pendingException.compareAndSet(null, new SshChannelBufferedOutputException(this.channelId, throwable));
            }
            AtomicInteger atomicInteger = this.pendingBytesCount;
            synchronized (atomicInteger) {
                this.pendingBytesCount.notifyAll();
            }
        }
        this.writes.remove(ioWriteFutureImpl);
        this.currentWrite.compareAndSet(ioWriteFutureImpl, null);
        try {
            this.startWriting();
        }
        catch (IOException iOException) {
            if (iOException instanceof SshChannelBufferedOutputException) {
                this.pendingException.compareAndSet(null, (SshChannelBufferedOutputException)iOException);
            } else {
                this.pendingException.compareAndSet(null, new SshChannelBufferedOutputException(this.channelId, (Throwable)iOException));
            }
            this.error("finishWrite({})[{}] failed ({}) re-start writing: {}", this.getId(), this.out, iOException.getClass().getSimpleName(), iOException.getMessage(), iOException);
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().when(this.getId(), this.writes).close(this.out).build();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getId() + "@" + this.channelId + ")[" + this.out + "]";
    }
}

