/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.EOFException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import org.apache.sshd.common.AttributeRepository$AttributeKey;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.AbstractChannel$1;
import org.apache.sshd.common.channel.AbstractChannel$2;
import org.apache.sshd.common.channel.AbstractChannel$GracefulChannelCloseable;
import org.apache.sshd.common.channel.AbstractChannel$GracefulState;
import org.apache.sshd.common.channel.AbstractChannel$PacketValidator;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.channel.RemoteWindow;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.channel.RequestHandler$Result;
import org.apache.sshd.common.channel.exception.SshChannelInvalidPacketException;
import org.apache.sshd.common.channel.throttle.ChannelStreamWriterResolver;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.io.AbstractIoWriteFuture;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.closeable.AbstractCloseable$State;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import org.apache.sshd.common.util.functors.Int2IntFunction;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.functors.Invoker;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ExecutorServiceCarrier;

public abstract class AbstractChannel
extends AbstractInnerCloseable
implements Channel,
ExecutorServiceCarrier {
    public static final IntUnaryOperator RESPONSE_BUFFER_GROWTH_FACTOR = Int2IntFunction.add(8);
    public static final AbstractChannel$PacketValidator DEFAULT_PACKET_VALIDATOR = (l2, l3, bl2) -> l2 <= l3 + 4L;
    protected ConnectionService service;
    protected final AtomicBoolean initialized = new AtomicBoolean(false);
    protected final AtomicBoolean eofReceived = new AtomicBoolean(false);
    @Deprecated
    protected final AtomicBoolean eofSent = new AtomicBoolean(false);
    protected final AtomicBoolean unregisterSignaled = new AtomicBoolean(false);
    protected final AtomicBoolean closeSignaled = new AtomicBoolean(false);
    protected AtomicReference gracefulState = new AtomicReference<AbstractChannel$GracefulState>(AbstractChannel$GracefulState.Opened);
    protected final DefaultCloseFuture gracefulFuture;
    protected final Collection channelListeners = new CopyOnWriteArraySet();
    protected final ChannelListener channelListenerProxy;
    private long id = -1L;
    private long recipient = -1L;
    private Session sessionInstance;
    private CloseableExecutorService executor;
    private final List requestHandlers = new CopyOnWriteArrayList();
    private final LocalWindow localWindow;
    private final RemoteWindow remoteWindow;
    private ChannelStreamWriterResolver channelStreamPacketWriterResolver;
    private AtomicReference eofFuture = new AtomicReference();
    private AbstractChannel$PacketValidator packetValidator = DEFAULT_PACKET_VALIDATOR;
    private final Map pendingRequests = new ConcurrentHashMap();
    private final Map properties = new ConcurrentHashMap();
    private final Map attributes = new ConcurrentHashMap();

    protected AbstractChannel(boolean bl2) {
        this("", bl2);
    }

    protected AbstractChannel(boolean bl2, Collection collection) {
        this("", bl2, collection, null);
    }

    protected AbstractChannel(String string, boolean bl2) {
        this(string, bl2, Collections.emptyList(), null);
    }

    protected AbstractChannel(String string, boolean bl2, Collection collection, CloseableExecutorService closeableExecutorService) {
        super(string);
        this.gracefulFuture = new DefaultCloseFuture(string, this.futureLock);
        this.localWindow = new LocalWindow(this, bl2);
        this.remoteWindow = new RemoteWindow(this, bl2);
        this.channelListenerProxy = (ChannelListener)EventListenerUtils.proxyWrapper(ChannelListener.class, this.channelListeners);
        this.executor = closeableExecutorService;
        this.addRequestHandlers(collection);
    }

    @Override
    public List getRequestHandlers() {
        return this.requestHandlers;
    }

    @Override
    public void addRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.add(Objects.requireNonNull(requestHandler, "No handler instance"));
    }

    @Override
    public void removeRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.remove(Objects.requireNonNull(requestHandler, "No handler instance"));
    }

    @Override
    public long getChannelId() {
        return this.id;
    }

    @Override
    public long getRecipient() {
        return this.recipient;
    }

    protected void setRecipient(long l2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("setRecipient({}) recipient={}", (Object)this, (Object)l2);
        }
        this.recipient = l2;
    }

    @Override
    public LocalWindow getLocalWindow() {
        return this.localWindow;
    }

    @Override
    public RemoteWindow getRemoteWindow() {
        return this.remoteWindow;
    }

    @Override
    public Session getSession() {
        return this.sessionInstance;
    }

    @Override
    public PropertyResolver getParentPropertyResolver() {
        return this.getSession();
    }

    @Override
    public CloseableExecutorService getExecutorService() {
        return this.executor;
    }

    @Override
    public ChannelStreamWriterResolver getChannelStreamWriterResolver() {
        return this.channelStreamPacketWriterResolver;
    }

    @Override
    public void setChannelStreamWriterResolver(ChannelStreamWriterResolver channelStreamWriterResolver) {
        this.channelStreamPacketWriterResolver = channelStreamWriterResolver;
    }

    @Override
    public ChannelStreamWriterResolver resolveChannelStreamWriterResolver() {
        ChannelStreamWriterResolver channelStreamWriterResolver = this.getChannelStreamWriterResolver();
        if (channelStreamWriterResolver != null) {
            return channelStreamWriterResolver;
        }
        Session session = this.getSession();
        return session.resolveChannelStreamWriterResolver();
    }

    protected Date addPendingRequest(String string, boolean bl2) {
        if (!bl2) {
            return null;
        }
        Date date = new Date(System.currentTimeMillis());
        Date date2 = this.pendingRequests.put(string, date);
        ValidateUtils.checkTrue(date2 == null, "Multiple pending requests of type=%s", (Object)string);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPendingRequest({}) request={}, pending={}", new Object[]{this, string, date});
        }
        return date;
    }

    protected Date removePendingRequest(String string) {
        Date date = (Date)this.pendingRequests.remove(string);
        if (this.log.isDebugEnabled()) {
            this.log.debug("removePendingRequest({}) request={}, pending={}", new Object[]{this, string, date});
        }
        return date;
    }

    @Override
    public void handleRequest(Buffer buffer) {
        this.handleChannelRequest(buffer.getString(), buffer.getBoolean(), buffer);
    }

    protected void handleChannelRequest(String string, boolean bl2, Buffer buffer) {
        boolean bl3 = this.log.isDebugEnabled();
        if (bl3) {
            this.log.debug("handleChannelRequest({}) SSH_MSG_CHANNEL_REQUEST {} wantReply={}", new Object[]{this, string, bl2});
        }
        List list = this.getRequestHandlers();
        boolean bl4 = this.log.isTraceEnabled();
        for (RequestHandler requestHandler : list) {
            RequestHandler$Result requestHandler$Result;
            try {
                requestHandler$Result = requestHandler.process(this, string, bl2, buffer);
            }
            catch (Throwable throwable) {
                this.debug("handleRequest({}) {} while {}#process({})[want-reply={}]: {}", this, throwable.getClass().getSimpleName(), requestHandler.getClass().getSimpleName(), string, bl2, throwable.getMessage(), throwable);
                requestHandler$Result = RequestHandler$Result.ReplyFailure;
            }
            if (RequestHandler$Result.Unsupported.equals((Object)requestHandler$Result)) {
                if (!bl4) continue;
                this.log.trace("handleRequest({})[{}#process({})[want-reply={}]]: {}", new Object[]{this, requestHandler.getClass().getSimpleName(), string, bl2, requestHandler$Result});
                continue;
            }
            this.sendResponse(buffer, string, requestHandler$Result, bl2);
            return;
        }
        this.handleUnknownChannelRequest(string, bl2, buffer);
    }

    protected void handleUnknownChannelRequest(String string, boolean bl2, Buffer buffer) {
        RequestHandler$Result requestHandler$Result = this.handleInternalRequest(string, bl2, buffer);
        if (requestHandler$Result == null || RequestHandler$Result.Unsupported.equals((Object)requestHandler$Result)) {
            this.log.warn("handleUnknownChannelRequest({}) Unknown channel request: {}[want-reply={}]", new Object[]{this, string, bl2});
            this.sendResponse(buffer, string, RequestHandler$Result.Unsupported, bl2);
        } else {
            this.sendResponse(buffer, string, requestHandler$Result, bl2);
        }
    }

    protected RequestHandler$Result handleInternalRequest(String string, boolean bl2, Buffer buffer) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleInternalRequest({})[want-reply={}] unknown type: {}", new Object[]{this, bl2, string});
        }
        return RequestHandler$Result.Unsupported;
    }

    protected IoWriteFuture sendResponse(Buffer buffer, String string, RequestHandler$Result requestHandler$Result, boolean bl2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendResponse({}) request={} result={}, want-reply={}", new Object[]{this, string, requestHandler$Result, bl2});
        }
        if (RequestHandler$Result.Replied.equals((Object)requestHandler$Result) || !bl2) {
            return AbstractIoWriteFuture.fulfilled(string, Boolean.TRUE);
        }
        byte by = RequestHandler$Result.ReplySuccess.equals((Object)requestHandler$Result) ? (byte)99 : 100;
        Session session = this.getSession();
        Buffer buffer2 = session.createBuffer(by, 4);
        buffer2.putUInt(this.recipient);
        return session.writePacket(buffer2);
    }

    @Override
    public void init(ConnectionService connectionService, Session session, long l2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("init() service={} session={} id={}", new Object[]{connectionService, session, l2});
        }
        this.service = connectionService;
        this.sessionInstance = session;
        this.id = l2;
        this.signalChannelInitialized();
        this.configureWindow();
        this.initialized.set(true);
    }

    protected void signalChannelInitialized() {
        try {
            this.invokeChannelSignaller(channelListener -> {
                this.signalChannelInitialized((ChannelListener)channelListener);
                return null;
            });
            this.notifyStateChanged("init");
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.peelException(throwable);
            if (throwable2 instanceof IOException) {
                throw (IOException)throwable2;
            }
            if (throwable2 instanceof RuntimeException) {
                throw (RuntimeException)throwable2;
            }
            throw new IOException("Failed (" + throwable2.getClass().getSimpleName() + ") to notify channel " + this + " initialization: " + throwable2.getMessage(), throwable2);
        }
    }

    protected void signalChannelInitialized(ChannelListener channelListener) {
        if (channelListener == null) {
            return;
        }
        channelListener.channelInitialized(this);
    }

    protected void signalChannelOpenSuccess() {
        try {
            this.invokeChannelSignaller(channelListener -> {
                this.signalChannelOpenSuccess((ChannelListener)channelListener);
                return null;
            });
        }
        catch (Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
    }

    protected void signalChannelOpenSuccess(ChannelListener channelListener) {
        if (channelListener == null) {
            return;
        }
        channelListener.channelOpenSuccess(this);
    }

    @Override
    public boolean isInitialized() {
        return this.initialized.get();
    }

    @Override
    public void handleChannelRegistrationResult(ConnectionService connectionService, Session session, long l2, boolean bl2) {
        this.notifyStateChanged("registered=" + bl2);
        if (bl2) {
            return;
        }
        IllegalStateException illegalStateException = new IllegalStateException("Channel id=" + l2 + " not registered because session is being closed: " + this);
        this.signalChannelClosed(illegalStateException);
        throw illegalStateException;
    }

    protected void signalChannelOpenFailure(Throwable throwable) {
        try {
            this.invokeChannelSignaller(channelListener -> {
                this.signalChannelOpenFailure((ChannelListener)channelListener, throwable);
                return null;
            });
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = ExceptionUtils.peelException(throwable2);
            this.debug("signalChannelOpenFailure({}) failed ({}) to inform listener of open failure={}: {}", this, throwable3.getClass().getSimpleName(), throwable.getClass().getSimpleName(), throwable3.getMessage(), throwable3);
        }
    }

    protected void signalChannelOpenFailure(ChannelListener channelListener, Throwable throwable) {
        if (channelListener == null) {
            return;
        }
        channelListener.channelOpenFailure(this, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStateChanged(String string) {
        try {
            this.invokeChannelSignaller(channelListener -> {
                this.notifyStateChanged((ChannelListener)channelListener, string);
                return null;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = ExceptionUtils.peelException(throwable);
            this.debug("notifyStateChanged({})[{}] {} while signal channel state change: {}", this, string, throwable2.getClass().getSimpleName(), throwable2.getMessage(), throwable2);
        }
        finally {
            Object object = this.futureLock;
            synchronized (object) {
                this.futureLock.notifyAll();
            }
        }
    }

    protected void notifyStateChanged(ChannelListener channelListener, String string) {
        if (channelListener == null) {
            return;
        }
        channelListener.channelStateChanged(this, string);
    }

    @Override
    public void addChannelListener(ChannelListener channelListener) {
        ChannelListener.validateListener(channelListener);
        if (!this.isOpen()) {
            this.log.warn("addChannelListener({})[{}] ignore registration while channel is closing", (Object)this, (Object)channelListener);
            return;
        }
        if (this.channelListeners.add(channelListener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addChannelListener({})[{}] registered", (Object)this, (Object)channelListener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addChannelListener({})[{}] ignored duplicate", (Object)this, (Object)channelListener);
        }
    }

    @Override
    public void removeChannelListener(ChannelListener channelListener) {
        if (channelListener == null) {
            return;
        }
        ChannelListener.validateListener(channelListener);
        if (this.channelListeners.remove(channelListener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removeChannelListener({})[{}] removed", (Object)this, (Object)channelListener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removeChannelListener({})[{}] not registered", (Object)this, (Object)channelListener);
        }
    }

    @Override
    public ChannelListener getChannelListenerProxy() {
        return this.channelListenerProxy;
    }

    @Override
    public void handleClose() {
        boolean bl2 = this.log.isDebugEnabled();
        if (bl2) {
            this.log.debug("handleClose({}) SSH_MSG_CHANNEL_CLOSE", (Object)this);
        }
        try {
            IoWriteFuture ioWriteFuture = AbstractIoWriteFuture.fulfilled(this.getChannelId(), this.futureLock);
            if (this.eofFuture.compareAndSet(null, ioWriteFuture)) {
                if (bl2) {
                    this.log.debug("handleClose({}) prevent sending EOF", (Object)this);
                }
                this.eofSent.set(true);
            }
            if (this.gracefulState.compareAndSet(AbstractChannel$GracefulState.Opened, AbstractChannel$GracefulState.CloseReceived)) {
                this.close(false);
            } else if (this.gracefulState.compareAndSet(AbstractChannel$GracefulState.CloseSent, AbstractChannel$GracefulState.Closed)) {
                this.gracefulFuture.setClosed();
            }
        }
        finally {
            this.notifyStateChanged("SSH_MSG_CHANNEL_CLOSE");
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        Closeable closeable = this.builder().close(new AbstractChannel$1(this, this, this.futureLock)).sequential(new AbstractChannel$GracefulChannelCloseable(this), this.getExecutorService()).run(this.toString(), () -> {
            if (this.service != null) {
                this.service.unregisterChannel(this);
            }
        }).build();
        closeable.addCloseFutureListener(closeFuture -> this.clearAttributes());
        return closeable;
    }

    @Override
    protected void preClose() {
        if (!this.isEofSent()) {
            this.log.debug("close({}) no EOF sent", (Object)this);
        }
        try {
            this.signalChannelClosed(null);
        }
        finally {
            this.channelListeners.clear();
        }
        IOException iOException = IoUtils.closeQuietly(this.getLocalWindow(), this.getRemoteWindow());
        if (iOException != null) {
            this.debug("Failed ({}) to pre-close window(s) of {}: {}", iOException.getClass().getSimpleName(), this, iOException.getMessage(), iOException);
        }
        super.preClose();
    }

    @Override
    public void handleChannelUnregistration(ConnectionService connectionService) {
        if (!this.unregisterSignaled.getAndSet(true) && this.log.isTraceEnabled()) {
            this.log.trace("handleChannelUnregistration({}) via service={}", (Object)this, (Object)connectionService);
        }
        this.notifyStateChanged("unregistered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalChannelClosed(Throwable throwable) {
        String string = throwable == null ? "signalChannelClosed" : throwable.getClass().getSimpleName();
        try {
            if (!this.closeSignaled.getAndSet(true) && this.log.isTraceEnabled()) {
                this.log.trace("signalChannelClosed({})[{}]", (Object)this, (Object)string);
            }
            this.invokeChannelSignaller(channelListener -> {
                this.signalChannelClosed((ChannelListener)channelListener, throwable);
                return null;
            });
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = ExceptionUtils.peelException(throwable2);
            this.debug("signalChannelClosed({}) {} while signal channel closed: {}", this, throwable3.getClass().getSimpleName(), throwable3.getMessage(), throwable3);
        }
        finally {
            this.notifyStateChanged(string);
        }
    }

    protected void signalChannelClosed(ChannelListener channelListener, Throwable throwable) {
        if (channelListener == null) {
            return;
        }
        channelListener.channelClosed(this, throwable);
    }

    protected void invokeChannelSignaller(Invoker invoker) {
        Session session = this.getSession();
        FactoryManager factoryManager = session == null ? null : session.getFactoryManager();
        ChannelListener[] channelListenerArray = new ChannelListener[]{factoryManager == null ? null : factoryManager.getChannelListenerProxy(), session == null ? null : session.getChannelListenerProxy(), this.getChannelListenerProxy()};
        Throwable throwable = null;
        for (ChannelListener channelListener : channelListenerArray) {
            if (channelListener == null) continue;
            try {
                invoker.invoke(channelListener);
            }
            catch (Throwable throwable2) {
                throwable = ExceptionUtils.accumulateException(throwable, throwable2);
            }
        }
        if (throwable != null) {
            throw throwable;
        }
    }

    @Override
    public IoWriteFuture writePacket(Buffer buffer) {
        if (this.mayWrite()) {
            Session session = this.getSession();
            return session.writePacket(buffer);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("writePacket({}) Discarding output packet because channel state={}", (Object)this, (Object)this.state);
        }
        return AbstractIoWriteFuture.fulfilled(this.toString(), new EOFException("Channel is being closed"));
    }

    protected boolean mayWrite() {
        return !this.isClosing();
    }

    @Override
    public void handleData(Buffer buffer) {
        long l2 = this.validateIncomingDataSize(94, buffer.getUInt());
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleData({}) SSH_MSG_CHANNEL_DATA len={}", (Object)this, (Object)l2);
        }
        if (this.log.isTraceEnabled()) {
            BufferUtils.dumpHex(this.getSimplifiedLogger(), BufferUtils.DEFAULT_HEXDUMP_LEVEL, "handleData(" + this + ")", (PropertyResolver)this, ' ', buffer.array(), buffer.rpos(), (int)l2);
        }
        if (this.isEofSignalled()) {
            this.log.warn("handleData({}) extra {} bytes sent after EOF", (Object)this, (Object)l2);
        }
        this.doWriteData(buffer.array(), buffer.rpos(), l2);
    }

    @Override
    public void handleExtendedData(Buffer buffer) {
        int n2 = buffer.getInt();
        if (n2 != 1) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleExtendedData({}) SSH_MSG_CHANNEL_FAILURE - non STDERR type: {}", (Object)this, (Object)n2);
            }
            Session session = this.getSession();
            Buffer buffer2 = session.createBuffer((byte)100, 4);
            buffer2.putUInt(this.getRecipient());
            this.writePacket(buffer2);
            return;
        }
        long l2 = this.validateIncomingDataSize(95, buffer.getUInt());
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleExtendedData({}) SSH_MSG_CHANNEL_EXTENDED_DATA len={}", (Object)this, (Object)l2);
        }
        if (this.log.isTraceEnabled()) {
            BufferUtils.dumpHex(this.getSimplifiedLogger(), BufferUtils.DEFAULT_HEXDUMP_LEVEL, "handleExtendedData(" + this + ")", (PropertyResolver)this, ' ', buffer.array(), buffer.rpos(), (int)l2);
        }
        if (this.isEofSignalled()) {
            this.log.warn("handleExtendedData({}) extra {} bytes sent after EOF", (Object)this, (Object)l2);
        }
        this.doWriteExtendedData(buffer.array(), buffer.rpos(), l2);
    }

    protected long validateIncomingDataSize(int n2, long l2) {
        if (!BufferUtils.isValidUint32Value(l2)) {
            throw new IllegalArgumentException("Non UINT32 length (" + l2 + ") for command=" + SshConstants.getCommandMessageName(n2));
        }
        LocalWindow localWindow = this.getLocalWindow();
        long l3 = localWindow.getPacketSize();
        AbstractChannel$PacketValidator abstractChannel$PacketValidator = this.getPacketValidator();
        if (!abstractChannel$PacketValidator.isValid(l2, l3, n2 == 95)) {
            throw new SshChannelInvalidPacketException(this.getChannelId(), "Bad length (" + l2 + ")  for cmd=" + SshConstants.getCommandMessageName(n2) + " - max. allowed=" + l3);
        }
        localWindow.consume(l2);
        return l2;
    }

    public AbstractChannel$PacketValidator getPacketValidator() {
        return this.packetValidator;
    }

    public void setPacketValidator(AbstractChannel$PacketValidator abstractChannel$PacketValidator) {
        this.packetValidator = abstractChannel$PacketValidator == null ? DEFAULT_PACKET_VALIDATOR : abstractChannel$PacketValidator;
    }

    @Override
    public void handleEof() {
        if (this.eofReceived.getAndSet(true)) {
            this.log.warn("handleEof({}) already signalled", (Object)this);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("handleEof({}) SSH_MSG_CHANNEL_EOF", (Object)this);
        }
        this.notifyStateChanged("SSH_MSG_CHANNEL_EOF");
    }

    @Override
    public boolean isEofSignalled() {
        return this.eofReceived.get();
    }

    @Override
    public void handleWindowAdjust(Buffer buffer) {
        long l2 = buffer.getUInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleWindowAdjust({}) SSH_MSG_CHANNEL_WINDOW_ADJUST window={}", (Object)this, (Object)l2);
        }
        RemoteWindow remoteWindow = this.getRemoteWindow();
        remoteWindow.expand(l2);
        this.notifyStateChanged("SSH_MSG_CHANNEL_WINDOW_ADJUST");
    }

    @Override
    public void handleSuccess() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleFhandleSuccessailure({}) SSH_MSG_CHANNEL_SUCCESS", (Object)this);
        }
    }

    @Override
    public void handleFailure() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleFailure({}) SSH_MSG_CHANNEL_FAILURE", (Object)this);
        }
    }

    protected abstract void doWriteData(byte[] var1, int var2, long var3);

    protected abstract void doWriteExtendedData(byte[] var1, int var2, long var3);

    protected IoWriteFuture sendEof() {
        AbstractCloseable$State abstractCloseable$State = (AbstractCloseable$State)((Object)this.state.get());
        if (abstractCloseable$State != AbstractCloseable$State.Opened && abstractCloseable$State != AbstractCloseable$State.Graceful) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendEof({}) already closing or closed - state={}", (Object)this, (Object)this.state);
            }
            return null;
        }
        AbstractChannel$2 abstractChannel$2 = new AbstractChannel$2(this, this.getChannelId(), this.futureLock);
        if (!this.eofFuture.compareAndSet(null, abstractChannel$2)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("sendEof({}) already sent (state={})", (Object)this, (Object)abstractCloseable$State);
            }
            return null;
        }
        this.eofSent.set(true);
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendEof({}) SSH_MSG_CHANNEL_EOF (state={})", (Object)this, (Object)abstractCloseable$State);
        }
        IoWriteFuture ioWriteFuture2 = null;
        try {
            Session session = this.getSession();
            Buffer buffer = session.createBuffer((byte)96, 16);
            buffer.putUInt(this.getRecipient());
            ioWriteFuture2 = session.writePacket(buffer);
        }
        catch (IOException iOException) {
            abstractChannel$2.setValue(iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            abstractChannel$2.setValue(runtimeException);
            throw new IOException(runtimeException.getMessage(), runtimeException);
        }
        return (IoWriteFuture)ioWriteFuture2.addListener(ioWriteFuture -> {
            Throwable throwable = ioWriteFuture.getException();
            abstractChannel$2.setValue(throwable != null ? throwable : Boolean.TRUE);
        });
    }

    public boolean isEofSent() {
        return this.eofFuture.get() != null;
    }

    @Override
    public Map getProperties() {
        return this.properties;
    }

    @Override
    public int getAttributesCount() {
        return this.attributes.size();
    }

    @Override
    public Object getAttribute(AttributeRepository$AttributeKey attributeRepository$AttributeKey) {
        return this.attributes.get(Objects.requireNonNull(attributeRepository$AttributeKey, "No key"));
    }

    @Override
    public Collection attributeKeys() {
        return this.attributes.isEmpty() ? Collections.emptySet() : new HashSet(this.attributes.keySet());
    }

    @Override
    public Object computeAttributeIfAbsent(AttributeRepository$AttributeKey attributeRepository$AttributeKey, Function function) {
        return this.attributes.computeIfAbsent(Objects.requireNonNull(attributeRepository$AttributeKey, "No key"), function);
    }

    @Override
    public Object setAttribute(AttributeRepository$AttributeKey attributeRepository$AttributeKey, Object object) {
        return this.attributes.put(Objects.requireNonNull(attributeRepository$AttributeKey, "No key"), Objects.requireNonNull(object, "No value"));
    }

    @Override
    public Object removeAttribute(AttributeRepository$AttributeKey attributeRepository$AttributeKey) {
        return this.attributes.remove(Objects.requireNonNull(attributeRepository$AttributeKey, "No key"));
    }

    @Override
    public void clearAttributes() {
        this.attributes.clear();
    }

    protected void configureWindow() {
        this.localWindow.init(this);
    }

    protected void sendWindowAdjust(long l2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendWindowAdjust({}) SSH_MSG_CHANNEL_WINDOW_ADJUST len={}", (Object)this, (Object)l2);
        }
        Session session = this.getSession();
        Buffer buffer = session.createBuffer((byte)93, 16);
        buffer.putUInt(this.getRecipient());
        buffer.putUInt(l2);
        this.writePacket(buffer);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getChannelId() + ", recipient=" + this.getRecipient() + "]-" + this.getSession();
    }

    static /* synthetic */ AtomicReference access$000(AbstractChannel abstractChannel) {
        return abstractChannel.eofFuture;
    }
}

