/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.AbstractChannel$GracefulState;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.IoBaseCloseable;
import org.apache.sshd.core.CoreModuleProperties;

public class AbstractChannel$GracefulChannelCloseable
extends IoBaseCloseable {
    private final AtomicBoolean closing = new AtomicBoolean(false);
    final /* synthetic */ AbstractChannel this$0;

    public AbstractChannel$GracefulChannelCloseable(AbstractChannel abstractChannel) {
        this.this$0 = abstractChannel;
    }

    @Override
    public void addCloseFutureListener(SshFutureListener sshFutureListener) {
        this.this$0.gracefulFuture.addListener(sshFutureListener);
    }

    @Override
    public void removeCloseFutureListener(SshFutureListener sshFutureListener) {
        this.this$0.gracefulFuture.removeListener(sshFutureListener);
    }

    @Override
    public boolean isClosing() {
        return this.closing.get();
    }

    public void setClosing(boolean bl2) {
        this.closing.set(bl2);
    }

    @Override
    public boolean isClosed() {
        return this.this$0.gracefulFuture.isClosed();
    }

    @Override
    public CloseFuture close(boolean bl2) {
        Object object;
        Closeable closeable;
        AbstractChannel abstractChannel = this.this$0;
        boolean bl3 = this.log.isDebugEnabled();
        if (bl3) {
            this.log.debug("close({})[immediately={}] processing", (Object)abstractChannel, (Object)bl2);
        }
        this.setClosing(true);
        long l2 = this.this$0.getRecipient();
        if (bl2 || l2 < 0L) {
            this.this$0.gracefulFuture.setClosed();
        } else if (!this.this$0.gracefulFuture.isClosed()) {
            if (bl3) {
                this.log.debug("close({})[immediately={}] send SSH_MSG_CHANNEL_CLOSE", (Object)abstractChannel, (Object)bl2);
            }
            closeable = this.this$0.getSession();
            object = closeable.createBuffer((byte)97, 16);
            ((Buffer)object).putUInt(l2);
            try {
                Duration duration = (Duration)CoreModuleProperties.CHANNEL_CLOSE_TIMEOUT.getRequired(abstractChannel);
                closeable.writePacket((Buffer)object, duration).addListener(ioWriteFuture -> {
                    if (ioWriteFuture.isWritten()) {
                        this.handleClosePacketWritten(abstractChannel, bl2);
                    } else {
                        this.handleClosePacketWriteFailure(abstractChannel, bl2, ioWriteFuture.getException());
                    }
                });
            }
            catch (IOException iOException) {
                this.debug("close({})[immediately={}] {} while writing SSH_MSG_CHANNEL_CLOSE packet on channel: {}", abstractChannel, bl2, iOException.getClass().getSimpleName(), iOException.getMessage(), iOException);
                abstractChannel.close(true);
            }
        }
        closeable = this.this$0.getExecutorService();
        if (closeable != null && !closeable.isShutdown()) {
            object = closeable.shutdownNow();
            if (bl3) {
                this.log.debug("close({})[immediately={}] shutdown executor service on close - running count={}", new Object[]{abstractChannel, bl2, GenericUtils.size((Collection)object)});
            }
        }
        return this.this$0.gracefulFuture;
    }

    protected void handleClosePacketWritten(Channel channel, boolean bl2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleClosePacketWritten({})[immediately={}] SSH_MSG_CHANNEL_CLOSE written on channel", (Object)channel, (Object)bl2);
        }
        if (this.this$0.gracefulState.compareAndSet(AbstractChannel$GracefulState.Opened, AbstractChannel$GracefulState.CloseSent)) {
            return;
        }
        if (this.this$0.gracefulState.compareAndSet(AbstractChannel$GracefulState.CloseReceived, AbstractChannel$GracefulState.Closed)) {
            this.this$0.gracefulFuture.setClosed();
        }
    }

    protected void handleClosePacketWriteFailure(Channel channel, boolean bl2, Throwable throwable) {
        this.debug("handleClosePacketWriteFailure({})[immediately={}] failed ({}) to write SSH_MSG_CHANNEL_CLOSE on channel: {}", this, bl2, throwable.getClass().getSimpleName(), throwable.getMessage(), throwable);
        channel.close(true);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.this$0 + "]";
    }
}

