/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.auth;

import java.util.Collection;
import org.apache.sshd.common.CommonModuleProperties;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.auth.UserAuthInstance;
import org.apache.sshd.common.session.SessionContext;

public interface UserAuthMethodFactory
extends NamedResource {
    public static final String PASSWORD = "password";
    public static final String PUBLIC_KEY = "publickey";
    public static final String KB_INTERACTIVE = "keyboard-interactive";
    public static final String HOST_BASED = "hostbased";

    public UserAuthInstance createUserAuth(SessionContext var1);

    public static UserAuthInstance createUserAuth(SessionContext sessionContext, Collection collection, String string) {
        UserAuthMethodFactory userAuthMethodFactory = (UserAuthMethodFactory)NamedResource.findByName(string, String.CASE_INSENSITIVE_ORDER, collection);
        if (userAuthMethodFactory != null) {
            return userAuthMethodFactory.createUserAuth(sessionContext);
        }
        return null;
    }

    public static boolean isSecureAuthenticationTransport(SessionContext sessionContext) {
        if (sessionContext == null) {
            return false;
        }
        boolean bl2 = (Boolean)CommonModuleProperties.ALLOW_INSECURE_AUTH.getRequired(sessionContext);
        if (bl2) {
            return true;
        }
        return SessionContext.isSecureSessionTransport(sessionContext);
    }

    public static boolean isDataIntegrityAuthenticationTransport(SessionContext sessionContext) {
        if (sessionContext == null) {
            return false;
        }
        boolean bl2 = (Boolean)CommonModuleProperties.ALLOW_NON_INTEGRITY_AUTH.getRequired(sessionContext);
        if (bl2) {
            return true;
        }
        return SessionContext.isDataIntegrityTransport(sessionContext);
    }
}

