/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.SyspropsMapWrapper$1;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;

public final class SyspropsMapWrapper
implements Map {
    public static final String SYSPROPS_MAPPED_PREFIX = "org.apache.sshd.config";
    public static final PropertyResolver RAW_PROPS_RESOLVER = PropertyResolverUtils.toPropertyResolver(System.getProperties());
    public static final SyspropsMapWrapper INSTANCE = new SyspropsMapWrapper();
    public static final PropertyResolver SYSPROPS_RESOLVER = new SyspropsMapWrapper$1();

    private SyspropsMapWrapper() {
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("sysprops#clear() N/A");
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        Properties properties = System.getProperties();
        for (String string : properties.stringPropertyNames()) {
            String string2;
            if (!SyspropsMapWrapper.isMappedSyspropKey(string) || !Objects.equals(string2 = properties.getProperty(string), object)) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        Properties properties = System.getProperties();
        TreeSet<AbstractMap.SimpleImmutableEntry<String, String>> treeSet = new TreeSet<AbstractMap.SimpleImmutableEntry<String, String>>(MapEntryUtils.byKeyEntryComparator());
        for (String string : properties.stringPropertyNames()) {
            String string2;
            if (!SyspropsMapWrapper.isMappedSyspropKey(string) || (string2 = properties.getProperty(string)) == null) continue;
            String string3 = SyspropsMapWrapper.getUnmappedSyspropKey(string);
            treeSet.add(new AbstractMap.SimpleImmutableEntry<String, String>(string3, string2));
        }
        return treeSet;
    }

    public Object get(Object object) {
        String string = SyspropsMapWrapper.getMappedSyspropKey(object);
        return object instanceof String ? System.getProperty(string) : null;
    }

    @Override
    public boolean isEmpty() {
        return GenericUtils.isEmpty(this.keySet());
    }

    public Set keySet() {
        return System.getProperties().stringPropertyNames().stream().filter(SyspropsMapWrapper::isMappedSyspropKey).map(SyspropsMapWrapper::getUnmappedSyspropKey).collect(Collectors.toSet());
    }

    public Object put(String string, Object object) {
        throw new UnsupportedOperationException("sysprops#put(" + string + ")[" + object + "] N/A");
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException("sysprops#putAll(" + map + ") N/A");
    }

    public Object remove(Object object) {
        throw new UnsupportedOperationException("sysprops#remove(" + object + ") N/A");
    }

    @Override
    public int size() {
        return GenericUtils.size(this.keySet());
    }

    public Collection values() {
        Properties properties = System.getProperties();
        return properties.stringPropertyNames().stream().filter(SyspropsMapWrapper::isMappedSyspropKey).map(properties::get).collect(Collectors.toList());
    }

    public String toString() {
        return Objects.toString(this.entrySet(), null);
    }

    public static boolean isMappedSyspropKey(String string) {
        return GenericUtils.length(string) > SYSPROPS_MAPPED_PREFIX.length() + 1 && string.startsWith(SYSPROPS_MAPPED_PREFIX) && string.charAt(SYSPROPS_MAPPED_PREFIX.length()) == '.';
    }

    public static String getUnmappedSyspropKey(Object object) {
        String string = Objects.toString(object);
        return SyspropsMapWrapper.isMappedSyspropKey(string) ? string.substring(SYSPROPS_MAPPED_PREFIX.length() + 1) : string;
    }

    public static String getMappedSyspropKey(Object object) {
        return "org.apache.sshd.config." + object;
    }
}

