/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.io.IOException;
import java.util.Objects;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.util.GenericUtils;

public class SshException
extends IOException {
    private static final long serialVersionUID = -7349477687125144606L;
    private final int disconnectCode;

    public SshException(String string) {
        this(string, null);
    }

    public SshException(Throwable throwable) {
        this(Objects.requireNonNull(throwable, "No cause").getMessage(), throwable);
    }

    public SshException(String string, Throwable throwable) {
        this(0, string, throwable);
    }

    public SshException(int n2) {
        this(n2, SshConstants.getDisconnectReasonName(n2));
    }

    public SshException(int n2, String string) {
        this(n2, string, null);
    }

    public SshException(int n2, Throwable throwable) {
        this(n2, SshConstants.getDisconnectReasonName(n2), throwable);
    }

    public SshException(int n2, String string, Throwable throwable) {
        super(GenericUtils.isEmpty(string) ? SshConstants.getDisconnectReasonName(n2) : string);
        this.disconnectCode = n2;
        if (throwable != null) {
            this.initCause(throwable);
        }
    }

    public int getDisconnectCode() {
        return this.disconnectCode;
    }
}

