/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils$1;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;

public final class PropertyResolverUtils {
    public static final String NONE_VALUE = "none";
    public static final NavigableSet TRUE_VALUES = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, "true", "t", "yes", "y", "on"));
    public static final NavigableSet FALSE_VALUES = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, "false", "f", "no", "n", "off"));

    private PropertyResolverUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static boolean isNoneValue(String string) {
        return NONE_VALUE.equalsIgnoreCase(string);
    }

    public static long getLongProperty(PropertyResolver propertyResolver, String string, long l2) {
        return PropertyResolverUtils.toLong(PropertyResolverUtils.resolvePropertyValue(propertyResolver, string), l2);
    }

    public static long getLongProperty(Map map, String string, long l2) {
        return PropertyResolverUtils.toLong(PropertyResolverUtils.resolvePropertyValue(map, string), l2);
    }

    public static long toLong(Object object, long l2) {
        if (object == null) {
            return l2;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return Long.parseLong(object.toString());
    }

    public static Long getLong(PropertyResolver propertyResolver, String string) {
        return PropertyResolverUtils.toLong(PropertyResolverUtils.resolvePropertyValue(propertyResolver, string));
    }

    public static Long getLong(Map map, String string) {
        return PropertyResolverUtils.toLong(PropertyResolverUtils.resolvePropertyValue(map, string));
    }

    public static Long toLong(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return Long.valueOf(object.toString());
    }

    public static Enum toEnum(Class clazz, Object object, boolean bl2, Collection collection) {
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return (Enum)clazz.cast(object);
        }
        if (object instanceof CharSequence) {
            String string = object.toString();
            if (GenericUtils.size(collection) > 0) {
                for (Enum enum_ : collection) {
                    if (!string.equalsIgnoreCase(enum_.name())) continue;
                    return enum_;
                }
            }
            if (bl2) {
                throw new NoSuchElementException("No match found for " + clazz.getSimpleName() + "[" + string + "]");
            }
            return null;
        }
        throw new IllegalArgumentException("Bad value type for enum conversion: " + object.getClass().getSimpleName());
    }

    public static Object updateProperty(PropertyResolver propertyResolver, String string, long l2) {
        return PropertyResolverUtils.updateProperty(propertyResolver.getProperties(), string, l2);
    }

    public static Object updateProperty(Map map, String string, long l2) {
        return PropertyResolverUtils.updateProperty(map, string, (Object)l2);
    }

    public static int getIntProperty(PropertyResolver propertyResolver, String string, int n2) {
        return PropertyResolverUtils.toInteger(PropertyResolverUtils.resolvePropertyValue(propertyResolver, string), n2);
    }

    public static int getIntProperty(Map map, String string, int n2) {
        return PropertyResolverUtils.toInteger(PropertyResolverUtils.resolvePropertyValue(map, string), n2);
    }

    public static int toInteger(Object object, int n2) {
        if (object == null) {
            return n2;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return Integer.parseInt(object.toString());
    }

    public static Integer getInteger(PropertyResolver propertyResolver, String string) {
        return PropertyResolverUtils.toInteger(PropertyResolverUtils.resolvePropertyValue(propertyResolver, string));
    }

    public static Integer getInteger(Map map, String string) {
        return PropertyResolverUtils.toInteger(PropertyResolverUtils.resolvePropertyValue(map, string));
    }

    public static Integer toInteger(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return Integer.valueOf(object.toString());
    }

    public static Object updateProperty(PropertyResolver propertyResolver, String string, int n2) {
        return PropertyResolverUtils.updateProperty(propertyResolver.getProperties(), string, n2);
    }

    public static Object updateProperty(Map map, String string, int n2) {
        return PropertyResolverUtils.updateProperty(map, string, (Object)n2);
    }

    public static boolean getBooleanProperty(PropertyResolver propertyResolver, String string, boolean bl2) {
        return PropertyResolverUtils.toBoolean(PropertyResolverUtils.getObject(propertyResolver, string), bl2);
    }

    public static boolean getBooleanProperty(Map map, String string, boolean bl2) {
        return PropertyResolverUtils.toBoolean(PropertyResolverUtils.getObject(map, string), bl2);
    }

    public static boolean toBoolean(Object object, boolean bl2) {
        Boolean bl3 = PropertyResolverUtils.toBoolean(object);
        if (bl3 == null) {
            return bl2;
        }
        return bl3;
    }

    public static Boolean getBoolean(PropertyResolver propertyResolver, String string) {
        Object object = PropertyResolverUtils.resolvePropertyValue(propertyResolver, string);
        return PropertyResolverUtils.toBoolean(object);
    }

    public static Boolean getBoolean(Map map, String string) {
        Object object = PropertyResolverUtils.resolvePropertyValue(map, string);
        return PropertyResolverUtils.toBoolean(object);
    }

    public static Boolean toBoolean(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof CharSequence) {
            return PropertyResolverUtils.parseBoolean(object.toString());
        }
        throw new UnsupportedOperationException("Cannot convert " + object.getClass().getSimpleName() + "[" + object + "] to boolean");
    }

    public static Boolean parseBoolean(String string) {
        if (GenericUtils.isEmpty(string)) {
            return null;
        }
        if (TRUE_VALUES.contains(string)) {
            return Boolean.TRUE;
        }
        if (FALSE_VALUES.contains(string)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Unknown boolean value: '" + string + "'");
    }

    public static Object updateProperty(PropertyResolver propertyResolver, String string, boolean bl2) {
        return PropertyResolverUtils.updateProperty(propertyResolver.getProperties(), string, bl2);
    }

    public static Object updateProperty(Map map, String string, boolean bl2) {
        return PropertyResolverUtils.updateProperty(map, string, (Object)bl2);
    }

    public static String getStringProperty(PropertyResolver propertyResolver, String string, String string2) {
        String string3 = PropertyResolverUtils.getString(propertyResolver, string);
        if (GenericUtils.isEmpty(string3)) {
            return string2;
        }
        return string3;
    }

    public static String getStringProperty(Map map, String string, String string2) {
        Object object = PropertyResolverUtils.resolvePropertyValue(map, string);
        if (object == null) {
            return string2;
        }
        return Objects.toString(object);
    }

    public static Charset getCharset(PropertyResolver propertyResolver, String string, Charset charset) {
        Object object = PropertyResolverUtils.getObject(propertyResolver, string);
        return object == null ? charset : PropertyResolverUtils.toCharset(object);
    }

    public static Charset getCharset(Map map, String string, Charset charset) {
        Object object = PropertyResolverUtils.getObject(map, string);
        return object == null ? charset : PropertyResolverUtils.toCharset(object);
    }

    public static Charset toCharset(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Charset) {
            return (Charset)object;
        }
        if (object instanceof CharSequence) {
            return Charset.forName(object.toString());
        }
        throw new IllegalArgumentException("Invalid charset conversion value: " + object);
    }

    public static String getString(PropertyResolver propertyResolver, String string) {
        Object object = PropertyResolverUtils.getObject(propertyResolver, string);
        return Objects.toString(object, null);
    }

    public static String getString(Map map, String string) {
        Object object = PropertyResolverUtils.getObject(map, string);
        return Objects.toString(object, null);
    }

    public static Object getObject(PropertyResolver propertyResolver, String string) {
        return PropertyResolverUtils.resolvePropertyValue(propertyResolver, string);
    }

    public static Object getObject(PropertyResolver propertyResolver, String string, Object object) {
        Object object2 = PropertyResolverUtils.resolvePropertyValue(propertyResolver, string);
        return object2 != null ? object2 : object;
    }

    public static Object getObject(Map map, String string) {
        return PropertyResolverUtils.resolvePropertyValue(map, string);
    }

    public static Object resolvePropertyValue(Map map, String string) {
        String string2 = ValidateUtils.checkNotNullAndNotEmpty(string, "No property name");
        return map != null ? map.get(string2) : null;
    }

    public static Object updateProperty(PropertyResolver propertyResolver, String string, Object object) {
        return PropertyResolverUtils.updateProperty(propertyResolver.getProperties(), string, object);
    }

    public static Object updateProperty(Map map, String string, Object object) {
        String string2 = ValidateUtils.checkNotNullAndNotEmpty(string, "No property name");
        if (object == null || object instanceof CharSequence && GenericUtils.isEmpty((CharSequence)object)) {
            return map.remove(string2);
        }
        return map.put(string2, object);
    }

    public static Object resolvePropertyValue(PropertyResolver propertyResolver, String string) {
        String string2 = ValidateUtils.checkNotNullAndNotEmpty(string, "No property name");
        for (PropertyResolver propertyResolver2 = propertyResolver; propertyResolver2 != null; propertyResolver2 = propertyResolver2.getParentPropertyResolver()) {
            Map map = propertyResolver2.getProperties();
            Object object = PropertyResolverUtils.getObject(map, string2);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public static Map resolvePropertiesSource(PropertyResolver propertyResolver, String string) {
        String string2 = ValidateUtils.checkNotNullAndNotEmpty(string, "No property name");
        for (PropertyResolver propertyResolver2 = propertyResolver; propertyResolver2 != null; propertyResolver2 = propertyResolver2.getParentPropertyResolver()) {
            Map map = propertyResolver2.getProperties();
            Object object = PropertyResolverUtils.getObject(map, string2);
            if (object == null) continue;
            return map;
        }
        return null;
    }

    public static PropertyResolver toPropertyResolver(Properties properties) {
        if (MapEntryUtils.isEmpty(properties)) {
            return PropertyResolver.EMPTY;
        }
        Set<String> set = properties.stringPropertyNames();
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>(GenericUtils.size(set));
        for (String string : set) {
            String string2 = properties.getProperty(string);
            if (string2 == null) continue;
            concurrentHashMap.put(string, string2);
        }
        return PropertyResolverUtils.toPropertyResolver(concurrentHashMap);
    }

    public static PropertyResolver toPropertyResolver(Map map) {
        return PropertyResolverUtils.toPropertyResolver(map, null);
    }

    public static PropertyResolver toPropertyResolver(Map map, PropertyResolver propertyResolver) {
        return new PropertyResolverUtils$1(propertyResolver, map);
    }
}

