/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.nio.charset.Charset;
import java.util.Map;
import org.apache.sshd.common.PropertyResolver$1;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.util.MapEntryUtils;

public interface PropertyResolver {
    public static final PropertyResolver EMPTY = new PropertyResolver$1();

    public PropertyResolver getParentPropertyResolver();

    public Map getProperties();

    default public boolean isEmpty() {
        return MapEntryUtils.isEmpty(this.getProperties());
    }

    default public long getLongProperty(String string, long l2) {
        return PropertyResolverUtils.getLongProperty(this, string, l2);
    }

    default public Long getLong(String string) {
        return PropertyResolverUtils.getLong(this, string);
    }

    default public int getIntProperty(String string, int n2) {
        return PropertyResolverUtils.getIntProperty(this, string, n2);
    }

    default public Integer getInteger(String string) {
        return PropertyResolverUtils.getInteger(this, string);
    }

    default public boolean getBooleanProperty(String string, boolean bl2) {
        return PropertyResolverUtils.getBooleanProperty(this, string, bl2);
    }

    default public Boolean getBoolean(String string) {
        return PropertyResolverUtils.getBoolean(this, string);
    }

    default public String getStringProperty(String string, String string2) {
        return PropertyResolverUtils.getStringProperty(this, string, string2);
    }

    default public String getString(String string) {
        return PropertyResolverUtils.getString(this, string);
    }

    default public Object getObject(String string) {
        return PropertyResolverUtils.getObject(this, string);
    }

    default public Charset getCharset(String string, Charset charset) {
        Object object = this.getObject(string);
        return object == null ? charset : PropertyResolverUtils.toCharset(object);
    }

    public static boolean isEmpty(PropertyResolver propertyResolver) {
        return propertyResolver == null || propertyResolver.isEmpty();
    }
}

