/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.Property$BooleanProperty;
import org.apache.sshd.common.Property$CharsetProperty;
import org.apache.sshd.common.Property$DurationInSecondsProperty;
import org.apache.sshd.common.Property$DurationProperty;
import org.apache.sshd.common.Property$EnumProperty;
import org.apache.sshd.common.Property$IntegerProperty;
import org.apache.sshd.common.Property$LongProperty;
import org.apache.sshd.common.Property$ObjectProperty;
import org.apache.sshd.common.Property$StringProperty;
import org.apache.sshd.common.Property$Validating;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;

public interface Property
extends NamedResource {
    public static Property string(String string) {
        return Property.string(string, null);
    }

    public static Property string(String string, String string2) {
        return new Property$StringProperty(string, string2);
    }

    public static Property bool(String string) {
        return new Property$BooleanProperty(string);
    }

    public static Property bool(String string, boolean bl2) {
        return new Property$BooleanProperty(string, bl2);
    }

    public static Property integer(String string) {
        return new Property$IntegerProperty(string);
    }

    public static Property integer(String string, int n2) {
        return new Property$IntegerProperty(string, n2);
    }

    public static Property long_(String string) {
        return new Property$LongProperty(string);
    }

    public static Property long_(String string, long l2) {
        return new Property$LongProperty(string, l2);
    }

    public static Property enum_(String string, Class clazz) {
        return Property.enum_(string, clazz, null);
    }

    public static Property enum_(String string, Class clazz, Enum enum_) {
        return new Property$EnumProperty(string, clazz, enum_);
    }

    public static Property duration(String string) {
        return Property.duration(string, null);
    }

    public static Property duration(String string, Duration duration) {
        return new Property$DurationProperty(string, duration);
    }

    public static Property duration(String string, Duration duration, Duration duration2) {
        return new Property$DurationProperty(string, duration, duration2);
    }

    public static Property durationSec(String string) {
        return Property.durationSec(string, null);
    }

    public static Property durationSec(String string, Duration duration) {
        return new Property$DurationInSecondsProperty(string, duration);
    }

    public static Property durationSec(String string, Duration duration, Duration duration2) {
        return new Property$DurationInSecondsProperty(string, duration, duration2);
    }

    public static Property charset(String string) {
        return Property.charset(string, null);
    }

    public static Property charset(String string, Charset charset) {
        return new Property$CharsetProperty(string, charset);
    }

    public static Property object(String string) {
        return Property.object(string, null);
    }

    public static Property object(String string, Object object) {
        return new Property$ObjectProperty(string, object);
    }

    public static Property validating(Property property, Consumer consumer) {
        return new Property$Validating(property, consumer);
    }

    public Class getType();

    public Optional getDefault();

    default public Object getRequiredDefault() {
        return this.getDefault().get();
    }

    public Optional get(PropertyResolver var1);

    default public Object getRequired(PropertyResolver propertyResolver) {
        return this.get(propertyResolver).get();
    }

    default public Object getOrNull(PropertyResolver propertyResolver) {
        return this.getOrCustomDefault(propertyResolver, null);
    }

    public Object getOrCustomDefault(PropertyResolver var1, Object var2);

    public void set(PropertyResolver var1, Object var2);

    default public void remove(PropertyResolver propertyResolver) {
        PropertyResolverUtils.updateProperty(propertyResolver, this.getName(), null);
    }
}

