/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.time.Duration;
import org.apache.sshd.common.Property$BaseProperty;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class Property$DurationProperty
extends Property$BaseProperty {
    protected final Duration min;

    public Property$DurationProperty(String string) {
        this(string, (Duration)null);
    }

    public Property$DurationProperty(String string, Duration duration) {
        super(string, Duration.class, duration);
        this.min = null;
    }

    public Property$DurationProperty(String string, Duration duration, Duration duration2) {
        super(string, Duration.class, Property$DurationProperty.atLeast(string, duration, duration2));
        this.min = duration2;
    }

    protected Object toStorage(Duration duration) {
        Property$DurationProperty.atLeast(this.getName(), duration, this.min);
        return duration != null ? Long.valueOf(duration.toMillis()) : null;
    }

    @Override
    protected Duration fromStorage(Object object) {
        Long l2 = PropertyResolverUtils.toLong(object);
        return l2 != null ? Duration.ofMillis(l2) : null;
    }

    private static Long toMillis(Duration duration) {
        return duration == null ? null : Long.valueOf(duration.toMillis());
    }

    protected static Duration atLeast(String string, Duration duration, Duration duration2) {
        if (duration2 != null) {
            ValidateUtils.checkTrue(duration != null && duration2.compareTo(duration) <= 0, "Property %s must be at least %d ms; actual value: %d ms", string, Property$DurationProperty.toMillis(duration2), Property$DurationProperty.toMillis(duration));
        }
        return duration;
    }
}

